/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.executor;

import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.jdbc.base.DefaultParameterPreparer;
import io.polaris.core.jdbc.base.JdbcOptions;
import io.polaris.core.jdbc.base.StatementPreparer;
import io.polaris.core.jdbc.executor.BatchResult;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.lang.bean.MetaObject;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class JdbcBatch {
    private static final ILogger log = ILoggers.of(JdbcBatch.class);
    private static final JdbcOptions DEFAULT_OPTIONS = JdbcOptions.ofDefault();
    private final List<BatchResult> resultList = new ArrayList<BatchResult>();
    private String currentSql;
    private Connection currentConnection;
    private PreparedStatement currentStatement;
    private List<Object> currentBindingsList;
    private String[] currentKeyProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCurrent() throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.currentStatement;
            if (st == null) {
                return;
            }
            log.debug("\u6267\u884c\u6279\u5904\u7406SQL\uff1a{}", this.currentSql);
            int[] rows = st.executeBatch();
            String[] keyProperties = this.currentKeyProperties;
            if (ObjectArrays.isNotEmpty(keyProperties)) {
                rs = st.getGeneratedKeys();
                for (Object o : this.currentBindingsList) {
                    if (!rs.next()) break;
                    MetaObject<?> metaObject = MetaObject.of(o.getClass());
                    for (int i = 0; i < keyProperties.length; ++i) {
                        Object val = rs.getObject(i + 1);
                        metaObject.setPathProperty(o, keyProperties[i], val);
                    }
                }
            }
            this.resultList.add(new BatchResult(this.currentSql, rows));
            this.currentSql = null;
            this.currentConnection = null;
            this.currentStatement = null;
            this.currentBindingsList = null;
            this.currentKeyProperties = null;
        }
        finally {
            Jdbcs.close(rs);
            Jdbcs.close(st);
        }
    }

    public List<BatchResult> flush() throws SQLException {
        this.flushCurrent();
        return this.resultList;
    }

    public void update(@Nonnull Connection conn, @Nonnull String sql, @Nonnull JdbcOptions options, StatementPreparer preparer, Object generatedKeyBinding) throws SQLException {
        if (sql.equals(this.currentSql) && conn.equals(this.currentConnection)) {
            if (preparer != null) {
                preparer.setParameters(this.currentStatement, DefaultParameterPreparer.orDefault(options.getParameterPreparer()));
            }
            if (this.currentBindingsList != null) {
                this.currentBindingsList.add(generatedKeyBinding);
            }
            this.currentStatement.addBatch();
            return;
        }
        if (this.currentSql != null && this.currentConnection != null) {
            this.flushCurrent();
            this.currentSql = null;
            this.currentConnection = null;
            this.currentStatement = null;
            this.currentBindingsList = null;
        }
        PreparedStatement st = Jdbcs.prepareStatement(conn, sql, options);
        if (preparer != null) {
            preparer.setParameters(st, null);
        }
        st.addBatch();
        this.currentSql = sql;
        this.currentConnection = conn;
        this.currentStatement = st;
        String[] keyProperties = options.getKeyProperties();
        if (options.isUseGeneratedKeys() && ObjectArrays.isNotEmpty(keyProperties)) {
            this.currentKeyProperties = options.getKeyProperties();
            this.currentBindingsList = new ArrayList<Object>();
        }
    }

    public void update(Connection conn, SqlNode sql) throws SQLException {
        PreparedSql preparedSql = sql.asPreparedSql();
        this.update(conn, preparedSql.getText(), Jdbcs.preparerOfParameters(preparedSql.getBindings()));
    }

    public void update(Connection conn, SqlNode sql, @Nonnull JdbcOptions options) throws SQLException {
        PreparedSql preparedSql = sql.asPreparedSql();
        this.update(conn, preparedSql.getText(), options, Jdbcs.preparerOfParameters(preparedSql.getBindings()), null);
    }

    public void update(Connection conn, SqlNode sql, @Nonnull JdbcOptions options, Object generatedKeyBinding) throws SQLException {
        PreparedSql preparedSql = sql.asPreparedSql();
        this.update(conn, preparedSql.getText(), options, Jdbcs.preparerOfParameters(preparedSql.getBindings()), generatedKeyBinding);
    }

    public void update(Connection conn, String sql) throws SQLException {
        this.update(conn, sql, DEFAULT_OPTIONS, null, null);
    }

    public void update(Connection conn, String sql, Iterable<?> parameters) throws SQLException {
        this.update(conn, sql, DEFAULT_OPTIONS, Jdbcs.preparerOfParameters(parameters), null);
    }

    public void update(Connection conn, String sql, Object[] parameters) throws SQLException {
        this.update(conn, sql, DEFAULT_OPTIONS, Jdbcs.preparerOfParameters(parameters), null);
    }

    public void update(Connection conn, String sql, StatementPreparer preparer) throws SQLException {
        this.update(conn, sql, DEFAULT_OPTIONS, preparer, null);
    }
}

