/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql;

import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.jdbc.annotation.EntityDelete;
import io.polaris.core.jdbc.annotation.EntityInsert;
import io.polaris.core.jdbc.annotation.EntityMerge;
import io.polaris.core.jdbc.annotation.EntitySelect;
import io.polaris.core.jdbc.annotation.EntityUpdate;
import io.polaris.core.jdbc.annotation.SqlDelete;
import io.polaris.core.jdbc.annotation.SqlEntity;
import io.polaris.core.jdbc.annotation.SqlInsert;
import io.polaris.core.jdbc.annotation.SqlRaw;
import io.polaris.core.jdbc.annotation.SqlRawSimple;
import io.polaris.core.jdbc.annotation.SqlSelect;
import io.polaris.core.jdbc.annotation.SqlSelectSet;
import io.polaris.core.jdbc.annotation.SqlUpdate;
import io.polaris.core.jdbc.annotation.segment.BindingKey;
import io.polaris.core.jdbc.annotation.segment.Condition;
import io.polaris.core.jdbc.annotation.segment.Criteria1;
import io.polaris.core.jdbc.annotation.segment.Criteria2;
import io.polaris.core.jdbc.annotation.segment.Criteria3;
import io.polaris.core.jdbc.annotation.segment.Criteria4;
import io.polaris.core.jdbc.annotation.segment.Criteria5;
import io.polaris.core.jdbc.annotation.segment.Criterion;
import io.polaris.core.jdbc.annotation.segment.Function;
import io.polaris.core.jdbc.annotation.segment.GroupBy;
import io.polaris.core.jdbc.annotation.segment.Having;
import io.polaris.core.jdbc.annotation.segment.InsertColumn;
import io.polaris.core.jdbc.annotation.segment.Join;
import io.polaris.core.jdbc.annotation.segment.JoinColumn;
import io.polaris.core.jdbc.annotation.segment.JoinCriterion;
import io.polaris.core.jdbc.annotation.segment.SelectColumn;
import io.polaris.core.jdbc.annotation.segment.SqlRawItem;
import io.polaris.core.jdbc.annotation.segment.SubCriteria;
import io.polaris.core.jdbc.annotation.segment.SubCriteria1;
import io.polaris.core.jdbc.annotation.segment.SubCriteria2;
import io.polaris.core.jdbc.annotation.segment.SubCriteria3;
import io.polaris.core.jdbc.annotation.segment.SubCriteria4;
import io.polaris.core.jdbc.annotation.segment.SubCriteria5;
import io.polaris.core.jdbc.annotation.segment.SubCriterion;
import io.polaris.core.jdbc.annotation.segment.SubHaving;
import io.polaris.core.jdbc.annotation.segment.SubSelect;
import io.polaris.core.jdbc.annotation.segment.SubWhere;
import io.polaris.core.jdbc.annotation.segment.UpdateColumn;
import io.polaris.core.jdbc.annotation.segment.Where;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.consts.JoinType;
import io.polaris.core.jdbc.sql.consts.Relation;
import io.polaris.core.jdbc.sql.consts.SelectSetOps;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.query.Queries;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.jdbc.sql.statement.ConfigurableColumnPredicate;
import io.polaris.core.jdbc.sql.statement.DeleteStatement;
import io.polaris.core.jdbc.sql.statement.InsertStatement;
import io.polaris.core.jdbc.sql.statement.MergeStatement;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.SetOpsStatement;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.UpdateStatement;
import io.polaris.core.jdbc.sql.statement.segment.CriterionSegment;
import io.polaris.core.jdbc.sql.statement.segment.GroupBySegment;
import io.polaris.core.jdbc.sql.statement.segment.JoinSegment;
import io.polaris.core.jdbc.sql.statement.segment.OrderBySegment;
import io.polaris.core.jdbc.sql.statement.segment.SelectSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.jdbc.sql.statement.segment.WhereSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.regex.Patterns;
import io.polaris.core.script.Evaluator;
import io.polaris.core.script.ScriptEvaluators;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple1;
import io.polaris.core.tuple.Tuple3;
import io.polaris.core.tuple.ValueRef;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public class EntityStatements {
    public static final String DEFAULT_TABLE_ALIAS = "T";

    public static TableMeta getTableMeta(String entityClassName) {
        return TableMetaKit.instance().get(entityClassName);
    }

    public static TableAccessible asTableAccessible(SqlEntity sqlEntityDeclared) {
        String[] aliases;
        Class<?>[] tables;
        int len;
        TableAccessible tableAccessible = null;
        if (sqlEntityDeclared != null && (len = Integer.min((tables = sqlEntityDeclared.table()).length, (aliases = sqlEntityDeclared.alias()).length)) > 0) {
            TableSegment[] tableSegments = new TableSegment[len];
            for (int i = 0; i < len; ++i) {
                tableSegments[i] = TableSegment.fromEntity(tables[i], aliases[i]);
            }
            tableAccessible = TableAccessible.of(tableSegments);
        }
        return tableAccessible;
    }

    public static java.util.function.Function<Map<String, Object>, SqlNode> buildSqlUpdateFunction(Method method) {
        EntityInsert entityInsert = method.getAnnotation(EntityInsert.class);
        if (entityInsert != null) {
            return bindings -> EntityStatements.buildInsert((Map<String, Object>)bindings, entityInsert).toSqlNode();
        }
        EntityDelete entityDelete = method.getAnnotation(EntityDelete.class);
        if (entityDelete != null) {
            return bindings -> EntityStatements.buildDelete((Map<String, Object>)bindings, entityDelete).toSqlNode();
        }
        EntityUpdate entityUpdate = method.getAnnotation(EntityUpdate.class);
        if (entityUpdate != null) {
            return bindings -> EntityStatements.buildUpdate((Map<String, Object>)bindings, entityUpdate).toSqlNode();
        }
        EntityMerge entityMerge = method.getAnnotation(EntityMerge.class);
        if (entityMerge != null) {
            return bindings -> EntityStatements.buildMerge(bindings, entityMerge).toSqlNode();
        }
        SqlInsert sqlInsert = method.getAnnotation(SqlInsert.class);
        if (sqlInsert != null) {
            return bindings -> EntityStatements.buildInsert((Map<String, Object>)bindings, sqlInsert).toSqlNode();
        }
        SqlDelete sqlDelete = method.getAnnotation(SqlDelete.class);
        if (sqlDelete != null) {
            return bindings -> EntityStatements.buildDelete((Map<String, Object>)bindings, sqlDelete).toSqlNode();
        }
        SqlUpdate sqlUpdate = method.getAnnotation(SqlUpdate.class);
        if (sqlUpdate != null) {
            return bindings -> EntityStatements.buildUpdate((Map<String, Object>)bindings, sqlUpdate).toSqlNode();
        }
        return EntityStatements.buildSqlRawFunction(method);
    }

    public static java.util.function.Function<Map<String, Object>, SqlNode> buildSqlSelectFunction(Method method) {
        EntitySelect entitySelect = method.getAnnotation(EntitySelect.class);
        if (entitySelect != null) {
            if (entitySelect.count()) {
                return bindings -> EntityStatements.buildSelect((Map<String, Object>)bindings, entitySelect).toCountSqlNode();
            }
            return bindings -> EntityStatements.buildSelect((Map<String, Object>)bindings, entitySelect).toSqlNode();
        }
        Annotation sqlSelect = method.getAnnotation(SqlSelect.class);
        if (sqlSelect != null) {
            if (sqlSelect.count()) {
                return arg_0 -> EntityStatements.lambda$buildSqlSelectFunction$9((SqlSelect)sqlSelect, arg_0);
            }
            return arg_0 -> EntityStatements.lambda$buildSqlSelectFunction$10((SqlSelect)sqlSelect, arg_0);
        }
        sqlSelect = method.getAnnotation(SqlSelectSet.class);
        if (sqlSelect != null) {
            if (sqlSelect.count()) {
                return arg_0 -> EntityStatements.lambda$buildSqlSelectFunction$11((SqlSelectSet)sqlSelect, arg_0);
            }
            return arg_0 -> EntityStatements.lambda$buildSqlSelectFunction$12((SqlSelectSet)sqlSelect, arg_0);
        }
        return EntityStatements.buildSqlRawFunction(method);
    }

    public static java.util.function.Function<Map<String, Object>, SqlNode> buildSqlRawFunction(Method method) {
        TableAccessible tableAccessible = EntityStatements.asTableAccessible(method.getAnnotation(SqlEntity.class));
        Annotation sqlRaw = method.getAnnotation(SqlRawSimple.class);
        if (sqlRaw != null) {
            if (tableAccessible != null) {
                TableAccessible finalTableAccessible = tableAccessible;
                return arg_0 -> EntityStatements.lambda$buildSqlRawFunction$14((SqlRawSimple)sqlRaw, finalTableAccessible, arg_0);
            }
            return arg_0 -> EntityStatements.lambda$buildSqlRawFunction$16((SqlRawSimple)sqlRaw, arg_0);
        }
        sqlRaw = method.getAnnotation(SqlRaw.class);
        if (sqlRaw != null) {
            SqlRawItemModel[] items = SqlRawItemModel.of((SqlRaw)sqlRaw);
            TableAccessible finalTableAccessible = tableAccessible;
            return bindings -> {
                HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
                return EntityStatements.buildSqlRaw(cache, bindings, items, finalTableAccessible);
            };
        }
        return bindings -> {
            Object sql = bindings.get("_sql");
            if (sql instanceof SqlNode) {
                return (SqlNode)sql;
            }
            if (sql instanceof SqlNodeBuilder) {
                return ((SqlNodeBuilder)sql).toSqlNode();
            }
            throw new IllegalArgumentException("\u7f3a\u5c11SQL\u53c2\u6570\uff1a`_sql`");
        };
    }

    private static ContainerNode buildSqlRaw(ContainerNode sql, java.util.function.Function<String, Object> valueResolver) {
        sql.visitSubset(node -> {
            if (node.isVarNode() && node.getVarValue() == null) {
                String varName = node.getVarName();
                Object varVal = valueResolver.apply(varName);
                node.bindVarValue(varVal);
            }
        });
        return sql;
    }

    private static ContainerNode buildSqlRaw(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SqlRawItemModel[] items, TableAccessible tableAccessible) {
        ArrayList<SqlRawItemModel> activeItems = new ArrayList<SqlRawItemModel>(items.length);
        SqlRawItemModel defaultItem = null;
        for (SqlRawItemModel item : items) {
            if (EntityStatements.isDefaultCondition(item.condition)) {
                defaultItem = item;
            }
            if (!EntityStatements.evalConditionPredicate(cache, bindings, null, item.condition)) continue;
            activeItems.add(item);
        }
        if (activeItems.isEmpty() && defaultItem != null) {
            activeItems.add(defaultItem);
        }
        ContainerNode sql = new ContainerNode();
        int activeItemsSize = activeItems.size();
        for (int j = 0; j < activeItemsSize; ++j) {
            String forEachKey;
            SqlRawItemModel item;
            if (j > 0) {
                sql.addNode(SqlNodes.BLANK);
            }
            if (Strings.isNotBlank(forEachKey = (item = (SqlRawItemModel)activeItems.get(j)).forEachKey)) {
                int size;
                int i2;
                Object collection = BindingValues.getBindingValueOrDefault(cache, bindings, forEachKey, null);
                if (collection == null) continue;
                boolean isArray = collection.getClass().isArray();
                ArrayList subSqlList = new ArrayList();
                BiConsumer<Integer, Object> itemConsumer = (i, ele) -> {
                    List subset;
                    if (Strings.isNotBlank(item.itemKey)) {
                        cache.put(item.itemKey, ValueRef.of(ele));
                    }
                    if (Strings.isNotBlank(item.indexKey)) {
                        cache.put(item.indexKey, ValueRef.of(i));
                    }
                    ContainerNode itemSql = (subset = item.subset) != null ? EntityStatements.buildSqlRaw(cache, bindings, subset.toArray(new SqlRawItemModel[0]), tableAccessible) : SqlTextParsers.parse(SqlTextParsers.resolveTableRef(item.sqlText, tableAccessible));
                    ContainerNode subSql = EntityStatements.buildSqlRaw(itemSql, key -> BindingValues.getBindingValueOrDefault(cache, bindings, key, null));
                    subSqlList.add(subSql);
                };
                if (isArray) {
                    int len = Array.getLength(collection);
                    for (i2 = 0; i2 < len; ++i2) {
                        Object ele2 = Array.get(collection, i2);
                        itemConsumer.accept(i2, ele2);
                    }
                } else {
                    if (!(collection instanceof Iterable)) continue;
                    int i3 = 0;
                    for (Object ele2 : (Iterable)collection) {
                        itemConsumer.accept(i3, ele2);
                        ++i3;
                    }
                }
                if ((size = subSqlList.size()) <= 0) continue;
                sql.addNode(SqlTextParsers.parse(SqlTextParsers.resolveTableRef(item.open, tableAccessible)));
                for (i2 = 0; i2 < size; ++i2) {
                    if (i2 > 0) {
                        sql.addNode(SqlTextParsers.parse(SqlTextParsers.resolveTableRef(item.separator, tableAccessible)));
                    }
                    sql.addNode((SqlNode)subSqlList.get(i2));
                }
                sql.addNode(SqlTextParsers.parse(SqlTextParsers.resolveTableRef(item.close, tableAccessible)));
                continue;
            }
            List subset = item.subset;
            ContainerNode itemSql = subset != null ? EntityStatements.buildSqlRaw(cache, bindings, subset.toArray(new SqlRawItemModel[0]), tableAccessible) : SqlTextParsers.parse(SqlTextParsers.resolveTableRef(item.sqlText, tableAccessible));
            ContainerNode subSql = EntityStatements.buildSqlRaw(itemSql, key -> BindingValues.getBindingValueOrDefault(cache, bindings, key, null));
            sql.addNode(subSql);
        }
        return sql;
    }

    public static InsertStatement<?> buildInsert(Map<String, Object> bindings, SqlInsert sqlInsert) {
        Class<?> entityClass = sqlInsert.table();
        InsertStatement st = new InsertStatement(entityClass);
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        InsertColumn[] columns = sqlInsert.columns();
        HashMap values = new HashMap();
        for (InsertColumn column : columns) {
            String field = column.field();
            Tuple1<?> val = EntityStatements.getValForBindingKey(cache, bindings, column.bindingKey());
            values.put(field, val);
        }
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String field = entry.getKey();
            ColumnMeta meta = entry.getValue();
            Tuple1 tuple = (Tuple1)values.get(field);
            Object val = null;
            boolean enabled = false;
            if (tuple != null) {
                enabled = true;
                val = tuple.getFirst();
            }
            val = BindingValues.getValueForInsert(meta, val);
            if (!enabled && val == null) continue;
            st.column(field, val);
        }
        if (sqlInsert.enableReplace()) {
            st.enableReplace(true);
        }
        if (sqlInsert.enableUpdateByDuplicateKey()) {
            st.enableUpdateByDuplicateKey(true);
        }
        return st;
    }

    public static DeleteStatement<?> buildDelete(Map<String, Object> bindings, SqlDelete sqlDelete) {
        Class<?> entityClass = sqlDelete.table();
        if (entityClass == null || entityClass == Void.TYPE) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DeleteStatement st = new DeleteStatement(entityClass, Strings.coalesce(sqlDelete.alias(), DEFAULT_TABLE_ALIAS));
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        EntityStatements.addWhereClause(cache, bindings, st.where(), sqlDelete.where(), sqlDelete.columnPredicate());
        return st;
    }

    public static UpdateStatement<?> buildUpdate(Map<String, Object> bindings, SqlUpdate sqlUpdate) {
        Class<?> entityClass = sqlUpdate.table();
        UpdateStatement st = new UpdateStatement(entityClass, Strings.coalesce(sqlUpdate.alias(), DEFAULT_TABLE_ALIAS));
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        UpdateColumn[] columns = sqlUpdate.columns();
        HashMap values = new HashMap();
        for (UpdateColumn column : columns) {
            String field = column.field();
            Tuple1<?> val = EntityStatements.getValForBindingKey(cache, bindings, column.bindingKey());
            values.put(field, val);
        }
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String field = entry.getKey();
            ColumnMeta meta = entry.getValue();
            Tuple1 tuple = (Tuple1)values.get(field);
            Object val = null;
            boolean enabled = false;
            if (tuple != null) {
                enabled = true;
                val = tuple.getFirst();
            }
            val = BindingValues.getValueForUpdate(meta, val);
            if (!enabled && val == null) continue;
            st.column(field, val);
        }
        EntityStatements.addWhereClause(cache, bindings, st.where(), sqlUpdate.where(), sqlUpdate.columnPredicate());
        return st;
    }

    public static SetOpsStatement<?> buildSelectSet(Map<String, Object> bindings, SqlSelectSet sqlSelectSet) {
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        SetOpsStatement<?> sos = null;
        SqlSelectSet.Item[] items = sqlSelectSet.value();
        ArrayList<SqlSelectSet.Item> activeItems = new ArrayList<SqlSelectSet.Item>(items.length);
        SqlSelectSet.Item defaultItem = null;
        for (SqlSelectSet.Item item : items) {
            if (EntityStatements.isDefaultCondition(item.condition())) {
                defaultItem = item;
            }
            if (!EntityStatements.evalConditionPredicate(cache, bindings, null, item.condition())) continue;
            activeItems.add(item);
        }
        if (activeItems.isEmpty() && defaultItem != null) {
            activeItems.add(defaultItem);
        }
        for (SqlSelectSet.Item item : activeItems) {
            SqlSelect sqlSelect = item.value();
            SelectStatement<?> st = EntityStatements.buildSelect(cache, bindings, sqlSelect);
            if (sos == null) {
                sos = SetOpsStatement.of(st);
                continue;
            }
            SelectSetOps ops = item.ops();
            switch (ops) {
                case UNION: {
                    sos.union(st);
                    break;
                }
                case UNION_ALL: {
                    sos.unionAll(st);
                    break;
                }
                case INTERSECT: {
                    sos.intersect(st);
                    break;
                }
                case INTERSECT_ALL: {
                    sos.intersectAll(st);
                    break;
                }
                case MINUS: {
                    sos.minus(st);
                    break;
                }
                case MINUS_ALL: {
                    sos.minusAll(st);
                    break;
                }
                case EXCEPT: {
                    sos.except(st);
                    break;
                }
                case EXCEPT_ALL: {
                    sos.exceptAll(st);
                    break;
                }
            }
        }
        return sos;
    }

    public static SelectStatement<?> buildSelect(Map<String, Object> bindings, SqlSelect sqlSelect) {
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        return EntityStatements.buildSelect(cache, bindings, sqlSelect);
    }

    private static SelectStatement<?> buildSelect(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SqlSelect sqlSelect) {
        Class<?> entityClass = sqlSelect.table();
        SelectStatement st = new SelectStatement(entityClass, Strings.coalesce(sqlSelect.alias(), DEFAULT_TABLE_ALIAS));
        EntityStatements.addSelectColumns(cache, bindings, st, sqlSelect.columns(), sqlSelect.quotaSelectAlias());
        EntityStatements.addJoinClause(cache, bindings, st, sqlSelect.join());
        EntityStatements.addWhereClause(cache, bindings, st.where(), sqlSelect.where(), sqlSelect.columnPredicate());
        EntityStatements.addGroupByClause(cache, bindings, st, sqlSelect.groupBy());
        EntityStatements.addHavingClause(cache, bindings, st, sqlSelect.having());
        EntityStatements.addOrderByClause(cache, bindings, st, sqlSelect);
        return st;
    }

    private static void addSelectColumns(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, SelectColumn[] columns, boolean quotaSelectAlias) {
        if (columns != null && columns.length > 0) {
            ArrayList<SelectColumn> activeCols = new ArrayList<SelectColumn>(columns.length);
            SelectColumn defaultCol = null;
            for (SelectColumn col : columns) {
                if (EntityStatements.isDefaultCondition(col.condition())) {
                    defaultCol = col;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, col.condition())) continue;
                activeCols.add(col);
            }
            if (activeCols.isEmpty() && defaultCol != null) {
                activeCols.add(defaultCol);
            }
            for (SelectColumn col : activeCols) {
                String raw = col.raw();
                if (Strings.isNotBlank(raw)) {
                    st.selectRaw(raw);
                    continue;
                }
                String field = col.field();
                Object seg = st.select();
                if (Strings.isNotBlank(field)) {
                    ((SelectSegment)seg).column(field);
                    for (Function function : col.functions()) {
                        Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
                        if (functionTuple == null) continue;
                        String expr = functionTuple.getFirst();
                        TableField[] tableFields = functionTuple.getSecond();
                        Object[] args = functionTuple.getThird();
                        seg = args != null ? ((SelectSegment)seg).apply(expr, tableFields, args) : ((SelectSegment)seg).apply(expr, tableFields, bindings);
                    }
                    ((SelectSegment)seg).aliasWithField(col.aliasWithField());
                    ((SelectSegment)seg).alias(col.alias());
                    ((SelectSegment)seg).aliasPrefix(col.aliasPrefix());
                    ((SelectSegment)seg).aliasSuffix(col.aliasSuffix());
                    continue;
                }
                String valueKey = col.valueKey();
                if (Strings.isNotBlank(valueKey)) {
                    Object v = BindingValues.getBindingValueOrDefault(cache, bindings, valueKey, null);
                    ((SelectSegment)seg).value(v, col.alias());
                    ((SelectSegment)seg).aliasPrefix(col.aliasPrefix());
                    ((SelectSegment)seg).aliasSuffix(col.aliasSuffix());
                    continue;
                }
                throw new IllegalArgumentException("\u672a\u6307\u5b9a\u5b57\u6bb5\u540d\u6216\u56fa\u5b9a\u952e\u503c");
            }
        } else {
            st.selectAll();
        }
        st.quotaSelectAlias(quotaSelectAlias);
    }

    private static void addJoinClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, Join[] joins) {
        if (joins.length > 0) {
            ArrayList<Join> activeJoins = new ArrayList<Join>();
            Join defaultJoin = null;
            for (Join join : joins) {
                if (EntityStatements.isDefaultCondition(join.condition())) {
                    defaultJoin = join;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, join.condition())) continue;
                activeJoins.add(join);
            }
            if (activeJoins.isEmpty() && defaultJoin != null) {
                activeJoins.add(defaultJoin);
            }
            for (Join join : activeJoins) {
                Class<?> joinTable = join.table();
                String joinAlias = join.alias();
                if (joinTable == null || joinTable == Void.TYPE) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u8fde\u63a5\u8868\u5b9e\u4f53\u7c7b\u578b");
                }
                if (Strings.isBlank(joinAlias)) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u8fde\u63a5\u8868\u522b\u540d");
                }
                JoinType joinType = join.type();
                Object joinSt = joinType == JoinType.JOIN ? st.join(joinTable, joinAlias) : (joinType == JoinType.INNER_JOIN ? st.innerJoin(joinTable, joinAlias) : (joinType == JoinType.LEFT_JOIN ? st.leftJoin(joinTable, joinAlias) : (joinType == JoinType.RIGHT_JOIN ? st.rightJoin(joinTable, joinAlias) : st.outerJoin(joinTable, joinAlias))));
                EntityStatements.addJoinSelectColumns(cache, bindings, joinSt, join.columns());
                Object on = ((JoinSegment)joinSt).on();
                for (io.polaris.core.jdbc.annotation.segment.Criteria criteria : join.on()) {
                    EntityStatements.addWhereByCriteria(cache, bindings, criteria, on);
                }
                EntityStatements.addJoinWhereClause(cache, bindings, joinSt, join);
                EntityStatements.addJoinGroupByClause(cache, bindings, joinSt, join.groupBy());
                EntityStatements.addJoinHavingClause(cache, bindings, joinSt, join.having());
                EntityStatements.addJoinOrderByClause(cache, bindings, joinSt, join);
            }
        }
    }

    private static void addJoinSelectColumns(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinSegment<?, ?> st, SelectColumn[] columns) {
        if (columns != null && columns.length > 0) {
            ArrayList<SelectColumn> activeCols = new ArrayList<SelectColumn>(columns.length);
            SelectColumn defaultCol = null;
            for (SelectColumn col : columns) {
                if (EntityStatements.isDefaultCondition(col.condition())) {
                    defaultCol = col;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, col.condition())) continue;
                activeCols.add(col);
            }
            if (activeCols.isEmpty() && defaultCol != null) {
                activeCols.add(defaultCol);
            }
            for (SelectColumn col : activeCols) {
                String raw = col.raw();
                if (Strings.isNotBlank(raw)) {
                    st.selectRaw(raw);
                    continue;
                }
                String field = col.field();
                Object seg = st.select();
                if (Strings.isNotBlank(field)) {
                    ((SelectSegment)seg).column(field);
                    for (Function function : col.functions()) {
                        Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
                        if (functionTuple == null) continue;
                        String expr = functionTuple.getFirst();
                        TableField[] tableFields = functionTuple.getSecond();
                        Object[] args = functionTuple.getThird();
                        seg = args != null ? ((SelectSegment)seg).apply(expr, tableFields, args) : ((SelectSegment)seg).apply(expr, tableFields, bindings);
                    }
                    ((SelectSegment)seg).aliasWithField(col.aliasWithField());
                    ((SelectSegment)seg).alias(col.alias());
                    ((SelectSegment)seg).aliasPrefix(col.aliasPrefix());
                    ((SelectSegment)seg).aliasSuffix(col.aliasSuffix());
                    continue;
                }
                String valueKey = col.valueKey();
                if (Strings.isNotBlank(valueKey)) {
                    Object v = BindingValues.getBindingValueOrDefault(bindings, valueKey, null);
                    ((SelectSegment)seg).value(v, col.alias());
                    ((SelectSegment)seg).aliasPrefix(col.aliasPrefix());
                    ((SelectSegment)seg).aliasSuffix(col.aliasSuffix());
                    continue;
                }
                throw new IllegalArgumentException("\u672a\u6307\u5b9a\u5b57\u6bb5\u540d\u6216\u56fa\u5b9a\u952e\u503c");
            }
        } else {
            st.selectAll();
        }
    }

    private static void addJoinWhereClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinSegment<?, ?> st, Join join) {
        Object entity;
        Object stWhere = st.where();
        Where where = join.where();
        String entityIdKey = where.byEntityIdKey();
        String entityKey = where.byEntityKey();
        if (Strings.isNotBlank(entityIdKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityIdKey, Collections.emptyMap());
            ((WhereSegment)stWhere).byEntityId(entity);
        }
        if (Strings.isNotBlank(entityKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityKey, Collections.emptyMap());
            ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, join.columnPredicate());
            ((WhereSegment)stWhere).byEntity(entity, columnPredicate);
        }
        if (where.relation() == Relation.OR) {
            stWhere = ((WhereSegment)stWhere).or();
        }
        for (io.polaris.core.jdbc.annotation.segment.Criteria criteria : where.criteria()) {
            EntityStatements.addWhereByCriteria(cache, bindings, criteria, stWhere);
        }
    }

    private static void addJoinGroupByClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinSegment<?, ?> st, GroupBy[] groupBys) {
        if (groupBys != null && groupBys.length > 0) {
            ArrayList<GroupBy> activeGroupBys = new ArrayList<GroupBy>(groupBys.length);
            GroupBy defaultGroupBy = null;
            for (GroupBy groupBy : groupBys) {
                if (EntityStatements.isDefaultCondition(groupBy.condition())) {
                    defaultGroupBy = groupBy;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, groupBy.condition())) continue;
                activeGroupBys.add(groupBy);
            }
            if (activeGroupBys.isEmpty() && defaultGroupBy != null) {
                activeGroupBys.add(defaultGroupBy);
            }
            for (GroupBy groupBy : activeGroupBys) {
                String raw = groupBy.raw();
                String field = groupBy.field();
                if (Strings.isNotBlank(raw)) {
                    ((GroupBySegment)st.groupBy()).rawColumn(raw);
                    continue;
                }
                if (!Strings.isNotBlank(field)) continue;
                ((GroupBySegment)st.groupBy()).column(field);
            }
        }
    }

    private static void addJoinHavingClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinSegment<?, ?> st, Having having) {
        io.polaris.core.jdbc.annotation.segment.Criteria[] havingCriteria = having.criteria();
        Relation havingRelation = having.relation();
        if (havingCriteria != null && havingCriteria.length > 0) {
            Object ws = st.having();
            if (havingRelation == Relation.OR) {
                ws = ((WhereSegment)ws).or();
            }
            for (io.polaris.core.jdbc.annotation.segment.Criteria criteria : havingCriteria) {
                EntityStatements.addWhereByCriteria(cache, bindings, criteria, ws);
            }
        }
    }

    private static void addJoinOrderByClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinSegment<?, ?> st, Join sqlSelect) {
        io.polaris.core.jdbc.annotation.segment.OrderBy[] orderBys = sqlSelect.orderBy();
        if (orderBys.length > 0) {
            ArrayList<io.polaris.core.jdbc.annotation.segment.OrderBy> activeOrderBys = new ArrayList<io.polaris.core.jdbc.annotation.segment.OrderBy>(orderBys.length);
            io.polaris.core.jdbc.annotation.segment.OrderBy defaultOrderBy = null;
            for (io.polaris.core.jdbc.annotation.segment.OrderBy orderBy : orderBys) {
                if (EntityStatements.isDefaultCondition(orderBy.condition())) {
                    defaultOrderBy = orderBy;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, orderBy.condition())) continue;
                activeOrderBys.add(orderBy);
            }
            if (activeOrderBys.isEmpty() && defaultOrderBy != null) {
                activeOrderBys.add(defaultOrderBy);
            }
            for (io.polaris.core.jdbc.annotation.segment.OrderBy orderBy : activeOrderBys) {
                String raw = orderBy.raw();
                if (Strings.isNotBlank(raw)) {
                    st.orderByRaw(raw);
                    continue;
                }
                String field = orderBy.field();
                if (Strings.isBlank(field)) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u6392\u5e8f\u5b57\u6bb5\u540d");
                }
                Object seg = st.orderBy();
                ((OrderBySegment)seg).column(field);
                for (Function function : orderBy.functions()) {
                    Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
                    if (functionTuple == null) continue;
                    String expr = functionTuple.getFirst();
                    TableField[] tableFields = functionTuple.getSecond();
                    Object[] args = functionTuple.getThird();
                    seg = args != null ? ((OrderBySegment)seg).apply(expr, tableFields, args) : ((OrderBySegment)seg).apply(expr, tableFields, bindings);
                }
                switch (orderBy.direction()) {
                    case ASC: {
                        ((OrderBySegment)seg).asc();
                        break;
                    }
                    case DESC: {
                        ((OrderBySegment)seg).desc();
                    }
                }
            }
        }
    }

    private static void addWhereClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, Where where, io.polaris.core.jdbc.annotation.segment.ColumnPredicate columnedPredicate) {
        Object entity;
        String entityIdKey = where.byEntityIdKey();
        String entityKey = where.byEntityKey();
        if (Strings.isNotBlank(entityIdKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityIdKey, Collections.emptyMap());
            ws.byEntityId(entity);
        } else if (Strings.isNotBlank(entityKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityKey, Collections.emptyMap());
            ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, columnedPredicate);
            ws.byEntity(entity, columnPredicate);
        }
        if (where.relation() == Relation.OR) {
            ws = ws.or();
        }
        for (io.polaris.core.jdbc.annotation.segment.Criteria criteria : where.criteria()) {
            EntityStatements.addWhereByCriteria(cache, bindings, criteria, ws);
        }
    }

    private static void addGroupByClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, GroupBy[] groupBys) {
        if (groupBys != null && groupBys.length > 0) {
            ArrayList<GroupBy> activeGroupBys = new ArrayList<GroupBy>(groupBys.length);
            GroupBy defaultGroupBy = null;
            for (GroupBy groupBy : groupBys) {
                if (EntityStatements.isDefaultCondition(groupBy.condition())) {
                    defaultGroupBy = groupBy;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, groupBy.condition())) continue;
                activeGroupBys.add(groupBy);
            }
            if (activeGroupBys.isEmpty() && defaultGroupBy != null) {
                activeGroupBys.add(defaultGroupBy);
            }
            for (GroupBy groupBy : activeGroupBys) {
                String raw = groupBy.raw();
                String field = groupBy.field();
                if (Strings.isNotBlank(raw)) {
                    ((GroupBySegment)st.groupBy()).rawColumn(raw);
                    continue;
                }
                if (!Strings.isNotBlank(field)) continue;
                ((GroupBySegment)st.groupBy()).column(field);
            }
        }
    }

    private static void addHavingClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, Having having) {
        io.polaris.core.jdbc.annotation.segment.Criteria[] havingCriteria = having.criteria();
        Relation havingRelation = having.relation();
        if (havingCriteria != null && havingCriteria.length > 0) {
            Object ws = st.having();
            if (havingRelation == Relation.OR) {
                ws = ((WhereSegment)ws).or();
            }
            for (io.polaris.core.jdbc.annotation.segment.Criteria criteria : havingCriteria) {
                EntityStatements.addWhereByCriteria(cache, bindings, criteria, ws);
            }
        }
    }

    private static void addOrderByClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, SqlSelect sqlSelect) {
        io.polaris.core.jdbc.annotation.segment.OrderBy[] orderBys;
        boolean hasOrderByKey = false;
        String orderByKey = sqlSelect.orderByKey();
        if (Strings.isNotBlank(orderByKey)) {
            Object orderByObj = BindingValues.getBindingValueOrDefault(cache, bindings, orderByKey, null);
            OrderBy orderBy = null;
            if (orderByObj instanceof String) {
                orderBy = Queries.newOrderBy((String)orderByObj);
            } else if (orderByObj instanceof OrderBy) {
                orderBy = (OrderBy)orderByObj;
            }
            if (orderBy != null) {
                st.orderBy(orderBy);
                hasOrderByKey = true;
            }
        }
        if (!hasOrderByKey && (orderBys = sqlSelect.orderBy()).length > 0) {
            ArrayList<io.polaris.core.jdbc.annotation.segment.OrderBy> activeOrderBys = new ArrayList<io.polaris.core.jdbc.annotation.segment.OrderBy>(orderBys.length);
            io.polaris.core.jdbc.annotation.segment.OrderBy defaultOrderBy = null;
            for (io.polaris.core.jdbc.annotation.segment.OrderBy orderBy : orderBys) {
                if (EntityStatements.isDefaultCondition(orderBy.condition())) {
                    defaultOrderBy = orderBy;
                }
                if (!EntityStatements.evalConditionPredicate(cache, bindings, null, orderBy.condition())) continue;
                activeOrderBys.add(orderBy);
            }
            if (activeOrderBys.isEmpty() && defaultOrderBy != null) {
                activeOrderBys.add(defaultOrderBy);
            }
            for (io.polaris.core.jdbc.annotation.segment.OrderBy orderBy : activeOrderBys) {
                String raw = orderBy.raw();
                if (Strings.isNotBlank(raw)) {
                    st.orderByRaw(raw);
                    continue;
                }
                String field = orderBy.field();
                if (Strings.isBlank(field)) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u6392\u5e8f\u5b57\u6bb5\u540d");
                }
                Object seg = st.orderBy();
                ((OrderBySegment)seg).column(field);
                for (Function function : orderBy.functions()) {
                    Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
                    if (functionTuple == null) continue;
                    String expr = functionTuple.getFirst();
                    TableField[] tableFields = functionTuple.getSecond();
                    Object[] args = functionTuple.getThird();
                    seg = args != null ? ((OrderBySegment)seg).apply(expr, tableFields, args) : ((OrderBySegment)seg).apply(expr, tableFields, bindings);
                }
                switch (orderBy.direction()) {
                    case ASC: {
                        ((OrderBySegment)seg).asc();
                        break;
                    }
                    case DESC: {
                        ((OrderBySegment)seg).desc();
                    }
                }
            }
        }
    }

    private static Tuple3<String, TableField[], Object[]> parseFunction(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Function function) {
        String expr = function.value();
        if (Strings.isBlank(expr)) {
            return null;
        }
        JoinColumn[] joinColumns = function.joinColumns();
        TableField[] tableFields = new TableField[joinColumns.length];
        for (int i = 0; i < tableFields.length; ++i) {
            TableField v = EntityStatements.getJoinTableField(cache, bindings, joinColumns[i]);
            if (v == null) {
                return null;
            }
            tableFields[i] = v;
        }
        BindingKey[] bindingKeys = function.bindingKeys();
        if (bindingKeys.length > 0) {
            Object[] args = new Object[bindingKeys.length];
            for (int i = 0; i < bindingKeys.length; ++i) {
                Tuple1<?> val = EntityStatements.getValForBindingKey(cache, bindings, bindingKeys[i]);
                if (val == null) {
                    return null;
                }
                args[i] = val.getFirst();
            }
            return Tuple3.of(expr, tableFields, args);
        }
        return Tuple3.of(expr, tableFields, null);
    }

    private static CriterionSegment<?, ?> newCriterionSegmentWithFunction(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, Criterion criterion) {
        Object seg = ws.column(criterion.field());
        if (criterion.count()) {
            seg = ((CriterionSegment)seg).count();
        }
        if (criterion.sum()) {
            seg = ((CriterionSegment)seg).sum();
        }
        if (criterion.max()) {
            seg = ((CriterionSegment)seg).max();
        }
        if (criterion.min()) {
            seg = ((CriterionSegment)seg).min();
        }
        if (criterion.avg()) {
            seg = ((CriterionSegment)seg).avg();
        }
        for (Function function : criterion.functions()) {
            Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
            if (functionTuple == null) continue;
            String expr = functionTuple.getFirst();
            TableField[] tableFields = functionTuple.getSecond();
            Object[] args = functionTuple.getThird();
            seg = args != null ? ((CriterionSegment)seg).apply(expr, tableFields, args) : ((CriterionSegment)seg).apply(expr, tableFields, bindings);
        }
        return seg;
    }

    private static CriterionSegment<?, ?> newSubCriterionSegmentWithFunction(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, SubCriterion criterion) {
        Object seg = ws.column(criterion.field());
        if (criterion.count()) {
            seg = ((CriterionSegment)seg).count();
        }
        if (criterion.sum()) {
            seg = ((CriterionSegment)seg).sum();
        }
        if (criterion.max()) {
            seg = ((CriterionSegment)seg).max();
        }
        if (criterion.min()) {
            seg = ((CriterionSegment)seg).min();
        }
        if (criterion.avg()) {
            seg = ((CriterionSegment)seg).avg();
        }
        for (Function function : criterion.functions()) {
            Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
            if (functionTuple == null) continue;
            String expr = functionTuple.getFirst();
            TableField[] tableFields = functionTuple.getSecond();
            Object[] args = functionTuple.getThird();
            seg = args != null ? ((CriterionSegment)seg).apply(expr, tableFields, args) : ((CriterionSegment)seg).apply(expr, tableFields, bindings);
        }
        return seg;
    }

    private static CriterionSegment<?, ?> newJoinCriterionSegmentWithFunction(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, JoinCriterion criterion) {
        Object seg = ws.column(criterion.field());
        if (criterion.count()) {
            seg = ((CriterionSegment)seg).count();
        }
        if (criterion.sum()) {
            seg = ((CriterionSegment)seg).sum();
        }
        if (criterion.max()) {
            seg = ((CriterionSegment)seg).max();
        }
        if (criterion.min()) {
            seg = ((CriterionSegment)seg).min();
        }
        if (criterion.avg()) {
            seg = ((CriterionSegment)seg).avg();
        }
        for (Function function : criterion.functions()) {
            Tuple3<String, TableField[], Object[]> functionTuple = EntityStatements.parseFunction(cache, bindings, function);
            if (functionTuple == null) continue;
            String expr = functionTuple.getFirst();
            TableField[] tableFields = functionTuple.getSecond();
            Object[] args = functionTuple.getThird();
            seg = args != null ? ((CriterionSegment)seg).apply(expr, tableFields, args) : ((CriterionSegment)seg).apply(expr, tableFields, bindings);
        }
        return seg;
    }

    private static void addWhereByCriteria(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, io.polaris.core.jdbc.annotation.segment.Criteria criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addWhereByCriteria1(cache, bindings, (Criteria1)annotation, ws);
        }
    }

    private static void addWhereByCriteria1(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Criteria1 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addWhereByCriteria2(cache, bindings, (Criteria2)annotation, ws);
        }
    }

    private static void addWhereByCriteria2(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Criteria2 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addWhereByCriteria3(cache, bindings, (Criteria3)annotation, ws);
        }
    }

    private static void addWhereByCriteria3(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Criteria3 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addWhereByCriteria4(cache, bindings, (Criteria4)annotation, ws);
        }
    }

    private static void addWhereByCriteria4(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Criteria4 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addWhereByCriteria5(cache, bindings, (Criteria5)annotation, ws);
        }
    }

    private static void addWhereByCriteria5(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, Criteria5 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (Criterion criterion : criteria.value()) {
            EntityStatements.addWhereByCriterion(cache, bindings, ws, criterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
    }

    private static void addWhereByCriterion(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, Criterion criterion) {
        SelectStatement st;
        BindingKey[] notBetween;
        Tuple1<?> val1;
        Tuple1<?> val0;
        BindingKey[] between;
        String raw = criterion.raw();
        if (Strings.isNotBlank(raw)) {
            ws.raw(raw);
            return;
        }
        String field = criterion.field();
        if (Strings.isBlank(field)) {
            return;
        }
        Tuple1<?> val = EntityStatements.getValForBindingKey(cache, bindings, criterion.eq());
        if (val != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).eq(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.ne())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).ne(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.gt())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).gt(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.ge())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).ge(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.lt())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).lt(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.le())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).le(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.isNull())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).isNull();
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notNull())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notNull();
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.contains())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).contains((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notContains())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notContains((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.startsWith())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).startsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notStartsWith())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notStartsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.endsWith())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).endsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notEndsWith())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notEndsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.like())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).like((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notLike())) != null) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notLike((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((between = criterion.between()).length >= 2) {
            val0 = EntityStatements.getValForBindingKey(cache, bindings, between[0]);
            val1 = EntityStatements.getValForBindingKey(cache, bindings, between[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).between(val0, val1);
            }
        }
        if ((notBetween = criterion.notBetween()).length >= 2) {
            val0 = EntityStatements.getValForBindingKey(cache, bindings, notBetween[0]);
            val1 = EntityStatements.getValForBindingKey(cache, bindings, notBetween[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notBetween(val0, val1);
            }
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.in())) != null && val.getFirst() instanceof Collection) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).in((Collection)val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notIn())) != null && val.getFirst() instanceof Collection) {
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notIn((Collection)val.getFirst());
        }
        SubSelect subSelect = criterion.exists();
        String tableAlias = subSelect.alias();
        Class<?> entityClass = subSelect.table();
        if (entityClass != Void.TYPE && Strings.isNotBlank(tableAlias)) {
            st = new SelectStatement(entityClass, tableAlias);
            EntityStatements.addSelectColumns(cache, bindings, st, subSelect.columns(), subSelect.quotaSelectAlias());
            ws.exists(st);
            EntityStatements.addSubWhereClause(cache, bindings, st, subSelect);
            EntityStatements.addGroupByClause(cache, bindings, st, subSelect.groupBy());
            EntityStatements.addSubHavingClause(cache, bindings, st, subSelect.having());
        }
        subSelect = criterion.notExists();
        tableAlias = subSelect.alias();
        entityClass = subSelect.table();
        if (entityClass != Void.TYPE && Strings.isNotBlank(tableAlias)) {
            st = new SelectStatement(entityClass, tableAlias);
            EntityStatements.addSelectColumns(cache, bindings, st, subSelect.columns(), subSelect.quotaSelectAlias());
            ws.notExists(st);
            EntityStatements.addSubWhereClause(cache, bindings, st, subSelect);
            EntityStatements.addGroupByClause(cache, bindings, st, subSelect.groupBy());
            EntityStatements.addSubHavingClause(cache, bindings, st, subSelect.having());
        }
        subSelect = criterion.inSubSelect();
        tableAlias = subSelect.alias();
        entityClass = subSelect.table();
        if (entityClass != Void.TYPE && Strings.isNotBlank(tableAlias)) {
            st = new SelectStatement(entityClass, tableAlias);
            EntityStatements.addSelectColumns(cache, bindings, st, subSelect.columns(), subSelect.quotaSelectAlias());
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).in(st);
            EntityStatements.addSubWhereClause(cache, bindings, st, subSelect);
            EntityStatements.addGroupByClause(cache, bindings, st, subSelect.groupBy());
            EntityStatements.addSubHavingClause(cache, bindings, st, subSelect.having());
        }
        subSelect = criterion.notInSubSelect();
        tableAlias = subSelect.alias();
        entityClass = subSelect.table();
        if (entityClass != Void.TYPE && Strings.isNotBlank(tableAlias)) {
            st = new SelectStatement(entityClass, tableAlias);
            EntityStatements.addSelectColumns(cache, bindings, st, subSelect.columns(), subSelect.quotaSelectAlias());
            EntityStatements.newCriterionSegmentWithFunction(cache, bindings, ws, criterion).notIn(st);
            EntityStatements.addSubWhereClause(cache, bindings, st, subSelect);
            EntityStatements.addGroupByClause(cache, bindings, st, subSelect.groupBy());
            EntityStatements.addSubHavingClause(cache, bindings, st, subSelect.having());
        }
    }

    private static void addSubHavingClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, SubHaving having) {
        SubCriteria[] havingCriteria = having.criteria();
        Relation havingRelation = having.relation();
        if (havingCriteria != null && havingCriteria.length > 0) {
            Object ws = st.having();
            if (havingRelation == Relation.OR) {
                ws = ((WhereSegment)ws).or();
            }
            for (SubCriteria criteria : havingCriteria) {
                EntityStatements.addSubWhereByCriteria(cache, bindings, criteria, ws);
            }
        }
    }

    private static void addWhereByJoinCriterion(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, JoinCriterion criterion) {
        JoinColumn[] notBetween;
        TableField val1;
        TableField val0;
        JoinColumn[] between;
        String raw = criterion.raw();
        if (Strings.isNotBlank(raw)) {
            ws.raw(raw);
            return;
        }
        String field = criterion.field();
        if (Strings.isBlank(field)) {
            return;
        }
        TableField v = EntityStatements.getJoinTableField(cache, bindings, criterion.eq());
        if (v != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).eq(v);
        }
        if ((v = EntityStatements.getJoinTableField(cache, bindings, criterion.ne())) != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).ne(v);
        }
        if ((v = EntityStatements.getJoinTableField(cache, bindings, criterion.gt())) != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).gt(v);
        }
        if ((v = EntityStatements.getJoinTableField(cache, bindings, criterion.ge())) != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).ge(v);
        }
        if ((v = EntityStatements.getJoinTableField(cache, bindings, criterion.lt())) != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).lt(v);
        }
        if ((v = EntityStatements.getJoinTableField(cache, bindings, criterion.le())) != null) {
            EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).le(v);
        }
        if ((between = criterion.between()).length >= 2) {
            val0 = EntityStatements.getJoinTableField(cache, bindings, between[0]);
            val1 = EntityStatements.getJoinTableField(cache, bindings, between[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).between(val0, val1);
            }
        }
        if ((notBetween = criterion.notBetween()).length >= 2) {
            val0 = EntityStatements.getJoinTableField(cache, bindings, notBetween[0]);
            val1 = EntityStatements.getJoinTableField(cache, bindings, notBetween[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newJoinCriterionSegmentWithFunction(cache, bindings, ws, criterion).notBetween(val0, val1);
            }
        }
    }

    private static void addSubWhereClause(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SelectStatement<?> st, SubSelect subSelect) {
        Object entity;
        SubWhere where = subSelect.where();
        String entityIdKey = where.byEntityIdKey();
        String entityKey = where.byEntityKey();
        if (Strings.isNotBlank(entityIdKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityIdKey, Collections.emptyMap());
            ((WhereSegment)st.where()).byEntityId(entity);
        }
        if (Strings.isNotBlank(entityKey)) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityKey, Collections.emptyMap());
            ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, subSelect.columnPredicate());
            ((WhereSegment)st.where()).byEntity(entity, columnPredicate);
        }
        Object stWhere = st.where();
        if (where.relation() == Relation.OR) {
            stWhere = ((WhereSegment)st.where()).or();
        }
        for (SubCriteria criteria : where.criteria()) {
            EntityStatements.addSubWhereByCriteria(cache, bindings, criteria, stWhere);
        }
    }

    private static void addSubWhereByCriteria(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addSubWhereByCriteria1(cache, bindings, (SubCriteria1)annotation, ws);
        }
    }

    private static void addSubWhereByCriteria1(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria1 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addSubWhereByCriteria2(cache, bindings, (SubCriteria2)annotation, ws);
        }
    }

    private static void addSubWhereByCriteria2(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria2 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addSubWhereByCriteria3(cache, bindings, (SubCriteria3)annotation, ws);
        }
    }

    private static void addSubWhereByCriteria3(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria3 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addSubWhereByCriteria4(cache, bindings, (SubCriteria4)annotation, ws);
        }
    }

    private static void addSubWhereByCriteria4(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria4 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
        for (Annotation annotation : criteria.subset()) {
            EntityStatements.addSubWhereByCriteria5(cache, bindings, (SubCriteria5)annotation, ws);
        }
    }

    private static void addSubWhereByCriteria5(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, SubCriteria5 criteria, WhereSegment<?, ?> ws) {
        ws = criteria.relation() == Relation.OR ? ws.or() : ws.and();
        for (SubCriterion subCriterion : criteria.value()) {
            EntityStatements.addWhereBySubCriterion(cache, bindings, ws, subCriterion);
        }
        for (Annotation annotation : criteria.join()) {
            EntityStatements.addWhereByJoinCriterion(cache, bindings, ws, (JoinCriterion)annotation);
        }
    }

    private static void addWhereBySubCriterion(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, WhereSegment<?, ?> ws, SubCriterion criterion) {
        BindingKey[] notBetween;
        Tuple1<?> val1;
        Tuple1<?> val0;
        BindingKey[] between;
        String raw = criterion.raw();
        if (Strings.isNotBlank(raw)) {
            ws.raw(raw);
            return;
        }
        String field = criterion.field();
        if (Strings.isBlank(field)) {
            return;
        }
        Tuple1<?> val = EntityStatements.getValForBindingKey(cache, bindings, criterion.eq());
        if (val != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).eq(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.ne())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).ne(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.gt())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).gt(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.ge())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).ge(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.lt())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).lt(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.le())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).le(val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.isNull())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).isNull();
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notNull())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notNull();
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.contains())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).contains((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notContains())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notContains((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.startsWith())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).startsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notStartsWith())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notStartsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.endsWith())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).endsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notEndsWith())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notEndsWith((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.like())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).like((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notLike())) != null) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notLike((String)Converters.convertQuietly(String.class, val.getFirst()));
        }
        if ((between = criterion.between()).length >= 2) {
            val0 = EntityStatements.getValForBindingKey(cache, bindings, between[0]);
            val1 = EntityStatements.getValForBindingKey(cache, bindings, between[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).between(val0, val1);
            }
        }
        if ((notBetween = criterion.notBetween()).length >= 2) {
            val0 = EntityStatements.getValForBindingKey(cache, bindings, notBetween[0]);
            val1 = EntityStatements.getValForBindingKey(cache, bindings, notBetween[1]);
            if (val1 != null && val1 != null) {
                EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notBetween(val0, val1);
            }
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.in())) != null && val.getFirst() instanceof Collection) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).in((Collection)val.getFirst());
        }
        if ((val = EntityStatements.getValForBindingKey(cache, bindings, criterion.notIn())) != null && val.getFirst() instanceof Collection) {
            EntityStatements.newSubCriterionSegmentWithFunction(cache, bindings, ws, criterion).notIn((Collection)val.getFirst());
        }
    }

    private static TableField getJoinTableField(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, JoinColumn joinColumn) {
        String field = joinColumn.tableField();
        String tableAlias = joinColumn.tableAlias();
        if (Strings.isBlank(field) || Strings.isBlank(tableAlias)) {
            return null;
        }
        if (!EntityStatements.evalConditionPredicate(cache, bindings, null, joinColumn.condition())) {
            return null;
        }
        return TableField.of(tableAlias, field);
    }

    private static Tuple1<?> getValForBindingKey(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, BindingKey bindingKey) {
        String key = bindingKey.value();
        if (Strings.isBlank(key)) {
            return null;
        }
        if (!EntityStatements.evalConditionPredicate(cache, bindings, key, bindingKey.condition())) {
            return null;
        }
        return Tuple1.of(BindingValues.getBindingValueOrDefault(cache, bindings, key, null));
    }

    private static boolean isDefaultCondition(Condition[] conditions) {
        return conditions.length == 1 && conditions[0].predicateType() == Condition.PredicateType.DEFAULT;
    }

    private static boolean evalConditionPredicate(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, String defaultBindingKey, Condition[] conditions) {
        block12: for (Condition condition : conditions) {
            String key = Strings.coalesce(condition.bindingKey(), defaultBindingKey);
            Object condVal = Strings.isBlank(key) ? null : BindingValues.getBindingValueOrDefault(cache, bindings, key, null);
            Condition.PredicateType predicateType = condition.predicateType();
            switch (predicateType) {
                case NOT_NULL: {
                    if (condVal != null) continue block12;
                    return false;
                }
                case NOT_EMPTY: {
                    if (!Objs.isEmpty(condVal)) continue block12;
                    return false;
                }
                case IS_NULL: {
                    if (condVal == null) continue block12;
                    return false;
                }
                case IS_EMPTY: {
                    if (!Objs.isNotEmpty(condVal)) continue block12;
                    return false;
                }
                case REGEX: {
                    if (!(condVal instanceof String)) {
                        return false;
                    }
                    String expression = condition.predicateExpression();
                    if (Strings.isBlank(expression)) {
                        return false;
                    }
                    if (Patterns.matches(expression, (CharSequence)((String)condVal))) continue block12;
                    return false;
                }
                case SCRIPT: {
                    String expression = condition.predicateExpression();
                    String engineName = condition.predicateScriptEngine();
                    if (Strings.isBlank(expression) || Strings.isBlank(engineName)) {
                        return false;
                    }
                    Evaluator evaluator = ScriptEvaluators.getEvaluator(engineName);
                    if (evaluator == null) {
                        return false;
                    }
                    HashMap output = new HashMap();
                    Object o = evaluator.eval(expression, condVal, output, bindings);
                    boolean rs = Converters.convertQuietly(Boolean.TYPE, o, false);
                    if (rs) continue block12;
                    return false;
                }
                case CUSTOM: {
                    String customKey = condition.predicateCustomKey();
                    if (Strings.isNotBlank(customKey)) {
                        BiPredicate predicate = (BiPredicate)BindingValues.getBindingValueOrDefault(cache, bindings, customKey, null);
                        if (predicate != null && predicate.test(bindings, condVal)) continue block12;
                        return false;
                    }
                    for (Class<? extends BiPredicate<Map<String, Object>, Object>> c : condition.predicateCustomClass()) {
                        try {
                            BiPredicate<Map<String, Object>, Object> biPredicate = c.newInstance();
                            if (biPredicate.test(bindings, condVal)) continue;
                            return false;
                        }
                        catch (ReflectiveOperationException e) {
                            return false;
                        }
                    }
                    continue block12;
                }
                case DEFAULT: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static InsertStatement<?> buildInsert(Map<String, Object> bindings, EntityInsert entityInsert) {
        return EntityStatements.buildInsert(bindings, entityInsert.table(), entityInsert.entityKey(), entityInsert.enableReplace(), entityInsert.enableUpdateByDuplicateKey(), entityInsert.columnPredicate());
    }

    public static InsertStatement<?> buildInsert(Map<String, Object> bindings, Class<?> entityClass, String entityKey, boolean enableReplace, boolean enableUpdateByDuplicateKey, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate) {
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, predicate);
        return EntityStatements.buildInsert(bindings, entityClass, entityKey, enableReplace, enableUpdateByDuplicateKey, columnPredicate);
    }

    public static InsertStatement<?> buildInsert(Map<String, Object> bindings, Class<?> entityClass, String entityKey, boolean enableReplace, boolean enableUpdateByDuplicateKey, ColumnPredicate columnPredicate) {
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        InsertStatement st = new InsertStatement(entityClass);
        st.withEntity(entity, columnPredicate);
        if (enableReplace) {
            st.enableReplace(true);
        }
        if (enableUpdateByDuplicateKey) {
            st.enableUpdateByDuplicateKey(true);
        }
        return st;
    }

    public static DeleteStatement<?> buildDelete(Map<String, Object> bindings, EntityDelete entityDelete) {
        return EntityStatements.buildDelete(bindings, entityDelete.table(), Strings.trimToNull(entityDelete.alias()), entityDelete.byId(), entityDelete.entityKey(), entityDelete.whereKey(), entityDelete.columnPredicate());
    }

    public static DeleteStatement<?> buildDelete(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate) {
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, predicate);
        return EntityStatements.buildDelete(bindings, entityClass, tableAlias, byId, entityKey, whereKey, columnPredicate);
    }

    public static DeleteStatement<?> buildDelete(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, ColumnPredicate columnPredicate) {
        DeleteStatement st = new DeleteStatement(entityClass, Strings.coalesce(tableAlias, DEFAULT_TABLE_ALIAS));
        if (byId) {
            Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
            if (entity == null) {
                entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
            }
            ((WhereSegment)st.where()).byEntityIdAndVersion(entity);
        } else {
            Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
            if (entity != null) {
                if (entity instanceof Criteria) {
                    st.where((Criteria)entity);
                } else {
                    ((WhereSegment)st.where()).byEntity(entity, columnPredicate);
                }
            }
            if ((entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, null)) != null) {
                if (entity instanceof Criteria) {
                    st.where((Criteria)entity);
                } else {
                    ((WhereSegment)st.where()).byEntity(entity, columnPredicate);
                }
            }
        }
        return st;
    }

    public static UpdateStatement<?> buildUpdate(Map<String, Object> bindings, EntityUpdate entityUpdate) {
        return EntityStatements.buildUpdate(bindings, entityUpdate.table(), Strings.trimToNull(entityUpdate.alias()), entityUpdate.byId(), entityUpdate.entityKey(), entityUpdate.whereKey(), entityUpdate.columnPredicate(), entityUpdate.whereColumnPredicate());
    }

    public static UpdateStatement<?> buildUpdate(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate, io.polaris.core.jdbc.annotation.segment.ColumnPredicate wherePredicate) {
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, predicate);
        ColumnPredicate whereColumnPredicate = ConfigurableColumnPredicate.of(bindings, wherePredicate);
        return EntityStatements.buildUpdate(bindings, entityClass, tableAlias, byId, entityKey, whereKey, columnPredicate, whereColumnPredicate);
    }

    public static UpdateStatement<?> buildUpdate(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, ColumnPredicate columnPredicate, ColumnPredicate whereColumnPredicate) {
        UpdateStatement st = new UpdateStatement(entityClass, Strings.coalesce(tableAlias, DEFAULT_TABLE_ALIAS));
        if (byId) {
            Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
            if (entity == null) {
                entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
            }
            st.withEntity(entity, columnPredicate);
            ((WhereSegment)st.where()).byEntityIdAndVersion(entity);
            return st;
        }
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        Object where = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        st.withEntity(entity, columnPredicate);
        if (where instanceof Criteria) {
            st.where((Criteria)where);
        } else {
            ((WhereSegment)st.where()).byEntity(where, whereColumnPredicate);
        }
        return st;
    }

    public static SelectStatement<?> buildSelect(Map<String, Object> bindings, EntitySelect entitySelect) {
        return EntityStatements.buildSelect(bindings, entitySelect.table(), Strings.trimToNull(entitySelect.alias()), entitySelect.byId(), entitySelect.entityKey(), entitySelect.whereKey(), entitySelect.orderByKey(), entitySelect.columnPredicate());
    }

    public static SelectStatement<?> buildSelect(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, String orderByKey, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate) {
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, predicate);
        return EntityStatements.buildSelect(bindings, entityClass, tableAlias, byId, entityKey, whereKey, orderByKey, columnPredicate);
    }

    public static SelectStatement<?> buildSelect(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, boolean byId, String entityKey, String whereKey, String orderByKey, ColumnPredicate columnPredicate) {
        Object entity;
        SelectStatement st = new SelectStatement(entityClass, Strings.coalesce(tableAlias, DEFAULT_TABLE_ALIAS));
        st.selectAll();
        HashMap<String, ValueRef<Object>> cache = new HashMap<String, ValueRef<Object>>();
        if (byId) {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityKey, null);
            if (entity == null) {
                entity = BindingValues.getBindingValueOrDefault(cache, bindings, whereKey, Collections.emptyMap());
            }
            ((WhereSegment)st.where()).byEntityId(entity);
        } else {
            entity = BindingValues.getBindingValueOrDefault(cache, bindings, entityKey, null);
            if (entity != null) {
                if (entity instanceof Criteria) {
                    st.where((Criteria)entity);
                } else {
                    ((WhereSegment)st.where()).byEntity(entity, columnPredicate);
                }
            }
            if ((entity = BindingValues.getBindingValueOrDefault(cache, bindings, whereKey, null)) != null) {
                if (entity instanceof Criteria) {
                    st.where((Criteria)entity);
                } else {
                    ((WhereSegment)st.where()).byEntity(entity, columnPredicate);
                }
            }
        }
        Object orderByObj = BindingValues.getBindingValueOrDefault(cache, bindings, orderByKey, null);
        OrderBy orderBy = null;
        if (orderByObj instanceof String) {
            orderBy = Queries.newOrderBy((String)orderByObj);
        } else if (orderByObj instanceof OrderBy) {
            orderBy = (OrderBy)orderByObj;
        }
        if (orderBy != null) {
            st.orderBy(orderBy);
        }
        return st;
    }

    public static MergeStatement<?> buildMerge(Map<String, Object> bindings, EntityMerge entityMerge) {
        return EntityStatements.buildMerge(bindings, entityMerge.table(), Strings.trimToNull(entityMerge.alias()), entityMerge.entityKey(), entityMerge.updateWhenMatched(), entityMerge.insertWhenNotMatched(), entityMerge.columnPredicate());
    }

    public static MergeStatement<?> buildMerge(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, String entityKey, boolean updateWhenMatched, boolean insertWhenNotMatched, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate) {
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, predicate);
        return EntityStatements.buildMerge(bindings, entityClass, tableAlias, entityKey, updateWhenMatched, insertWhenNotMatched, columnPredicate);
    }

    public static MergeStatement<?> buildMerge(Map<String, Object> bindings, Class<?> entityClass, String tableAlias, String entityKey, boolean updateWhenMatched, boolean insertWhenNotMatched, ColumnPredicate columnPredicate) {
        MergeStatement st = new MergeStatement(entityClass, Strings.coalesce(tableAlias, DEFAULT_TABLE_ALIAS));
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        st.withEntity(entity, updateWhenMatched, insertWhenNotMatched, columnPredicate);
        return st;
    }

    public static String asSqlWithBindings(Map<String, Object> map, SqlNodeBuilder sqlNodeBuilder) {
        SqlNode sqlNode = sqlNodeBuilder.toSqlNode();
        return EntityStatements.asSqlWithBindings(map, sqlNode);
    }

    public static String asSqlWithBindings(Map<String, Object> map, SqlNode sqlNode) {
        BoundSql boundSql = sqlNode.asBoundSql();
        Map<String, Object> bindings = boundSql.getBindings();
        if (bindings != null && !bindings.isEmpty()) {
            map.putAll(bindings);
        }
        return boundSql.getText();
    }

    private static /* synthetic */ SqlNode lambda$buildSqlRawFunction$16(SqlRawSimple sqlRaw, Map bindings) {
        String sqlText = Strings.join((CharSequence)" ", sqlRaw.value());
        ContainerNode sql = SqlTextParsers.parse(sqlText);
        return EntityStatements.buildSqlRaw(sql, varName -> BindingValues.getBindingValueOrDefault(bindings, varName, null));
    }

    private static /* synthetic */ SqlNode lambda$buildSqlRawFunction$14(SqlRawSimple sqlRaw, TableAccessible finalTableAccessible, Map bindings) {
        String sqlText = SqlTextParsers.resolveTableRef(Strings.join((CharSequence)" ", sqlRaw.value()), finalTableAccessible);
        ContainerNode sql = SqlTextParsers.parse(sqlText);
        return EntityStatements.buildSqlRaw(sql, varName -> BindingValues.getBindingValueOrDefault(bindings, varName, null));
    }

    private static /* synthetic */ SqlNode lambda$buildSqlSelectFunction$12(SqlSelectSet sqlSelect, Map bindings) {
        return EntityStatements.buildSelectSet(bindings, sqlSelect).toSqlNode();
    }

    private static /* synthetic */ SqlNode lambda$buildSqlSelectFunction$11(SqlSelectSet sqlSelect, Map bindings) {
        return EntityStatements.buildSelectSet(bindings, sqlSelect).toCountSqlNode();
    }

    private static /* synthetic */ SqlNode lambda$buildSqlSelectFunction$10(SqlSelect sqlSelect, Map bindings) {
        return EntityStatements.buildSelect((Map<String, Object>)bindings, sqlSelect).toSqlNode();
    }

    private static /* synthetic */ SqlNode lambda$buildSqlSelectFunction$9(SqlSelect sqlSelect, Map bindings) {
        return EntityStatements.buildSelect((Map<String, Object>)bindings, sqlSelect).toCountSqlNode();
    }

    private static class SqlRawItemModel {
        private static final String CONDITION = Reflects.getPropertyName(SqlRawItem::condition);
        private static final String VALUE = Reflects.getPropertyName(SqlRawItem::value);
        private static final String SUBSET = Reflects.getPropertyName(SqlRawItem::subset);
        private static final String FOR_EACH_KEY = Reflects.getPropertyName(SqlRawItem::forEachKey);
        private static final String ITEM_KEY = Reflects.getPropertyName(SqlRawItem::itemKey);
        private static final String INDEX_KEY = Reflects.getPropertyName(SqlRawItem::indexKey);
        private static final String OPEN = Reflects.getPropertyName(SqlRawItem::open);
        private static final String CLOSE = Reflects.getPropertyName(SqlRawItem::close);
        private static final String SEPARATOR = Reflects.getPropertyName(SqlRawItem::separator);
        private String sqlText;
        private List<SqlRawItemModel> subset;
        private Condition[] condition;
        private String forEachKey;
        private String itemKey;
        private String indexKey;
        private String open;
        private String close;
        private String separator;

        private SqlRawItemModel() {
        }

        public static SqlRawItemModel[] of(SqlRaw sqlRaw) {
            SqlRawItem[] items = sqlRaw.value();
            SqlRawItemModel[] models = new SqlRawItemModel[items.length];
            for (int i = 0; i < items.length; ++i) {
                SqlRawItem item = items[i];
                models[i] = SqlRawItemModel.of(item);
            }
            return models;
        }

        public static SqlRawItemModel of(SqlRawItem sqlRawItem) {
            AnnotationAttributes attributes = AnnotationAttributes.of(sqlRawItem);
            return SqlRawItemModel.of(attributes);
        }

        private static SqlRawItemModel of(AnnotationAttributes attributes) {
            int subsetLength;
            SqlRawItemModel model = new SqlRawItemModel();
            Object subset = attributes.get(SUBSET);
            int n = subsetLength = subset == null ? 0 : Array.getLength(subset);
            if (subsetLength > 0) {
                model.subset = new ArrayList<SqlRawItemModel>();
                for (int i = 0; i < subsetLength; ++i) {
                    Annotation o = (Annotation)Array.get(subset, i);
                    model.subset.add(SqlRawItemModel.of(AnnotationAttributes.of(o)));
                }
            } else {
                model.sqlText = Strings.join((CharSequence)" ", attributes.getStringArray(VALUE));
            }
            model.condition = (Condition[])attributes.getAnnotationArray(CONDITION, Condition.class);
            model.forEachKey = attributes.getString(FOR_EACH_KEY);
            model.itemKey = attributes.getString(ITEM_KEY);
            model.indexKey = attributes.getString(INDEX_KEY);
            model.open = Strings.join((CharSequence)" ", attributes.getStringArray(OPEN));
            model.close = Strings.join((CharSequence)" ", attributes.getStringArray(CLOSE));
            model.separator = Strings.join((CharSequence)" ", attributes.getStringArray(SEPARATOR));
            return model;
        }
    }
}

