/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql;

import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.DynamicNode;
import io.polaris.core.jdbc.sql.node.MixedNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.string.Strings;

public class SqlTextParsers {
    public static ContainerNode parse(String sql) {
        return SqlTextParsers.parse(sql, '$', '#', '{', '}');
    }

    public static ContainerNode parse(String sql, char directSymbol, char preparedSymbol, char openSymbol, char closeSymbol) {
        ContainerNode root = new ContainerNode();
        char[] src = sql.toCharArray();
        int len = sql.length();
        StringBuilder text = new StringBuilder(len);
        boolean inQuotes = false;
        for (int i = 0; i < len; ++i) {
            int idx;
            char c = src[i];
            if (c == '\'') {
                if (inQuotes) {
                    text.append(c);
                    if (i + 1 < len && src[i + 1] == '\'') {
                        text.append('\'');
                        ++i;
                        continue;
                    }
                    inQuotes = false;
                    continue;
                }
                inQuotes = true;
                text.append(c);
                continue;
            }
            if (c == directSymbol) {
                if (i + 1 < len && src[i + 1] == openSymbol) {
                    idx = sql.indexOf(closeSymbol, i + 2);
                    if (idx == -1) {
                        text.append(c);
                        continue;
                    }
                    if (text.length() > 0) {
                        root.addNode(new TextNode(text.toString()));
                        text.setLength(0);
                    }
                    text.append(src, i, idx - i + 1);
                    root.addNode(new MixedNode(text.substring(2, text.length() - 1).trim()));
                    text.setLength(0);
                    i = idx;
                    continue;
                }
                text.append(c);
                continue;
            }
            if (c == preparedSymbol) {
                if (i + 1 < len && src[i + 1] == openSymbol) {
                    idx = sql.indexOf(closeSymbol, i + 2);
                    if (idx == -1) {
                        text.append(c);
                        continue;
                    }
                    if (text.length() > 0) {
                        root.addNode(new TextNode(text.toString()));
                        text.setLength(0);
                    }
                    text.append(src, i, idx - i + 1);
                    root.addNode(new DynamicNode(text.substring(2, text.length() - 1).trim()));
                    text.setLength(0);
                    i = idx;
                    continue;
                }
                text.append(c);
                continue;
            }
            text.append(c);
        }
        if (text.length() > 0) {
            root.addNode(new TextNode(text.toString()));
            text.setLength(0);
        }
        return root;
    }

    public static String resolveTableRef(String sql, TableAccessible tableAccessible) {
        if (Strings.isBlank(sql)) {
            return sql;
        }
        if (tableAccessible == null) {
            return sql;
        }
        ContainerNode containerNode = SqlTextParsers.parse(sql, '&', '\uffff', '{', '}');
        containerNode.visitSubset(node -> {
            if (node.isVarNode()) {
                String tableField;
                TableSegment<?> table;
                boolean excludeAlias;
                String varName = node.getVarName();
                String[] paths = Strings.tokenizeToArray(varName, ".");
                if (paths.length == 0 || paths.length > 2) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u8868\u5b57\u6bb5\u7684\u5f15\u7528\u8868\u8fbe\u5f0f\u9519\u8bef: " + varName);
                }
                String tableAlias = paths[0].trim();
                if (Strings.isBlank(tableAlias)) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u8868\u5b57\u6bb5\u7684\u5f15\u7528\u8868\u8fbe\u5f0f\u9519\u8bef: " + varName);
                }
                boolean bl = excludeAlias = tableAlias.charAt(tableAlias.length() - 1) == '?';
                if (excludeAlias) {
                    tableAlias = tableAlias.substring(0, tableAlias.length() - 1);
                }
                if ((table = tableAlias.startsWith("#") ? tableAccessible.getTable(Integer.parseInt(tableAlias.substring(1))) : tableAccessible.getTable(tableAlias)) == null) {
                    throw new IllegalArgumentException("\u8868\u522b\u540d\u4e0d\u5b58\u5728: " + tableAlias);
                }
                String string = tableField = paths.length == 1 ? null : paths[1].trim();
                if (Strings.isBlank(tableField)) {
                    TableMeta tableMeta = table.getTableMeta();
                    if (tableMeta == null) {
                        node.bindVarValue(table.getTableAlias());
                    } else if (excludeAlias) {
                        node.bindVarValue(tableMeta.getTable());
                    } else {
                        node.bindVarValue(tableMeta.getTable() + " " + table.getTableAlias());
                    }
                } else if ("*".equals(tableField)) {
                    node.bindVarValue(table.getAllColumnExpression(!excludeAlias, false));
                } else {
                    node.bindVarValue(table.getColumnExpression(tableField, !excludeAlias));
                }
            }
        });
        return containerNode.toString();
    }

    public static String resolveTableRef(String sql) {
        if (Strings.isBlank(sql)) {
            return sql;
        }
        ContainerNode containerNode = SqlTextParsers.parse(sql, '&', '\uffff', '{', '}');
        containerNode.visitSubset(node -> {
            if (node.isVarNode()) {
                TableSegment<?> table;
                String varName = node.getVarName();
                int iLeftParenthesis = varName.indexOf(40);
                if (iLeftParenthesis < 1) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u8868\u5b57\u6bb5\u7684\u5f15\u7528\u8868\u8fbe\u5f0f\u9519\u8bef: " + varName);
                }
                int iRightParenthesis = varName.indexOf(41, iLeftParenthesis);
                if (iRightParenthesis <= iLeftParenthesis + 1) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u8868\u5b57\u6bb5\u7684\u5f15\u7528\u8868\u8fbe\u5f0f\u9519\u8bef: " + varName);
                }
                String tableAlias = varName.substring(0, iLeftParenthesis).trim();
                String entityClassName = varName.substring(iLeftParenthesis + 1, iRightParenthesis).trim();
                try {
                    Class<?> type = Class.forName(entityClassName);
                    table = TableSegment.fromEntity(type, tableAlias);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728: " + entityClassName);
                }
                TableMeta tableMeta = table.getTableMeta();
                if (tableMeta == null) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728: " + entityClassName);
                }
                boolean excludeAlias = false;
                String tableField = varName.substring(iRightParenthesis + 1).trim();
                if (!tableField.isEmpty()) {
                    int idx;
                    for (idx = 0; idx < tableField.length(); ++idx) {
                        if (Character.isWhitespace(tableField.charAt(idx))) {
                            continue;
                        }
                        if (tableField.charAt(idx) != '?') break;
                        excludeAlias = true;
                        ++idx;
                        break;
                    }
                    while (idx < tableField.length()) {
                        if (Character.isWhitespace(tableField.charAt(idx))) {
                            ++idx;
                            continue;
                        }
                        if (tableField.charAt(idx) != '.') break;
                        ++idx;
                        break;
                    }
                    tableField = tableField.substring(idx);
                }
                if (Strings.isBlank(tableField)) {
                    if (excludeAlias) {
                        node.bindVarValue(tableMeta.getTable());
                    } else {
                        node.bindVarValue(tableMeta.getTable() + " " + table.getTableAlias());
                    }
                } else if ("*".equals(tableField)) {
                    if (excludeAlias) {
                        node.bindVarValue(Strings.join((CharSequence)", ", table.getAllColumnNames()));
                    } else {
                        node.bindVarValue(table.getAllColumnExpression(false));
                    }
                } else {
                    node.bindVarValue(table.getColumnExpression(tableField, !excludeAlias));
                }
            }
        });
        return containerNode.toString();
    }
}

