/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.consts;

import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.string.Strings;

public enum Direction {
    ASC(SqlNodes.ASC),
    DESC(SqlNodes.DESC);

    private final TextNode textNode;

    private Direction(TextNode textNode) {
        this.textNode = textNode;
    }

    public String getSqlText() {
        return this.textNode.getText();
    }

    public TextNode getTextNode() {
        return this.textNode;
    }

    public static Direction parse(String value) {
        if (Strings.isBlank(value)) {
            return ASC;
        }
        if (value.trim().equalsIgnoreCase(DESC.name())) {
            return DESC;
        }
        return ASC;
    }
}

