/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.consts;

import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.DynamicNode;
import io.polaris.core.jdbc.sql.node.MixedNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.string.Strings;

public enum Operator {
    EQ("="),
    NE("<>"),
    LT("<"),
    GT(">"),
    LE("<="),
    GE(">="),
    LIKE("like"),
    NOT_LIKE("not like"),
    IN("in", "(", ")"),
    NOT_IN("not in", "(", ")"),
    NULL("is null", false),
    NOT_NULL("is not null", false);

    private String sqlText;
    private boolean hasValue = true;
    private String openToken = "";
    private String closeToken = "";

    private Operator(String sqlText) {
        this.sqlText = sqlText;
    }

    private Operator(String sqlText, boolean hasValue) {
        this.sqlText = sqlText;
        this.hasValue = hasValue;
    }

    private Operator(String sqlText, String openToken, String closeToken) {
        this.sqlText = sqlText;
        this.openToken = openToken;
        this.closeToken = closeToken;
    }

    public ContainerNode toSqlNode(String column, String varName, Object varValue, String varReplacement) {
        ContainerNode sql = new ContainerNode();
        sql.addNode(new TextNode(column + " " + this.sqlText + " "));
        if (this.hasValue) {
            if (Strings.isNotBlank(this.openToken)) {
                sql.addNode(new TextNode(this.openToken));
            }
            if (Strings.isNotBlank(varReplacement)) {
                MixedNode node = new MixedNode(varName);
                node.bindVarValue(varReplacement);
                sql.addNode(node);
            } else {
                DynamicNode node = new DynamicNode(varName);
                node.bindVarValue(varValue);
                sql.addNode(node);
            }
            if (Strings.isNotBlank(this.closeToken)) {
                sql.addNode(new TextNode(this.closeToken));
            }
        }
        return sql;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public String getOpenToken() {
        return this.openToken;
    }

    public String getCloseToken() {
        return this.closeToken;
    }
}

