/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodeOps;
import io.polaris.core.jdbc.sql.node.VarNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ContainerNode
implements SqlNode,
Cloneable {
    public static final ContainerNode EMPTY = new ContainerNode(Collections.emptyList());
    private boolean skip = false;
    private List<SqlNode> subset = new ArrayList<SqlNode>();
    private final SqlNode delimiter;
    private final SqlNode prefix;
    private final SqlNode suffix;

    public ContainerNode(SqlNode delimiter, SqlNode prefix, SqlNode suffix) {
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public ContainerNode(SqlNode delimiter, SqlNode prefix) {
        this(delimiter, prefix, null);
    }

    public ContainerNode(SqlNode delimiter) {
        this(delimiter, null, null);
    }

    public ContainerNode() {
        this(null, null, null);
    }

    private ContainerNode(List<SqlNode> subset) {
        this(null, null, null);
        this.subset = subset;
    }

    public String toString() {
        return this.asPreparedSql().getText();
    }

    @Override
    public boolean isContainerNode() {
        return true;
    }

    @Override
    public boolean isSkipped() {
        return this.skip || this.subset.isEmpty();
    }

    @Override
    public void skip(boolean skip) {
        this.skip = skip;
    }

    @Override
    public PreparedSql asPreparedSql() {
        if (this.isSkipped()) {
            return PreparedSql.EMPTY;
        }
        boolean first = true;
        StringBuilder text = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        for (SqlNode node : this.subset) {
            if (node.isSkipped()) continue;
            if (first) {
                first = false;
                this.addToPreparedSql(text, list, this.prefix);
            } else {
                this.addToPreparedSql(text, list, this.delimiter);
            }
            this.addToPreparedSql(text, list, node);
        }
        if (!first) {
            this.addToPreparedSql(text, list, this.suffix);
        }
        return new PreparedSql(text.toString(), list);
    }

    private void addToPreparedSql(StringBuilder sb, List<Object> list, SqlNode node) {
        List<Object> bindings;
        if (node == null) {
            return;
        }
        PreparedSql sql = node.asPreparedSql();
        String text = sql.getText();
        if (text != null) {
            sb.append(text);
        }
        if ((bindings = sql.getBindings()) != null) {
            list.addAll(bindings);
        }
    }

    @Override
    public BoundSql asBoundSql(VarNameGenerator generator, String openVarToken, String closeVarToken) {
        if (this.isSkipped()) {
            return BoundSql.EMPTY;
        }
        boolean first = true;
        StringBuilder text = new StringBuilder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (SqlNode node : this.subset) {
            if (node.isSkipped()) continue;
            if (first) {
                first = false;
                ContainerNode.addToBoundSql(generator, openVarToken, closeVarToken, text, map, this.prefix);
            } else {
                ContainerNode.addToBoundSql(generator, openVarToken, closeVarToken, text, map, this.delimiter);
            }
            ContainerNode.addToBoundSql(generator, openVarToken, closeVarToken, text, map, node);
        }
        if (!first) {
            ContainerNode.addToBoundSql(generator, openVarToken, closeVarToken, text, map, this.suffix);
        }
        return new BoundSql(text.toString(), map);
    }

    private static void addToBoundSql(VarNameGenerator generator, String openVarToken, String closeVarToken, StringBuilder sb, Map<String, Object> map, SqlNode node) {
        Map<String, Object> bindings;
        if (node == null) {
            return;
        }
        BoundSql sql = node.asBoundSql(generator, openVarToken, closeVarToken);
        String text = sql.getText();
        if (text != null) {
            sb.append(text);
        }
        if ((bindings = sql.getBindings()) != null) {
            map.putAll(bindings);
        }
    }

    @Override
    public ContainerNode copy() {
        return this.copy(true);
    }

    @Override
    public ContainerNode copy(boolean withVarValue) {
        ContainerNode clone = new ContainerNode();
        clone.skip = this.skip;
        for (int i = 0; i < this.subset.size(); ++i) {
            clone.subset.add(this.subset.get(i).copy(withVarValue));
        }
        return clone;
    }

    public ContainerNode clone() {
        return this.copy(true);
    }

    @Override
    public boolean isEmpty() {
        return this.subset.isEmpty();
    }

    @Override
    public List<SqlNode> subset() {
        return Collections.unmodifiableList(this.subset);
    }

    @Override
    public void addNode(SqlNode sqlNode) {
        this.addNode(-1, sqlNode);
    }

    @Override
    public void addNode(int i, SqlNode sqlNode) {
        if (i < 0 || i > this.subset.size()) {
            this.subset.add(sqlNode);
        } else {
            this.subset.add(i, sqlNode);
        }
    }

    @Override
    public void addNodes(List<SqlNode> sqlNodes) {
        if (sqlNodes instanceof RandomAccess) {
            int n = sqlNodes.size();
            for (int i = 0; i < n; ++i) {
                this.addNode(sqlNodes.get(i));
            }
        } else {
            for (SqlNode node : sqlNodes) {
                this.addNode(node);
            }
        }
    }

    @Override
    public void addNodes(SqlNode ... sqlNodes) {
        for (SqlNode node : sqlNodes) {
            this.addNode(node);
        }
    }

    @Override
    public void visitSubsetWritable(Consumer<SqlNodeOps> visitor) {
        int size = this.subset.size();
        int i = 0;
        while (i < size) {
            SqlNode node = this.subset.get(i);
            SqlNodeOps op = new SqlNodeOps(node);
            if (node instanceof ContainerNode) {
                boolean empty = ((ContainerNode)node).subset.isEmpty();
                if (!empty) {
                    ((ContainerNode)node).visitSubsetWritable(visitor);
                    if (((ContainerNode)node).subset.isEmpty()) {
                        this.subset.remove(i);
                        --size;
                        continue;
                    }
                }
            } else {
                visitor.accept(op);
                if (op.isDeleted()) {
                    this.subset.remove(i);
                    --size;
                    continue;
                }
                if (op.isReplaced()) {
                    this.subset.set(i, op.getReplaced());
                }
            }
            ++i;
        }
    }

    @Override
    public void visitSubset(Consumer<SqlNode> visitor) {
        int n = this.subset.size();
        for (int i = 0; i < n; ++i) {
            SqlNode node = this.subset.get(i);
            if (node instanceof ContainerNode) {
                ((ContainerNode)node).visitSubset(visitor);
                continue;
            }
            visitor.accept(node);
        }
    }

    @Override
    public boolean replaceFirstSub(Predicate<SqlNode> predicate, Supplier<SqlNode> supplier) {
        int n = this.subset.size();
        for (int i = 0; i < n; ++i) {
            boolean rs;
            SqlNode node = this.subset.get(i);
            if (predicate.test(node)) {
                this.subset.set(i, supplier.get());
                return true;
            }
            if (!(node instanceof ContainerNode) || !(rs = node.replaceFirstSub(predicate, supplier))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int replaceAllSubs(Predicate<SqlNode> predicate, Supplier<SqlNode> supplier) {
        int count = 0;
        int i = 0;
        int n = this.subset.size();
        while (i < n) {
            SqlNode node = this.subset.get(i);
            if (predicate.test(node)) {
                this.subset.set(i, supplier.get());
                ++count;
                --n;
                continue;
            }
            if (node instanceof ContainerNode) {
                count += ((ContainerNode)node).replaceAllSubs(predicate, supplier);
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean removeFirstSub(Predicate<SqlNode> predicate) {
        for (int i = this.subset.size() - 1; i >= 0; --i) {
            boolean rs;
            SqlNode node = this.subset.get(i);
            if (predicate.test(node)) {
                this.subset.remove(i);
                return true;
            }
            if (!(node instanceof ContainerNode) || !(rs = ((ContainerNode)node).removeFirstSub(predicate))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int removeAllSubs(Predicate<SqlNode> predicate) {
        int count = 0;
        int i = 0;
        int n = this.subset.size();
        while (i < n) {
            SqlNode node = this.subset.get(i);
            if (predicate.test(node)) {
                this.subset.remove(i);
                ++count;
                --n;
                continue;
            }
            if (node instanceof ContainerNode) {
                ((ContainerNode)node).removeAllSubs(predicate);
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public void clearSkippedSubs() {
        this.removeAllSubs(node -> node instanceof ContainerNode && ((ContainerNode)node).skip);
    }

    @Override
    public boolean containsVarName(String key) {
        int n = this.subset.size();
        for (int i = 0; i < n; ++i) {
            SqlNode node = this.subset.get(i);
            if (!(node.isVarNode() ? Objects.equals(node.getVarName(), key) : node.isContainerNode() && node.containsVarName(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void bindSubsetVarValues(Map<String, Object> params, boolean ignoreNull) {
        this.visitSubset(node -> {
            Object param;
            if (node.isVarNode() && ((param = params.get(node.getVarName())) != null || !ignoreNull)) {
                node.bindVarValue(param);
            }
        });
    }

    @Override
    public void bindSubsetVarValue(String varName, Object varValue, boolean ignoreNull) {
        if (ignoreNull && varValue == null) {
            return;
        }
        this.visitSubset(node -> {
            if (node.isVarNode() && Objects.equals(node.getVarName(), varName)) {
                node.bindVarValue(varValue);
            }
        });
    }

    @Override
    public void removeVarValue(String varName) {
        this.visitSubset(node -> {
            if (node.isVarNode() && Objects.equals(node.getVarName(), varName)) {
                node.removeVarValue();
            }
        });
    }

    @Override
    public void skipIfMissingVarValue() {
        for (int i = this.subset.size() - 1; i >= 0; --i) {
            SqlNode node = this.subset.get(i);
            if (node.isVarNode()) {
                if (node.getVarValue() != null) continue;
                this.skip = true;
                break;
            }
            if (!(node instanceof ContainerNode)) continue;
            ((ContainerNode)node).skipIfMissingVarValue();
        }
    }
}

