/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.node;

import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.VarNameGenerator;
import io.polaris.core.jdbc.sql.node.VarNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MixedNode
extends VarNode
implements Cloneable {
    public MixedNode(String varName) {
        super(varName);
    }

    public String getReplacement() {
        List<Object> parameters = this.getVarValues();
        if (parameters == null || parameters.isEmpty()) {
            return SqlNodes.NULL.getText();
        }
        StringBuilder text = new StringBuilder();
        for (Object parameter : parameters) {
            if (text.length() > 0) {
                text.append(",");
            }
            text.append(Objects.toString(parameter));
        }
        return text.toString();
    }

    @Override
    public PreparedSql asPreparedSql() {
        return new PreparedSql(this.getReplacement(), Collections.emptyList());
    }

    @Override
    public BoundSql asBoundSql(VarNameGenerator generator, String openVarToken, String closeVarToken) {
        return new BoundSql(this.getReplacement(), Collections.emptyMap());
    }

    @Override
    public boolean isMixedNode() {
        return true;
    }

    @Override
    public MixedNode copy() {
        return this.copy(true);
    }

    @Override
    public MixedNode copy(boolean withVarValue) {
        MixedNode clone = new MixedNode(this.varName);
        if (withVarValue && this.varValues != null) {
            clone.varValue = this.varValue;
            clone.varValues = new ArrayList(this.varValues);
        }
        return clone;
    }

    public MixedNode clone() {
        return this.copy(true);
    }
}

