/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.query;

import io.polaris.core.jdbc.sql.consts.Direction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class OrderBy {
    private final Set<Item> items = new LinkedHashSet<Item>();

    public static OrderBy newOrderBy() {
        return new OrderBy();
    }

    public Set<Item> items() {
        return Collections.unmodifiableSet(this.items);
    }

    public OrderBy by(String field) {
        return this.by(Direction.ASC, field);
    }

    public OrderBy by(Direction direction, String field) {
        return this.by(new Item(direction, field));
    }

    public OrderBy by(Item item) {
        this.items.add(item);
        return this;
    }

    public OrderBy remove(String field) {
        return this.remove(Direction.ASC, field);
    }

    public OrderBy remove(Direction direction, String field) {
        return this.remove(new Item(direction, field));
    }

    public OrderBy remove(Item item) {
        this.items.remove(item);
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Item> this$items = this.items;
        Set<Item> other$items = other.items;
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderBy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Item> $items = this.items;
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "OrderBy(items=" + this.items + ")";
    }

    public Set<Item> getItems() {
        return this.items;
    }

    public static class Item {
        private Direction direction = Direction.ASC;
        private String field;

        public Item() {
        }

        public Item(Direction direction, String field) {
            this.direction = direction;
            this.field = field;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getField() {
            return this.field;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Direction this$direction = this.direction;
            Direction other$direction = other.direction;
            if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
                return false;
            }
            String this$field = this.field;
            String other$field = other.field;
            return !(this$field == null ? other$field != null : !this$field.equals(other$field));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Direction $direction = this.direction;
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            String $field = this.field;
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            return result;
        }

        public String toString() {
            return "OrderBy.Item(direction=" + (Object)((Object)this.direction) + ", field=" + this.field + ")";
        }
    }
}

