/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement;

import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseStatement;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.jdbc.sql.statement.ConfigurableColumnPredicate;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.ColumnSegment;
import io.polaris.core.jdbc.sql.statement.segment.SelectSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.jdbc.sql.statement.segment.WhereSegment;
import io.polaris.core.jdbc.table.DualEntity;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class MergeStatement<S extends MergeStatement<S>>
extends BaseStatement<S>
implements TableAccessible {
    private final TableSegment<?> table;
    private TableSegment<?> using;
    private AndSegment<S, ?> on;
    private final List<ColumnSegment<S, ?>> insertColumns = new ArrayList();
    private final List<ColumnSegment<S, ?>> updateColumns = new ArrayList();
    private boolean updateWhenMatched;
    private boolean insertWhenNotMatched;

    public MergeStatement(Class<?> entityClass, String alias) {
        if (Strings.isBlank(alias)) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a\u522b\u540d");
        }
        this.table = TableSegment.fromEntity(entityClass, alias);
    }

    public static MergeStatement<?> of(Class<?> entityClass, String alias) {
        return new MergeStatement(entityClass, alias);
    }

    protected <T extends AndSegment<S, T>> T buildWhere() {
        return (T)new AndSegment(this.getThis(), this.table);
    }

    @Override
    public SqlNode toSqlNode() {
        ContainerNode sql = new ContainerNode();
        this.sqlMerge(sql);
        this.sqlUsing(sql);
        this.sqlOn(sql);
        this.sqlUpdate(sql);
        this.sqlInsert(sql);
        return sql;
    }

    private void sqlMerge(ContainerNode sql) {
        if (!sql.isEmpty()) {
            sql.addNode(SqlNodes.LF);
        }
        sql.addNodes(SqlNodes.MERGE, SqlNodes.INTO, this.table.toSqlNode());
    }

    private void sqlUsing(ContainerNode sql) {
        if (!sql.isEmpty()) {
            sql.addNode(SqlNodes.LF);
        }
        sql.addNodes(SqlNodes.USING, this.using.toSqlNode());
    }

    private void sqlOn(ContainerNode sql) {
        if (!sql.isEmpty()) {
            sql.addNode(SqlNodes.LF);
        }
        sql.addNodes(SqlNodes.ON, SqlNodes.LEFT_PARENTHESIS, this.on.toSqlNode(), SqlNodes.RIGHT_PARENTHESIS);
    }

    private void sqlUpdate(ContainerNode sql) {
        if (!this.updateWhenMatched) {
            return;
        }
        if (!sql.isEmpty()) {
            sql.addNode(SqlNodes.LF);
        }
        sql.addNode(SqlNodes.WHEN_MATCHED_THEN);
        sql.addNode(SqlNodes.UPDATE);
        boolean first = true;
        for (ColumnSegment<S, ?> column : this.updateColumns) {
            if (first) {
                sql.addNode(SqlNodes.LF);
                sql.addNode(SqlNodes.SET);
                first = false;
            } else {
                sql.addNode(SqlNodes.LF);
                sql.addNode(SqlNodes.COMMA);
            }
            String columnName = column.getColumnName();
            sql.addNode(new TextNode(this.table.getTableAlias() + "." + columnName + " = "));
            sql.addNode(column.toValueSqlNode());
        }
    }

    private void sqlInsert(ContainerNode sql) {
        if (!this.insertWhenNotMatched) {
            return;
        }
        if (!sql.isEmpty()) {
            sql.addNode(SqlNodes.LF);
        }
        sql.addNode(SqlNodes.WHEN_NOT_MATCHED_THEN);
        sql.addNode(SqlNodes.INSERT);
        boolean first = true;
        for (ColumnSegment<S, ?> column : this.insertColumns) {
            if (first) {
                sql.addNode(SqlNodes.LF);
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                first = false;
            } else {
                sql.addNode(SqlNodes.COMMA);
            }
            sql.addNode(new TextNode(column.getColumnName()));
        }
        if (!first) {
            sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
        }
        first = true;
        for (ColumnSegment<S, ?> column : this.insertColumns) {
            if (first) {
                sql.addNode(SqlNodes.LF);
                sql.addNode(SqlNodes.VALUES);
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                first = false;
            } else {
                sql.addNode(SqlNodes.COMMA);
            }
            sql.addNode(column.toValueSqlNode());
        }
        if (!first) {
            sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
        }
    }

    public S withEntity(Object entity) {
        return this.withEntity(entity, ColumnPredicate.DEFAULT);
    }

    public S withEntity(Object entity, boolean updateWhenMatched, boolean insertWhenNotMatched) {
        return this.withEntity(entity, updateWhenMatched, insertWhenNotMatched, ColumnPredicate.DEFAULT);
    }

    public S withEntity(Object entity, ColumnPredicate columnPredicate) {
        return this.withEntity(entity, true, true, columnPredicate);
    }

    public S withEntity(Object entity, Predicate<String> isIncludeEmptyColumns) {
        return this.withEntity(entity, true, true, ConfigurableColumnPredicate.of(isIncludeEmptyColumns));
    }

    public S withEntity(Object entity, Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        return this.withEntity(entity, true, true, ConfigurableColumnPredicate.of(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty));
    }

    public S withEntity(Object entity, boolean updateWhenMatched, boolean insertWhenNotMatched, Predicate<String> isIncludeEmptyColumns) {
        return this.withEntity(entity, updateWhenMatched, insertWhenNotMatched, ConfigurableColumnPredicate.of(isIncludeEmptyColumns));
    }

    public S withEntity(Object entity, boolean updateWhenMatched, boolean insertWhenNotMatched, Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        return this.withEntity(entity, updateWhenMatched, insertWhenNotMatched, ConfigurableColumnPredicate.of(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty));
    }

    public S withEntity(Object entity, boolean updateWhenMatched, boolean insertWhenNotMatched, ColumnPredicate columnPredicate) {
        TableMeta tableMeta = this.table.getTableMeta();
        if (tableMeta != null) {
            boolean include;
            Object val;
            Object val1;
            ColumnMeta meta;
            String name;
            if (tableMeta.getColumns().values().stream().noneMatch(ColumnMeta::isPrimaryKey)) {
                throw new IllegalArgumentException("\u672a\u914d\u7f6e\u4e3b\u952e\u5217\uff1a" + tableMeta.getEntityClass().getName());
            }
            BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
            SelectStatement using = new SelectStatement(DualEntity.class);
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                String name2 = entry.getKey();
                ColumnMeta meta2 = entry.getValue();
                if (!meta2.isPrimaryKey()) continue;
                Object val12 = entityMap.get(meta2.getFieldName());
                Object val2 = BindingValues.getValueForInsert(meta2, val12);
                ((SelectSegment)((SelectSegment)using.select()).column("dummy")).value(val2, name2);
            }
            String tableAlias = this.table.getTableAlias();
            String usingAlias = "S".equalsIgnoreCase(tableAlias) ? "O" : "S";
            this.using(using, usingAlias);
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                name = entry.getKey();
                meta = entry.getValue();
                if (!meta.isPrimaryKey()) continue;
                ((WhereSegment)this.on()).column(name).eq(TableField.of(usingAlias, name));
            }
            this.updateWhenMatched(updateWhenMatched);
            if (updateWhenMatched) {
                for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                    name = entry.getKey();
                    meta = entry.getValue();
                    boolean updatable = meta.isUpdatable() || meta.isVersion() || meta.isUpdateTime();
                    if (!updatable || meta.isPrimaryKey() || !columnPredicate.isIncludedColumn(name)) continue;
                    val1 = entityMap.get(meta.getFieldName());
                    val = BindingValues.getValueForUpdate(meta, val1);
                    if (meta.isVersion()) {
                        val = val == null ? 1L : ((Number)val).longValue() + 1L;
                    }
                    if (!(include = columnPredicate.isIncludedEmptyColumn(name) || Objs.isNotEmpty(val))) continue;
                    this.update(name, val);
                }
            }
            this.insertWhenNotMatched(insertWhenNotMatched);
            if (insertWhenNotMatched) {
                for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                    name = entry.getKey();
                    meta = entry.getValue();
                    boolean insertable = meta.isInsertable() || meta.isCreateTime() || meta.isUpdateTime();
                    if (!insertable || !columnPredicate.isIncludedColumn(name)) continue;
                    val1 = entityMap.get(meta.getFieldName());
                    val = BindingValues.getValueForInsert(meta, val1);
                    if (meta.isVersion()) {
                        val = val == null ? 1L : ((Number)val).longValue();
                    }
                    if (!(include = columnPredicate.isIncludedEmptyColumn(name) || Objs.isNotEmpty(val))) continue;
                    this.insert(name, val);
                }
            }
        }
        return (S)((MergeStatement)this.getThis());
    }

    public S using(SelectStatement<?> select, String alias) {
        this.using = TableSegment.fromSelect(select, alias);
        return (S)((MergeStatement)this.getThis());
    }

    public S using(Class<?> entityClass, String alias) {
        this.using = TableSegment.fromEntity(entityClass, alias);
        return (S)((MergeStatement)this.getThis());
    }

    public <T extends AndSegment<S, T>> T on() {
        this.on = Objs.defaultIfNull(this.on, this::buildWhere);
        return (T)this.on;
    }

    public S updateWhenMatched() {
        return this.updateWhenMatched(true);
    }

    public S insertWhenNotMatched() {
        return this.insertWhenNotMatched(true);
    }

    public S updateWhenMatched(boolean enabled) {
        this.updateWhenMatched = enabled;
        return (S)((MergeStatement)this.getThis());
    }

    public S insertWhenNotMatched(boolean enabled) {
        this.insertWhenNotMatched = enabled;
        return (S)((MergeStatement)this.getThis());
    }

    private ColumnSegment<S, ?> buildColumnSegment() {
        return new ColumnSegment(this.getThis(), this.table);
    }

    public S insertWith(String field, String usingField) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.column(field)).value(SqlNodes.text(this.using.getColumnExpression(usingField)));
        this.insertColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S insert(String field, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.column(field)).value(value);
        this.insertColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S insertRawWith(String rawColumn, String usingColumn) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.rawColumn(rawColumn)).value(SqlNodes.text(usingColumn));
        this.insertColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S insertRaw(String rawColumn, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.rawColumn(rawColumn)).value(value);
        this.insertColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S updateWith(String field, String usingField) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.column(field)).value(SqlNodes.text(this.using.getColumnExpression(usingField)));
        this.updateColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S update(String field, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.column(field)).value(value);
        this.updateColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S updateRawWith(String rawColumn, String usingColumn) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.rawColumn(rawColumn)).value(SqlNodes.text(usingColumn));
        this.updateColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    public S updateRaw(String rawColumn, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.rawColumn(rawColumn)).value(value);
        this.updateColumns.add(column);
        return (S)((MergeStatement)this.getThis());
    }

    @Override
    public TableSegment<?> getTable(String tableAlias) {
        if (Objs.equals(this.table.getTableAlias(), tableAlias)) {
            return this.table;
        }
        if (Objs.equals(this.using.getTableAlias(), tableAlias)) {
            return this.using;
        }
        throw new IllegalArgumentException("no such table! tableAlias: " + tableAlias);
    }

    @Override
    public TableSegment<?> getTable(int tableIndex) {
        if (tableIndex < 0) {
            throw new IllegalArgumentException("tableIndex: " + tableIndex);
        }
        if (tableIndex == 0) {
            return this.table;
        }
        if (tableIndex == 1) {
            return this.using;
        }
        throw new IllegalArgumentException("no such table! tableIndex: " + tableIndex);
    }
}

