/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.query.Queries;
import io.polaris.core.jdbc.sql.statement.BaseStatement;
import io.polaris.core.jdbc.sql.statement.JoinDriver;
import io.polaris.core.jdbc.sql.statement.SetOpsStatement;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.GroupBySegment;
import io.polaris.core.jdbc.sql.statement.segment.JoinBuilder;
import io.polaris.core.jdbc.sql.statement.segment.JoinSegment;
import io.polaris.core.jdbc.sql.statement.segment.OrderBySegment;
import io.polaris.core.jdbc.sql.statement.segment.SelectSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

@AnnotationProcessing
public class SelectStatement<S extends SelectStatement<S>>
extends BaseStatement<S>
implements TableAccessible {
    private boolean distinct = false;
    private final List<SelectSegment<S, ?>> selects = new ArrayList();
    private final TableSegment<?> table;
    private final List<JoinSegment<S, ?>> joins = new ArrayList();
    private AndSegment<S, ?> where;
    private final List<GroupBySegment<S, ?>> groupBys = new ArrayList();
    private AndSegment<S, ?> having;
    private final List<OrderBySegment<S, ?>> orderBys = new ArrayList();
    private final Function<String, String> columnDiscovery;
    private final List<Criteria> criteriaList = new ArrayList<Criteria>();
    private final List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private boolean quotaSelectAlias = false;
    private TableAccessible nestedTableAccessible;

    @AnnotationProcessing
    public SelectStatement(Class<?> entityClass) {
        this(entityClass, null);
    }

    @AnnotationProcessing
    public SelectStatement(Class<?> entityClass, String alias) {
        this.table = TableSegment.fromEntity(entityClass, alias);
        this.columnDiscovery = this.columnDiscovery();
    }

    public SelectStatement(SelectStatement<?> select, String alias) {
        this.table = TableSegment.fromSelect(select, alias);
        this.columnDiscovery = this.columnDiscovery();
    }

    public SelectStatement(SetOpsStatement<?> select, String alias) {
        this.table = TableSegment.fromSetOps(select, alias);
        this.columnDiscovery = this.columnDiscovery();
    }

    public static SelectStatement<?> of(Class<?> entityClass, String alias) {
        return new SelectStatement(entityClass, alias);
    }

    public static SelectStatement<?> of(SelectStatement<?> select, String alias) {
        return new SelectStatement(select, alias);
    }

    public static SelectStatement<?> of(SetOpsStatement<?> select, String alias) {
        return new SelectStatement(select, alias);
    }

    private Function<String, String> columnDiscovery() {
        return field -> {
            String col = null;
            try {
                if (this.table != null) {
                    col = this.table.getColumnExpression((String)field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (col == null && !this.joins.isEmpty()) {
                for (JoinSegment<S, ?> join : this.joins) {
                    try {
                        col = join.getTable().getColumnExpression((String)field);
                        if (col == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return col;
        };
    }

    @AnnotationProcessing
    protected SelectSegment<S, ?> buildSelect() {
        return new SelectSegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected AndSegment<S, ?> buildWhere() {
        return new AndSegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected GroupBySegment<S, ?> buildGroupBy() {
        return new GroupBySegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected OrderBySegment<S, ?> buildOrderBy() {
        return new OrderBySegment(this.getThis(), this.table);
    }

    public SqlNode toCountSqlNode() {
        ContainerNode sql = new ContainerNode();
        sql.addNode(new TextNode("SELECT COUNT(*) FROM ("));
        this.sqlSelect(sql);
        this.sqlFrom(sql);
        this.sqlJoin(sql);
        this.sqlWhere(sql);
        this.sqlGroupBy(sql);
        this.sqlHaving(sql);
        sql.addNode(SqlNodes.LF);
        sql.addNode(new TextNode(") tbl"));
        return sql;
    }

    public SqlNode toExistsSqlNode(boolean queryByCount) {
        ContainerNode sql = new ContainerNode();
        if (queryByCount) {
            sql.addNode(new TextNode("SELECT COUNT(*) EXISTED FROM ("));
            this.sqlSelect(sql);
        } else {
            sql.addNode(new TextNode("SELECT 1 EXISTED "));
        }
        this.sqlFrom(sql);
        this.sqlJoin(sql);
        this.sqlWhere(sql);
        this.sqlGroupBy(sql);
        this.sqlHaving(sql);
        if (queryByCount) {
            sql.addNode(SqlNodes.LF);
            sql.addNode(new TextNode(") tbl"));
        }
        return sql;
    }

    @Override
    public SqlNode toSqlNode() {
        ContainerNode sql = new ContainerNode();
        this.sqlSelect(sql);
        this.sqlFrom(sql);
        this.sqlJoin(sql);
        this.sqlWhere(sql);
        this.sqlGroupBy(sql);
        this.sqlHaving(sql);
        this.sqlOrderBy(sql);
        return sql;
    }

    private void sqlSelect(ContainerNode sql) {
        boolean first = true;
        if (!this.selects.isEmpty()) {
            for (SelectSegment<S, ?> selectSegment : this.selects) {
                SqlNode sqlNode = selectSegment.toSqlNode(this.quotaSelectAlias);
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.SELECT);
                    if (this.distinct) {
                        sql.addNode(SqlNodes.DISTINCT);
                    }
                    first = false;
                } else {
                    sql.addNode(SqlNodes.COMMA);
                }
                sql.addNode(sqlNode);
            }
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment joinSegment : this.joins) {
                List joinSelects = joinSegment.getSelects();
                if (joinSelects.isEmpty()) continue;
                for (SelectSegment selectSegment : joinSelects) {
                    SqlNode sqlNode = selectSegment.toSqlNode(this.quotaSelectAlias);
                    if (sqlNode.isSkipped()) continue;
                    if (!sql.isEmpty()) {
                        sql.addNode(SqlNodes.LF);
                    }
                    if (first) {
                        sql.addNode(SqlNodes.SELECT);
                        if (this.distinct) {
                            sql.addNode(SqlNodes.DISTINCT);
                        }
                        first = false;
                    } else {
                        sql.addNode(SqlNodes.COMMA);
                    }
                    sql.addNode(sqlNode);
                }
            }
        }
    }

    private void sqlFrom(ContainerNode sql) {
        if (this.table != null) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            sql.addNode(SqlNodes.FROM);
            sql.addNode(this.table.toSqlNode());
        }
    }

    private void sqlJoin(ContainerNode sql) {
        if (!this.joins.isEmpty()) {
            for (JoinSegment<S, ?> join : this.joins) {
                SqlNode onSqlNode;
                boolean skippedOn;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (skippedOn = (onSqlNode = join.toOnSqlNode()).isSkipped()) {
                    sql.addNode(SqlNodes.COMMA);
                } else {
                    sql.addNode(join.getConj());
                }
                sql.addNode(join.getTable().toSqlNode());
                if (skippedOn) continue;
                sql.addNode(SqlNodes.ON);
                sql.addNode(onSqlNode);
            }
        }
    }

    private void sqlWhere(ContainerNode sql) {
        SqlNode sqlNode;
        SqlNode sqlNode2;
        boolean first = true;
        if (this.where != null && !(sqlNode2 = this.where.toSqlNode()).isSkipped()) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            sql.addNode(SqlNodes.WHERE);
            first = false;
            sql.addNode(sqlNode2);
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment<S, ?> join : this.joins) {
                sqlNode = join.toWhereSqlNode();
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.WHERE);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.AND);
                }
                sql.addNode(sqlNode);
            }
        }
        if (!this.criteriaList.isEmpty()) {
            for (Criteria criteria : this.criteriaList) {
                sqlNode = Queries.parse(criteria, false, this.columnDiscovery);
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.WHERE);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.AND);
                }
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                sql.addNode(sqlNode);
                sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            }
        }
    }

    private void sqlGroupBy(ContainerNode sql) {
        boolean first = true;
        if (!this.groupBys.isEmpty()) {
            for (GroupBySegment<S, ?> groupBySegment : this.groupBys) {
                SqlNode sqlNode = groupBySegment.toSqlNode();
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.GROUP_BY);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.COMMA);
                }
                sql.addNode(sqlNode);
            }
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment joinSegment : this.joins) {
                List joinGroupBys = joinSegment.getGroupBys();
                if (joinGroupBys == null || joinGroupBys.isEmpty()) continue;
                for (GroupBySegment groupBy : joinGroupBys) {
                    SqlNode sqlNode = groupBy.toSqlNode();
                    if (sqlNode.isSkipped()) continue;
                    if (!sql.isEmpty()) {
                        sql.addNode(SqlNodes.LF);
                    }
                    if (first) {
                        sql.addNode(SqlNodes.GROUP_BY);
                        first = false;
                    } else {
                        sql.addNode(SqlNodes.COMMA);
                    }
                    sql.addNode(sqlNode);
                }
            }
        }
    }

    private void sqlHaving(ContainerNode sql) {
        SqlNode sqlNode;
        boolean first = true;
        if (this.having != null && !(sqlNode = this.having.toSqlNode()).isSkipped()) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            if (first) {
                sql.addNode(SqlNodes.HAVING);
                first = false;
            } else {
                sql.addNode(SqlNodes.AND);
            }
            sql.addNode(sqlNode);
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment<S, ?> join : this.joins) {
                SqlNode sqlNode2;
                AndSegment<?, ?> joinHaving = join.getHaving();
                if (joinHaving == null || (sqlNode2 = joinHaving.toSqlNode()).isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.HAVING);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.AND);
                }
                sql.addNode(sqlNode2);
            }
        }
    }

    private void sqlOrderBy(ContainerNode sql) {
        SqlNode sqlNode;
        boolean first = true;
        if (!this.orderBys.isEmpty()) {
            for (OrderBySegment<S, ?> orderBySegment : this.orderBys) {
                sqlNode = orderBySegment.toSqlNode();
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.ORDER_BY);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.COMMA);
                }
                sql.addNode(sqlNode);
            }
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment joinSegment : this.joins) {
                List joinOrderBys = joinSegment.getOrderBys();
                if (joinOrderBys == null || joinOrderBys.isEmpty()) continue;
                for (OrderBySegment orderBy : joinOrderBys) {
                    SqlNode sqlNode2 = orderBy.toSqlNode();
                    if (sqlNode2.isSkipped()) continue;
                    if (!sql.isEmpty()) {
                        sql.addNode(SqlNodes.LF);
                    }
                    if (first) {
                        sql.addNode(SqlNodes.ORDER_BY);
                        first = false;
                    } else {
                        sql.addNode(SqlNodes.COMMA);
                    }
                    sql.addNode(sqlNode2);
                }
            }
        }
        if (!this.orderByList.isEmpty()) {
            for (OrderBy orderBy : this.orderByList) {
                sqlNode = Queries.parse(orderBy, this.columnDiscovery);
                if (sqlNode.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.ORDER_BY);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.COMMA);
                }
                sql.addNode(sqlNode);
            }
        }
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> join(JoinBuilder<S, J> builder) {
        return new JoinDriver<SelectStatement, JoinSegment>((SelectStatement)this.getThis(), this.joins::add, builder);
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> innerJoin(JoinBuilder<S, J> builder) {
        return this.join(builder).inner();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> leftJoin(JoinBuilder<S, J> builder) {
        return this.join(builder).left();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> rightJoin(JoinBuilder<S, J> builder) {
        return this.join(builder).right();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> outerJoin(JoinBuilder<S, J> builder) {
        return this.join(builder).outer();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> join(SelectStatement<?> select) {
        JoinBuilder<SelectStatement, JoinSegment> builder = (statement, conj, alias) -> new JoinSegment(statement, conj, select, alias);
        return new JoinDriver<SelectStatement, JoinSegment>((SelectStatement)this.getThis(), this.joins::add, builder);
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> join(Class<?> entityClass) {
        JoinBuilder<SelectStatement, JoinSegment> builder = (statement, conj, alias) -> new JoinSegment(statement, conj, entityClass, alias);
        return new JoinDriver<SelectStatement, JoinSegment>((SelectStatement)this.getThis(), this.joins::add, builder);
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> innerJoin(Class<?> entityClass) {
        return this.join(entityClass).inner();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> leftJoin(Class<?> entityClass) {
        return this.join(entityClass).left();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> rightJoin(Class<?> entityClass) {
        return this.join(entityClass).right();
    }

    public <J extends JoinSegment<S, J>> JoinDriver<S, J> outerJoin(Class<?> entityClass) {
        return this.join(entityClass).outer();
    }

    protected <J extends JoinSegment<S, J>> J join(TextNode conj, SelectStatement<?> select, String alias) {
        JoinSegment join = new JoinSegment(this.getThis(), conj, select, alias);
        this.joins.add(join);
        return (J)join;
    }

    public <J extends JoinSegment<S, J>> J join(SelectStatement<?> select, String alias) {
        return this.join(SqlNodes.JOIN, select, alias);
    }

    public <J extends JoinSegment<S, J>> J innerJoin(SelectStatement<?> select, String alias) {
        return this.join(SqlNodes.INNER_JOIN, select, alias);
    }

    public <J extends JoinSegment<S, J>> J leftJoin(SelectStatement<?> select, String alias) {
        return this.join(SqlNodes.LEFT_JOIN, select, alias);
    }

    public <J extends JoinSegment<S, J>> J rightJoin(SelectStatement<?> select, String alias) {
        return this.join(SqlNodes.RIGHT_JOIN, select, alias);
    }

    public <J extends JoinSegment<S, J>> J outerJoin(SelectStatement<?> select, String alias) {
        return this.join(SqlNodes.OUTER_JOIN, select, alias);
    }

    protected <J extends JoinSegment<S, J>> J join(TextNode conj, Class<?> entityClass, String alias) {
        JoinSegment join = new JoinSegment(this.getThis(), conj, entityClass, alias);
        this.joins.add(join);
        return (J)join;
    }

    public <J extends JoinSegment<S, J>> J join(Class<?> entityClass, String alias) {
        return this.join(SqlNodes.JOIN, entityClass, alias);
    }

    public <J extends JoinSegment<S, J>> J innerJoin(Class<?> entityClass, String alias) {
        return this.join(SqlNodes.INNER_JOIN, entityClass, alias);
    }

    public <J extends JoinSegment<S, J>> J leftJoin(Class<?> entityClass, String alias) {
        return this.join(SqlNodes.LEFT_JOIN, entityClass, alias);
    }

    public <J extends JoinSegment<S, J>> J rightJoin(Class<?> entityClass, String alias) {
        return this.join(SqlNodes.RIGHT_JOIN, entityClass, alias);
    }

    public <J extends JoinSegment<S, J>> J outerJoin(Class<?> entityClass, String alias) {
        return this.join(SqlNodes.OUTER_JOIN, entityClass, alias);
    }

    public S distinct() {
        this.distinct = true;
        return (S)((SelectStatement)this.getThis());
    }

    @AnnotationProcessing
    public <T extends SelectSegment<S, T>> T select() {
        SelectSegment<S, ?> segment = this.buildSelect();
        this.selects.add(segment);
        return (T)segment;
    }

    public S quotaSelectAlias(boolean quotaSelectAlias) {
        this.quotaSelectAlias = quotaSelectAlias;
        return (S)((SelectStatement)this.getThis());
    }

    public S selectAll() {
        if (this.table == null) {
            throw new IllegalArgumentException("no table");
        }
        Object segment = this.buildSelect().column("*");
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((SelectStatement)this.getThis());
    }

    public S selectRaw(String ... rawColumns) {
        return this.select(SqlNodes.text(SqlTextParsers.resolveTableRef(Strings.join((CharSequence)",", rawColumns), this)));
    }

    public S select(SqlNode sqlNode) {
        Object segment = this.buildSelect().sql(sqlNode);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((SelectStatement)this.getThis());
    }

    public <T, R> S select(GetterFunction<T, R> getter) {
        return this.select(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public S select(String field) {
        Object segment = this.buildSelect().column(field);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((SelectStatement)this.getThis());
    }

    public <T, R> S select(GetterFunction<T, R> getter, String alias) {
        return this.select(Reflects.getPropertyName(getter), alias);
    }

    @AnnotationProcessing
    public S select(String field, String alias) {
        Object segment = this.buildSelect().column(field);
        ((SelectSegment)segment).alias(alias);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((SelectStatement)this.getThis());
    }

    public S nested(TableAccessibleHolder tableAccessibleHolder) {
        this.nestedTableAccessible = tableAccessibleHolder.getTableAccessible();
        return (S)((SelectStatement)this.getThis());
    }

    public <T extends SelectSegment<S, T>> T nestedSelect(String tableAlias) {
        SelectSegment segment = new SelectSegment(this.getThis(), this.nestedTableAccessible.getTable(tableAlias));
        this.selects.add(segment);
        return (T)segment;
    }

    public S nestedSelect(String tableAlias, String field) {
        return (S)((SelectStatement)((SelectSegment)((SelectSegment)this.nestedSelect(tableAlias)).column(field)).end());
    }

    public S nestedSelect(String tableAlias, String field, String fieldAlias) {
        return (S)((SelectStatement)((SelectSegment)((SelectSegment)this.nestedSelect(tableAlias)).column(field)).alias(fieldAlias));
    }

    public <T, R> S nestedSelect(String tableAlias, GetterFunction<T, R> field) {
        return (S)((SelectStatement)((SelectSegment)((SelectSegment)this.nestedSelect(tableAlias)).column(Reflects.getPropertyName(field))).end());
    }

    public <T, R> S nestedSelect(String tableAlias, GetterFunction<T, R> field, String fieldAlias) {
        return (S)((SelectStatement)((SelectSegment)((SelectSegment)this.nestedSelect(tableAlias)).column(Reflects.getPropertyName(field))).alias(fieldAlias));
    }

    @AnnotationProcessing
    public <W extends AndSegment<S, W>> W where() {
        this.where = Objs.defaultIfNull(this.where, this::buildWhere);
        return (W)this.where;
    }

    public S where(Criteria criteria) {
        if (criteria != null) {
            this.criteriaList.add(criteria);
        }
        return (S)((SelectStatement)this.getThis());
    }

    @AnnotationProcessing
    public <G extends GroupBySegment<S, G>> G groupBy() {
        GroupBySegment<S, ?> groupBy = this.buildGroupBy();
        this.groupBys.add(groupBy);
        return (G)groupBy;
    }

    @AnnotationProcessing
    public <H extends AndSegment<S, H>> H having() {
        this.having = Objs.defaultIfNull(this.having, this::buildWhere);
        return (H)this.having;
    }

    @AnnotationProcessing
    public <E extends OrderBySegment<S, E>> E orderBy() {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        this.orderBys.add(orderBy);
        return (E)orderBy;
    }

    public S orderBy(OrderBy orderBy) {
        if (orderBy != null) {
            this.orderByList.add(orderBy);
        }
        return (S)((SelectStatement)this.getThis());
    }

    public S orderByRaw(String ... rawSql) {
        for (String s : rawSql) {
            OrderBySegment<S, ?> orderBy = this.buildOrderBy();
            orderBy.sql(new TextNode(s));
            this.orderBys.add(orderBy);
        }
        return (S)((SelectStatement)this.getThis());
    }

    public <T, R> S orderBy(GetterFunction<T, R> getter) {
        return this.orderBy(Reflects.getPropertyName(getter));
    }

    public S orderBy(String field) {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        orderBy.column(field);
        this.orderBys.add(orderBy);
        return (S)((SelectStatement)this.getThis());
    }

    public <T, R> S orderByDesc(GetterFunction<T, R> getter) {
        return this.orderByDesc(Reflects.getPropertyName(getter));
    }

    public S orderByDesc(String field) {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        ((OrderBySegment)orderBy.column(field)).desc();
        this.orderBys.add(orderBy);
        return (S)((SelectStatement)this.getThis());
    }

    @Override
    public TableAccessible getTableAccessible() {
        return this;
    }

    @AnnotationProcessing
    public TableSegment<?> getTable() {
        return this.table;
    }

    @Override
    public TableSegment<?> getTable(String tableAlias) {
        if (Objs.equals(this.table.getTableAlias(), tableAlias)) {
            return this.table;
        }
        for (JoinSegment<S, ?> join : this.joins) {
            TableSegment<?> joinTable = join.getTable();
            if (!Objs.equals(joinTable.getTableAlias(), tableAlias)) continue;
            return joinTable;
        }
        if (this.nestedTableAccessible != null) {
            return this.nestedTableAccessible.getTable(tableAlias);
        }
        throw new IllegalArgumentException("no such table! tableAlias: " + tableAlias);
    }

    @Override
    public TableSegment<?> getTable(int tableIndex) {
        if (tableIndex < 0) {
            throw new IllegalArgumentException("tableIndex: " + tableIndex);
        }
        if (tableIndex == 0) {
            return this.table;
        }
        int joinSize = this.joins.size();
        if (tableIndex <= joinSize) {
            return this.joins.get(tableIndex - 1).getTable();
        }
        if (this.nestedTableAccessible != null) {
            return this.nestedTableAccessible.getTable(tableIndex - joinSize);
        }
        throw new IllegalArgumentException("no such table! tableIndex: " + tableIndex);
    }

    public List<String> getSelectRawColumns() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.selects.isEmpty()) {
            for (SelectSegment<S, ?> selectSegment : this.selects) {
                list.addAll(selectSegment.getSelectRawColumns());
            }
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment joinSegment : this.joins) {
                for (SelectSegment select : joinSegment.getSelects()) {
                    list.addAll(select.getSelectRawColumns());
                }
            }
        }
        return list;
    }

    public boolean hasSelectRawColumn(String columnOrAlias) {
        if (!this.selects.isEmpty()) {
            for (SelectSegment<S, ?> selectSegment : this.selects) {
                if (!selectSegment.hasSelectRawColumn(columnOrAlias)) continue;
                return true;
            }
        }
        if (!this.joins.isEmpty()) {
            for (JoinSegment joinSegment : this.joins) {
                for (SelectSegment select : joinSegment.getSelects()) {
                    if (!select.hasSelectRawColumn(columnOrAlias)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

