/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.Queries;
import io.polaris.core.jdbc.sql.statement.BaseStatement;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.jdbc.sql.statement.ConfigurableColumnPredicate;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.ColumnSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@AnnotationProcessing
public class UpdateStatement<S extends UpdateStatement<S>>
extends BaseStatement<S>
implements TableAccessible {
    private final TableSegment<?> table;
    private final List<ColumnSegment<S, ?>> columns = new ArrayList();
    private AndSegment<S, ?> where;
    private final Function<String, String> columnDiscovery;
    private final List<Criteria> criteriaList = new ArrayList<Criteria>();

    @AnnotationProcessing
    public UpdateStatement(Class<?> entityClass) {
        this(entityClass, null);
    }

    @AnnotationProcessing
    public UpdateStatement(Class<?> entityClass, String alias) {
        this.table = TableSegment.fromEntity(entityClass, alias);
        this.columnDiscovery = this.columnDiscovery();
    }

    public static UpdateStatement<?> of(Class<?> entityClass, String alias) {
        return new UpdateStatement(entityClass, alias);
    }

    private Function<String, String> columnDiscovery() {
        return field -> {
            String col = null;
            try {
                if (this.table != null) {
                    col = this.table.getColumnExpression((String)field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return col;
        };
    }

    @AnnotationProcessing
    protected AndSegment<S, ?> buildWhere() {
        return new AndSegment(this.getThis(), this.table);
    }

    @Override
    public SqlNode toSqlNode() {
        ContainerNode sql = new ContainerNode();
        this.sqlUpdate(sql);
        this.sqlSet(sql);
        this.sqlWhere(sql);
        return sql;
    }

    private void sqlUpdate(ContainerNode sql) {
        if (this.table != null) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            sql.addNode(SqlNodes.UPDATE);
            sql.addNode(this.table.toSqlNode());
        }
    }

    private void sqlSet(ContainerNode sql) {
        if (!this.columns.isEmpty()) {
            boolean first = true;
            for (ColumnSegment<S, ?> column : this.columns) {
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.SET);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.COMMA);
                }
                String columnName = column.getColumnName();
                sql.addNode(new TextNode(columnName + " = "));
                sql.addNode(column.toValueSqlNode());
            }
        }
    }

    private void sqlWhere(ContainerNode sql) {
        SqlNode sqlNode;
        boolean first = true;
        if (this.where != null && !(sqlNode = this.where.toSqlNode()).isSkipped()) {
            if (!sql.isEmpty()) {
                sql.addNode(SqlNodes.LF);
            }
            first = false;
            sql.addNode(SqlNodes.WHERE);
            sql.addNode(sqlNode);
        }
        if (!this.criteriaList.isEmpty()) {
            for (Criteria criteria : this.criteriaList) {
                SqlNode sqlNode2 = Queries.parse(criteria, false, this.columnDiscovery);
                if (sqlNode2.isSkipped()) continue;
                if (!sql.isEmpty()) {
                    sql.addNode(SqlNodes.LF);
                }
                if (first) {
                    sql.addNode(SqlNodes.WHERE);
                    first = false;
                } else {
                    sql.addNode(SqlNodes.AND);
                }
                sql.addNode(SqlNodes.LEFT_PARENTHESIS);
                sql.addNode(sqlNode2);
                sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            }
        }
    }

    public S withEntity(Object entity) {
        return this.withEntity(entity, ColumnPredicate.DEFAULT);
    }

    public S withEntity(Object entity, Predicate<String> isIncludeEmptyColumns) {
        return this.withEntity(entity, ConfigurableColumnPredicate.of(isIncludeEmptyColumns));
    }

    public S withEntity(Object entity, String[] includeEmptyColumns) {
        return this.withEntity(entity, ConfigurableColumnPredicate.of(includeEmptyColumns));
    }

    public S withEntity(Object entity, Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        return this.withEntity(entity, ConfigurableColumnPredicate.of(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty));
    }

    public S withEntity(Object entity, String[] includeColumns, String[] excludeColumns, String[] includeEmptyColumns, boolean includeAllEmpty) {
        return this.withEntity(entity, ConfigurableColumnPredicate.of(includeColumns, excludeColumns, includeEmptyColumns, includeAllEmpty));
    }

    public S withEntity(Object entity, ColumnPredicate columnPredicate) {
        TableMeta tableMeta = this.table.getTableMeta();
        if (tableMeta != null) {
            BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                boolean include;
                String name = entry.getKey();
                ColumnMeta meta = entry.getValue();
                boolean updatable = meta.isUpdatable() || meta.isVersion() || meta.isUpdateTime();
                if (!updatable || meta.isPrimaryKey() || !columnPredicate.isIncludedColumn(name)) continue;
                Object val1 = entityMap.get(meta.getFieldName());
                Object val = BindingValues.getValueForUpdate(meta, val1);
                if (meta.isVersion()) {
                    val = Objs.isEmpty(val) ? 1L : ((Number)val).longValue() + 1L;
                }
                if (!(include = columnPredicate.isIncludedEmptyColumn(name) || Objs.isNotEmpty(val))) continue;
                this.column(name, val);
            }
        }
        return (S)((UpdateStatement)this.getThis());
    }

    private ColumnSegment<S, ?> buildColumnSegment() {
        return new ColumnSegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    public <C extends ColumnSegment<S, C>> C column(String field) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        column.column(field);
        this.columns.add(column);
        return (C)column;
    }

    @AnnotationProcessing
    public S column(String field, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.column(field)).value(value);
        this.columns.add(column);
        return (S)((UpdateStatement)this.getThis());
    }

    @AnnotationProcessing
    public S column(String field, Object value, BiPredicate<String, Object> predicate) {
        if (predicate.test(field, value)) {
            ColumnSegment<S, ?> column = this.buildColumnSegment();
            ((ColumnSegment)column.column(field)).value(value);
            this.columns.add(column);
        }
        return (S)((UpdateStatement)this.getThis());
    }

    @AnnotationProcessing
    public S column(String field, Object value, Supplier<Boolean> predicate) {
        if (Boolean.TRUE.equals(predicate.get())) {
            ColumnSegment<S, ?> column = this.buildColumnSegment();
            ((ColumnSegment)column.column(field)).value(value);
            this.columns.add(column);
        }
        return (S)((UpdateStatement)this.getThis());
    }

    public S columnRaw(String rawColumn, Object value) {
        ColumnSegment<S, ?> column = this.buildColumnSegment();
        ((ColumnSegment)column.rawColumn(rawColumn)).value(value);
        this.columns.add(column);
        return (S)((UpdateStatement)this.getThis());
    }

    public S columnRaw(String rawColumn, Object value, BiPredicate<String, Object> predicate) {
        if (predicate.test(rawColumn, value)) {
            ColumnSegment<S, ?> column = this.buildColumnSegment();
            ((ColumnSegment)column.rawColumn(rawColumn)).value(value);
            this.columns.add(column);
        }
        return (S)((UpdateStatement)this.getThis());
    }

    public S columnRaw(String rawColumn, Object value, Supplier<Boolean> predicate) {
        if (Boolean.TRUE.equals(predicate.get())) {
            ColumnSegment<S, ?> column = this.buildColumnSegment();
            ((ColumnSegment)column.rawColumn(rawColumn)).value(value);
            this.columns.add(column);
        }
        return (S)((UpdateStatement)this.getThis());
    }

    public S where(Criteria criteria) {
        if (criteria != null) {
            this.criteriaList.add(criteria);
        }
        return (S)((UpdateStatement)this.getThis());
    }

    @AnnotationProcessing
    public <W extends AndSegment<S, W>> W where() {
        this.where = Objs.defaultIfNull(this.where, this::buildWhere);
        return (W)this.where;
    }

    @AnnotationProcessing
    public TableSegment<?> getTable() {
        return this.table;
    }

    @Override
    public TableSegment<?> getTable(int tableIndex) {
        if (tableIndex < 0) {
            throw new IllegalArgumentException("tableIndex: " + tableIndex);
        }
        if (tableIndex == 0) {
            return this.table;
        }
        throw new IllegalArgumentException("no such table! tableIndex: " + tableIndex);
    }

    @Override
    public TableSegment<?> getTable(String tableAlias) {
        if (Objs.equals(this.table.getTableAlias(), tableAlias)) {
            return this.table;
        }
        throw new IllegalArgumentException("no such table! tableAlias: " + tableAlias);
    }
}

