/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.expression;

import io.polaris.core.collection.Iterables;
import io.polaris.core.function.FunctionWithArgs3;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.DynamicNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.statement.expression.BaseExpression;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

class LargeInOrNotExpression
extends BaseExpression {
    private final int limit;
    private final SqlNode logicalNode;
    private final SqlNode conjNode;

    protected LargeInOrNotExpression(int limit, SqlNode logicalNode, SqlNode conjNode) {
        this.limit = limit;
        this.logicalNode = logicalNode;
        this.conjNode = conjNode;
    }

    private List<List<Object>> split(Object varValue) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        if (varValue instanceof List && varValue instanceof RandomAccess) {
            int count;
            int size = ((List)((Object)varValue)).size();
            if (size <= this.limit) {
                list.add((List)((Object)varValue));
                return list;
            }
            for (int i = 0; i < size; i += count) {
                count = Integer.min(size - i, this.limit);
                ArrayList args = new ArrayList(count);
                for (int j = 0; j < count; ++j) {
                    Object o = ((List)((Object)varValue)).get(i + j);
                    args.add(o);
                }
                list.add(args);
            }
            return list;
        }
        if (varValue.getClass().isArray()) {
            int count = 0;
            ArrayList<Object> args = new ArrayList<Object>(count);
            list.add(args);
            int size = Array.getLength(varValue);
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(varValue, i);
                if (++count > this.limit) {
                    args = new ArrayList(count);
                    list.add(args);
                    count = 0;
                }
                args.add(o);
            }
            return list;
        }
        if (varValue instanceof Iterable) {
            varValue = ((Iterable)((Object)varValue)).iterator();
        }
        if (varValue instanceof Map) {
            Collection values = ((Map)((Object)varValue)).values();
            varValue = values.iterator();
        }
        if (varValue instanceof Iterator) {
            int count = 0;
            ArrayList<Object> args = new ArrayList<Object>(count);
            list.add(args);
            while (varValue.hasNext()) {
                Object o = varValue.next();
                if (++count > this.limit) {
                    args = new ArrayList(count);
                    list.add(args);
                    count = 0;
                }
                args.add(o);
            }
            return list;
        }
        list.add(Iterables.asList(new Object[]{varValue}));
        return list;
    }

    private ContainerNode bind(SqlNode baseSource, SqlNode[] extSources, Object varValue) {
        List<List<Object>> list = this.split(varValue);
        int size = list.size();
        if (size <= 1) {
            List args = size == 0 ? Collections.emptyList() : list.get(0);
            ContainerNode container = new ContainerNode();
            container.addNode(baseSource);
            container.addNode(this.logicalNode);
            container.addNodes(SqlNodes.LEFT_PARENTHESIS);
            DynamicNode varNode = new DynamicNode(this.nextVarName());
            varNode.bindVarValue(args);
            container.addNode(varNode);
            container.addNodes(SqlNodes.RIGHT_PARENTHESIS);
            return container;
        }
        ContainerNode container = new ContainerNode();
        container.addNodes(SqlNodes.LEFT_PARENTHESIS);
        for (int i = 0; i < list.size(); ++i) {
            List<Object> args = list.get(i);
            if (i > 0) {
                container.addNode(this.conjNode);
            }
            container.addNode(baseSource);
            container.addNode(this.logicalNode);
            container.addNodes(SqlNodes.LEFT_PARENTHESIS);
            DynamicNode varNode = new DynamicNode(this.nextVarName());
            varNode.bindVarValue(args);
            container.addNode(varNode);
            container.addNodes(SqlNodes.RIGHT_PARENTHESIS);
        }
        container.addNodes(SqlNodes.RIGHT_PARENTHESIS);
        return container;
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Object[], ContainerNode> buildArrayFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, bindings == null || ((Object[])bindings).length == 0 ? null : bindings[0]);
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Map<String, Object>, ContainerNode> buildMapFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, bindings == null || bindings.isEmpty() ? null : bindings.values().iterator().next());
    }
}

