/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.assertion.Assertions;
import io.polaris.core.consts.StdConsts;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.expression.AggregateFunction;
import io.polaris.core.jdbc.sql.statement.expression.Expression;
import io.polaris.core.jdbc.sql.statement.expression.Expressions;
import io.polaris.core.jdbc.sql.statement.expression.LargeInExpression;
import io.polaris.core.jdbc.sql.statement.expression.LargeNotInExpression;
import io.polaris.core.jdbc.sql.statement.expression.LogicalExpression;
import io.polaris.core.jdbc.sql.statement.expression.MultiColumnLogicalExpression;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.ExpressionSegment;
import io.polaris.core.jdbc.sql.statement.segment.OrSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableField;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.string.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@AnnotationProcessing
public class CriterionSegment<O extends Segment<O>, S extends CriterionSegment<O, S>>
extends BaseSegment<S>
implements SqlNodeBuilder,
TableAccessibleHolder {
    private final O owner;
    private SqlNode sql;
    private AndSegment<O, ?> and;
    private OrSegment<O, ?> or;
    private TableSegment<?> table;
    private String field;
    private ExpressionSegment<?> expression;
    private transient String _rawColumn;
    private TableAccessible tableAccessible;
    private SelectStatement<?> subSelect;
    private TextNode subSelectSymbol;
    private boolean subSelectWithColumn = false;

    public CriterionSegment(O owner, SqlNode sql) {
        this.owner = owner;
        this.sql = sql;
    }

    public CriterionSegment(O owner, AndSegment<O, ?> and) {
        this.owner = owner;
        this.and = and;
    }

    public CriterionSegment(O owner, OrSegment<O, ?> or) {
        this.owner = owner;
        this.or = or;
    }

    public CriterionSegment(O owner, String rawColumn) {
        this.owner = owner;
        this._rawColumn = rawColumn;
    }

    public <T extends TableSegment<?>> CriterionSegment(O owner, TableAccessible tableAccessible, T table, String field) {
        this.owner = owner;
        this.table = table;
        this.field = field;
        this.tableAccessible = tableAccessible;
    }

    @Override
    public TableAccessible getTableAccessible() {
        return this.tableAccessible;
    }

    @Override
    public SqlNode toSqlNode() {
        if (this.sql != null) {
            return this.sql;
        }
        if (this.or != null) {
            return this.or.toSqlNode();
        }
        if (this.and != null) {
            return this.and.toSqlNode();
        }
        if (this.subSelect != null && this.subSelectSymbol != null) {
            ContainerNode sql = new ContainerNode();
            if (this.subSelectWithColumn) {
                if (this.expression != null) {
                    sql.addNode(this.expression.toSqlNode(this.column()));
                } else {
                    sql.addNode(SqlNodes.text(this.column()));
                }
            }
            sql.addNode(this.subSelectSymbol);
            sql.addNode(SqlNodes.LEFT_PARENTHESIS);
            sql.addNode(SqlNodes.LF);
            sql.addNode(this.subSelect.toSqlNode());
            sql.addNode(SqlNodes.LF);
            sql.addNode(SqlNodes.RIGHT_PARENTHESIS);
            return sql;
        }
        if (this.expression != null) {
            return this.expression.toSqlNode(this.column());
        }
        return SqlNodes.EMPTY;
    }

    public O end() {
        return this.owner;
    }

    protected S rawColumn(String rawColumn) {
        this._rawColumn = rawColumn = SqlTextParsers.resolveTableRef(rawColumn, this.tableAccessible);
        return (S)((CriterionSegment)this.getThis());
    }

    private String column() {
        if (Strings.isNotBlank(this._rawColumn)) {
            return this._rawColumn;
        }
        if (this.table == null || Strings.isBlank(this.field)) {
            return "";
        }
        this._rawColumn = this.table.getColumnExpression(this.field);
        return this._rawColumn;
    }

    public O of(Function<String, SqlNode> function) {
        SqlNode sqlNode = function.apply(this.column());
        if (sqlNode != null) {
            this.sql = sqlNode;
        }
        return this.end();
    }

    public O of(Function<String, SqlNode> function, Predicate<String> predicate) {
        SqlNode sqlNode;
        if (predicate.test(this.column()) && (sqlNode = function.apply(this.column())) != null) {
            this.sql = sqlNode;
        }
        return this.end();
    }

    public S apply(String functionPattern, TableField[] extFields, Map<String, Object> bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField[] extFields, Object ... bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields, bindings);
    }

    public S apply(String functionPattern, TableField ... extFields) {
        return this.apply((Expression)Expressions.pattern(functionPattern), extFields);
    }

    public S apply(String functionPattern) {
        return this.apply((Expression)Expressions.pattern(functionPattern), StdConsts.EMPTY_ARRAY);
    }

    public S apply(String functionPattern, Object[] bindings) {
        return this.apply((Expression)Expressions.pattern(functionPattern), bindings);
    }

    public S apply(Expression function, TableField[] extFields, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((CriterionSegment)this.getThis());
    }

    public S apply(Expression function, TableField[] extFields, Object ... bindings) {
        this.expression = new ExpressionSegment(this.expression, this.tableAccessible, extFields, function, bindings);
        return (S)((CriterionSegment)this.getThis());
    }

    public S apply(Expression function, TableField ... extFields) {
        return this.apply(function, extFields, StdConsts.EMPTY_ARRAY);
    }

    public S apply(Expression function) {
        this.expression = new ExpressionSegment(this.expression, function, StdConsts.EMPTY_ARRAY);
        return (S)((CriterionSegment)this.getThis());
    }

    public S apply(Expression function, Object[] bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((CriterionSegment)this.getThis());
    }

    public S apply(Expression function, Map<String, Object> bindings) {
        this.expression = new ExpressionSegment(this.expression, function, bindings);
        return (S)((CriterionSegment)this.getThis());
    }

    public S apply(String functionPattern, int tableIndex, String field) {
        return this.apply(functionPattern, TableField.of((Integer)tableIndex, field));
    }

    public S apply(Expression function, int tableIndex, String field) {
        return this.apply(function, TableField.of((Integer)tableIndex, field));
    }

    public S apply(String functionPattern, String tableAlias, String field) {
        return this.apply(functionPattern, TableField.of(tableAlias, field));
    }

    public S apply(Expression function, String tableAlias, String field) {
        return this.apply(function, TableField.of(tableAlias, field));
    }

    public <T, R> S apply(String functionPattern, int tableIndex, GetterFunction<T, R> field) {
        return this.apply(functionPattern, TableField.of((Integer)tableIndex, field));
    }

    public <T, R> S apply(Expression function, int tableIndex, GetterFunction<T, R> field) {
        return this.apply(function, TableField.of((Integer)tableIndex, field));
    }

    public <T, R> S apply(String functionPattern, String tableAlias, GetterFunction<T, R> field) {
        return this.apply(functionPattern, TableField.of(tableAlias, field));
    }

    public <T, R> S apply(Expression function, String tableAlias, GetterFunction<T, R> field) {
        return this.apply(function, TableField.of(tableAlias, field));
    }

    public <I extends SelectStatement<?>> S exists(I subSelect) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.EXISTS;
        this.subSelectWithColumn = false;
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S exists(I subSelect, Consumer<I> append) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.EXISTS;
        this.subSelectWithColumn = false;
        append.accept(subSelect);
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notExists(I subSelect) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.NOT_EXISTS;
        this.subSelectWithColumn = false;
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notExists(I subSelect, Consumer<I> append) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.NOT_EXISTS;
        this.subSelectWithColumn = false;
        append.accept(subSelect);
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S in(I subSelect) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.IN;
        this.subSelectWithColumn = true;
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S in(I subSelect, Consumer<I> append) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.IN;
        this.subSelectWithColumn = true;
        append.accept(subSelect);
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notIn(I subSelect) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.NOT_IN;
        this.subSelectWithColumn = true;
        return (S)((CriterionSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notIn(I subSelect, Consumer<I> append) {
        subSelect.nested(this.tableAccessible);
        this.subSelect = subSelect;
        this.subSelectSymbol = SqlNodes.NOT_IN;
        this.subSelectWithColumn = true;
        append.accept(subSelect);
        return (S)((CriterionSegment)this.getThis());
    }

    public S count() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.COUNT.getExpression(), new Object[0]);
        return (S)((CriterionSegment)this.getThis());
    }

    public S sum() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.SUM.getExpression(), new Object[0]);
        return (S)((CriterionSegment)this.getThis());
    }

    public S max() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MAX.getExpression(), new Object[0]);
        return (S)((CriterionSegment)this.getThis());
    }

    public S min() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.MIN.getExpression(), new Object[0]);
        return (S)((CriterionSegment)this.getThis());
    }

    public S avg() {
        this.expression = new ExpressionSegment(this.expression, AggregateFunction.AVG.getExpression(), new Object[0]);
        return (S)((CriterionSegment)this.getThis());
    }

    public O isNull() {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.IS_NULL.getExpression(), new Object[0]);
        return this.end();
    }

    public O isNull(Supplier<Boolean> predicate) {
        if (Boolean.TRUE.equals(predicate.get())) {
            this.isNull();
        }
        return this.end();
    }

    public O isNull(boolean predicate) {
        if (predicate) {
            this.isNull();
        }
        return this.end();
    }

    public O notNull() {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_NULL.getExpression(), new Object[0]);
        return this.end();
    }

    public O notNull(Supplier<Boolean> predicate) {
        if (Boolean.TRUE.equals(predicate.get())) {
            this.notNull();
        }
        return this.end();
    }

    public O notNull(boolean predicate) {
        if (predicate) {
            this.notNull();
        }
        return this.end();
    }

    public O isTrue() {
        return this.eq(1);
    }

    public O isTrue(Predicate<Object> predicate) {
        return this.eq((Object)1, predicate);
    }

    public O isTrue(boolean predicate) {
        return this.eq((Object)1, predicate);
    }

    public O isFalse() {
        return this.eq(0);
    }

    public O isFalse(Predicate<Object> predicate) {
        return this.eq((Object)0, predicate);
    }

    public O isFalse(boolean predicate) {
        return this.eq((Object)0, predicate);
    }

    public O eq(Object value) {
        if (value == null) {
            return this.isNull();
        }
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.EQ.getExpression(), value);
        return this.end();
    }

    public O eq(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.eq(value);
        }
        return this.end();
    }

    public O eq(Object value, boolean predicate) {
        if (predicate) {
            this.eq(value);
        }
        return this.end();
    }

    public O ne(Object value) {
        if (value == null) {
            return this.notNull();
        }
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NE.getExpression(), value);
        return this.end();
    }

    public O ne(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.ne(value);
        }
        return this.end();
    }

    public O ne(Object value, boolean predicate) {
        if (predicate) {
            this.ne(value);
        }
        return this.end();
    }

    public O gt(Object value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.GT.getExpression(), value);
        return this.end();
    }

    public O gt(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.gt(value);
        }
        return this.end();
    }

    public O gt(Object value, boolean predicate) {
        if (predicate) {
            this.gt(value);
        }
        return this.end();
    }

    public O ge(Object value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.GE.getExpression(), value);
        return this.end();
    }

    public O ge(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.ge(value);
        }
        return this.end();
    }

    public O ge(Object value, boolean predicate) {
        if (predicate) {
            this.ge(value);
        }
        return this.end();
    }

    public O lt(Object value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.LT.getExpression(), value);
        return this.end();
    }

    public O lt(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.lt(value);
        }
        return this.end();
    }

    public O lt(Object value, boolean predicate) {
        if (predicate) {
            this.lt(value);
        }
        return this.end();
    }

    public O le(Object value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.LE.getExpression(), value);
        return this.end();
    }

    public O le(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            this.le(value);
        }
        return this.end();
    }

    public O le(Object value, boolean predicate) {
        if (predicate) {
            this.le(value);
        }
        return this.end();
    }

    public O between(Object value1, Object value2) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.BETWEEN.getExpression(), value1, value2);
        return this.end();
    }

    public O between(Object value1, Object value2, Predicate<Object[]> predicate) {
        if (predicate.test(new Object[]{value1, value2})) {
            this.between(value1, value2);
        }
        return this.end();
    }

    public O between(Object value1, Object value2, boolean predicate) {
        if (predicate) {
            this.between(value1, value2);
        }
        return this.end();
    }

    public O notBetween(Object value1, Object value2) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_BETWEEN.getExpression(), value1, value2);
        return this.end();
    }

    public O notBetween(Object value1, Object value2, Predicate<Object[]> predicate) {
        if (predicate.test(new Object[]{value1, value2})) {
            this.notBetween(value1, value2);
        }
        return this.end();
    }

    public O notBetween(Object value1, Object value2, boolean predicate) {
        if (predicate) {
            this.notBetween(value1, value2);
        }
        return this.end();
    }

    public <E> O in(Collection<E> value, int limitSize) {
        Assertions.assertTrue(limitSize > 0, "\u96c6\u5408\u5143\u7d20\u6570\u91cf\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e0");
        this.expression = value.size() < limitSize ? new ExpressionSegment(this.expression, LogicalExpression.IN.getExpression(), value) : new ExpressionSegment(this.expression, (Expression)LargeInExpression.of(limitSize), value);
        return this.end();
    }

    public <E> O in(Collection<E> value) {
        this.expression = value.size() < 1000 ? new ExpressionSegment(this.expression, LogicalExpression.IN.getExpression(), value) : new ExpressionSegment(this.expression, LogicalExpression.LARGE_IN.getExpression(), value);
        return this.end();
    }

    public <E> O in(Collection<E> value, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.in(value);
        }
        return this.end();
    }

    public <E> O in(Collection<E> value, boolean predicate) {
        if (predicate) {
            this.in(value);
        }
        return this.end();
    }

    public <E> O inLarge(Collection<E> value) {
        this.expression = new ExpressionSegment(this.expression, (Expression)LargeInExpression.DEFAULT, value);
        return this.end();
    }

    public <E> O inLarge(Collection<E> value, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.inLarge(value);
        }
        return this.end();
    }

    public <E> O inLarge(Collection<E> value, boolean predicate) {
        if (predicate) {
            this.inLarge(value);
        }
        return this.end();
    }

    public <E> O inLarge(Collection<E> value, int limit) {
        this.expression = new ExpressionSegment(this.expression, (Expression)LargeInExpression.of(limit), value);
        return this.end();
    }

    public <E> O inLarge(Collection<E> value, int limit, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.inLarge(value, limit);
        }
        return this.end();
    }

    public <E> O inLarge(Collection<E> value, int limit, boolean predicate) {
        if (predicate) {
            this.inLarge(value, limit);
        }
        return this.end();
    }

    public <E> O notIn(Collection<E> value) {
        this.expression = value.size() < 1000 ? new ExpressionSegment(this.expression, LogicalExpression.NOT_IN.getExpression(), value) : new ExpressionSegment(this.expression, LogicalExpression.LARGE_NOT_IN.getExpression(), value);
        return this.end();
    }

    public <E> O notIn(Collection<E> value, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.notIn(value);
        }
        return this.end();
    }

    public <E> O notIn(Collection<E> value, boolean predicate) {
        if (predicate) {
            this.notIn(value);
        }
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value) {
        this.expression = new ExpressionSegment(this.expression, (Expression)LargeNotInExpression.DEFAULT, value);
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.notInLarge(value);
        }
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value, boolean predicate) {
        if (predicate) {
            this.notInLarge(value);
        }
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value, int limit) {
        this.expression = new ExpressionSegment(this.expression, (Expression)LargeNotInExpression.of(limit), value);
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value, int limit, Predicate<Collection<E>> predicate) {
        if (predicate.test(value)) {
            this.notInLarge(value, limit);
        }
        return this.end();
    }

    public <E> O notInLarge(Collection<E> value, int limit, boolean predicate) {
        if (predicate) {
            this.notInLarge(value, limit);
        }
        return this.end();
    }

    public O like(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.LIKE.getExpression(), value);
        return this.end();
    }

    public O like(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.like(value);
        }
        return this.end();
    }

    public O like(String value, boolean predicate) {
        if (predicate) {
            this.like(value);
        }
        return this.end();
    }

    public O contains(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.CONTAINS.getExpression(), value);
        return this.end();
    }

    public O contains(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.contains(value);
        }
        return this.end();
    }

    public O contains(String value, boolean predicate) {
        if (predicate) {
            this.contains(value);
        }
        return this.end();
    }

    public O startsWith(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.STARTS_WITH.getExpression(), value);
        return this.end();
    }

    public O startsWith(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.startsWith(value);
        }
        return this.end();
    }

    public O startsWith(String value, boolean predicate) {
        if (predicate) {
            this.startsWith(value);
        }
        return this.end();
    }

    public O endsWith(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.ENDS_WITH.getExpression(), value);
        return this.end();
    }

    public O endsWith(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.endsWith(value);
        }
        return this.end();
    }

    public O endsWith(String value, boolean predicate) {
        if (predicate) {
            this.endsWith(value);
        }
        return this.end();
    }

    public O notLike(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_LIKE.getExpression(), value);
        return this.end();
    }

    public O notLike(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.notLike(value);
        }
        return this.end();
    }

    public O notLike(String value, boolean predicate) {
        if (predicate) {
            this.notLike(value);
        }
        return this.end();
    }

    public O notContains(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_CONTAINS.getExpression(), value);
        return this.end();
    }

    public O notContains(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.notContains(value);
        }
        return this.end();
    }

    public O notContains(String value, boolean predicate) {
        if (predicate) {
            this.notContains(value);
        }
        return this.end();
    }

    public O notStartsWith(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_STARTS_WITH.getExpression(), value);
        return this.end();
    }

    public O notStartsWith(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.notStartsWith(value);
        }
        return this.end();
    }

    public O notStartsWith(String value, boolean predicate) {
        if (predicate) {
            this.notStartsWith(value);
        }
        return this.end();
    }

    public O notEndsWith(String value) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_ENDS_WITH.getExpression(), value);
        return this.end();
    }

    public O notEndsWith(String value, Predicate<String> predicate) {
        if (predicate.test(value)) {
            this.notEndsWith(value);
        }
        return this.end();
    }

    public O notEndsWith(String value, boolean predicate) {
        if (predicate) {
            this.notEndsWith(value);
        }
        return this.end();
    }

    public O exists(String rawSql) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.EXISTS.getExpression(), rawSql);
        return this.end();
    }

    public O exists(String rawSql, Predicate<String> predicate) {
        if (predicate.test(rawSql)) {
            this.exists(rawSql);
        }
        return this.end();
    }

    public O exists(String rawSql, boolean predicate) {
        if (predicate) {
            this.exists(rawSql);
        }
        return this.end();
    }

    public O notExists(String rawSql) {
        this.expression = new ExpressionSegment(this.expression, LogicalExpression.NOT_EXISTS.getExpression(), rawSql);
        return this.end();
    }

    public O notExists(String rawSql, Predicate<String> predicate) {
        if (predicate.test(rawSql)) {
            this.notExists(rawSql);
        }
        return this.end();
    }

    public O notExists(String rawSql, boolean predicate) {
        if (predicate) {
            this.notExists(rawSql);
        }
        return this.end();
    }

    public O eq(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.EQ.getExpression(), tableField);
        return this.end();
    }

    public O eq(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.eq(tableField);
        }
        return this.end();
    }

    public O eq(TableField tableField, boolean predicate) {
        if (predicate) {
            this.eq(tableField);
        }
        return this.end();
    }

    public O ne(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.NE.getExpression(), tableField);
        return this.end();
    }

    public O ne(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.ne(tableField);
        }
        return this.end();
    }

    public O ne(TableField tableField, boolean predicate) {
        if (predicate) {
            this.ne(tableField);
        }
        return this.end();
    }

    public O gt(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.GT.getExpression(), tableField);
        return this.end();
    }

    public O gt(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.gt(tableField);
        }
        return this.end();
    }

    public O gt(TableField tableField, boolean predicate) {
        if (predicate) {
            this.gt(tableField);
        }
        return this.end();
    }

    public O ge(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.GE.getExpression(), tableField);
        return this.end();
    }

    public O ge(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.ge(tableField);
        }
        return this.end();
    }

    public O ge(TableField tableField, boolean predicate) {
        if (predicate) {
            this.ge(tableField);
        }
        return this.end();
    }

    public O lt(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.LT.getExpression(), tableField);
        return this.end();
    }

    public O lt(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.lt(tableField);
        }
        return this.end();
    }

    public O lt(TableField tableField, boolean predicate) {
        if (predicate) {
            this.lt(tableField);
        }
        return this.end();
    }

    public O le(TableField tableField) {
        this.apply(MultiColumnLogicalExpression.LE.getExpression(), tableField);
        return this.end();
    }

    public O le(TableField tableField, Predicate<TableField> predicate) {
        if (predicate.test(tableField)) {
            this.le(tableField);
        }
        return this.end();
    }

    public O le(TableField tableField, boolean predicate) {
        if (predicate) {
            this.le(tableField);
        }
        return this.end();
    }

    public O between(TableField tableField1, TableField tableField2) {
        this.apply(MultiColumnLogicalExpression.BETWEEN.getExpression(), tableField1, tableField2);
        return this.end();
    }

    public O notBetween(TableField tableField1, TableField tableField2) {
        this.apply(MultiColumnLogicalExpression.NOT_BETWEEN.getExpression(), tableField1, tableField2);
        return this.end();
    }
}

