/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.segment.SelectSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TableEntitySegment<S extends TableEntitySegment<S>>
extends TableSegment<S> {
    private final TableMeta tableMeta;
    private final Class<?> entityClass;
    private final String alias;

    public TableEntitySegment(Class<?> entityClass, String alias) {
        this.entityClass = entityClass;
        this.tableMeta = entityClass == null ? null : TableMetaKit.instance().get(entityClass);
        this.alias = Strings.coalesce(alias, this.tableMeta.getAlias());
    }

    @Override
    public SqlNode toSqlNode(boolean withAlias) {
        if (!withAlias) {
            return new TextNode(this.tableMeta.getTable());
        }
        String tableAlias = this.getTableAlias();
        if (Strings.isBlank(tableAlias)) {
            return new TextNode(this.tableMeta.getTable());
        }
        return new TextNode(this.tableMeta.getTable() + " " + tableAlias);
    }

    @Override
    public SqlNode toSqlNode() {
        return this.toSqlNode(true);
    }

    @Override
    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    @Override
    public String getTableAlias() {
        return this.alias;
    }

    @Override
    public String getAllColumnExpression(boolean quotaAlias) {
        return this.getAllColumnExpression(true, quotaAlias);
    }

    @Override
    public String getAllColumnExpression(boolean withTableAlias, boolean quotaAlias) {
        return this.getAllColumnExpression(withTableAlias, false, quotaAlias, "", "");
    }

    @Override
    public String getAllColumnExpression(boolean aliasWithField, boolean quotaAlias, String aliasPrefix, String aliasSuffix) {
        return this.getAllColumnExpression(true, aliasWithField, quotaAlias, "", "");
    }

    @Override
    public String getAllColumnExpression(boolean withTableAlias, boolean aliasWithField, boolean quotaAlias, String aliasPrefix, String aliasSuffix) {
        String field;
        String alias = this.getTableAlias();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ColumnMeta> entry : this.tableMeta.getColumns().entrySet()) {
            field = entry.getKey();
            ColumnMeta columnMeta = entry.getValue();
            String columnName = columnMeta.getColumnName();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (Strings.isNotBlank(alias) && withTableAlias) {
                sb.append(alias).append(".");
            }
            sb.append(columnName);
            if (!aliasWithField) continue;
            String fieldAlias = SelectSegment.toAlias(field, aliasPrefix, aliasSuffix);
            if (quotaAlias && !fieldAlias.startsWith("\"")) {
                sb.append(" ").append("\"").append(fieldAlias).append("\"");
                continue;
            }
            sb.append(" ").append(fieldAlias);
        }
        for (Map.Entry<String, Cloneable> entry : this.tableMeta.getExpressions().entrySet()) {
            field = entry.getKey();
            ExpressionMeta expressionMeta = (ExpressionMeta)entry.getValue();
            if (!expressionMeta.isSelectable()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (Strings.isBlank(expressionMeta.getTableAliasPlaceholder())) {
                sb.append(expressionMeta.getExpression());
            } else if (Strings.isNotBlank(alias) && withTableAlias) {
                sb.append(expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), alias + "."));
            } else {
                sb.append(expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), ""));
            }
            if (!aliasWithField) continue;
            String fieldAlias = SelectSegment.toAlias(field, aliasPrefix, aliasSuffix);
            if (quotaAlias && !fieldAlias.startsWith("\"")) {
                sb.append(" ").append("\"").append(fieldAlias).append("\"");
                continue;
            }
            sb.append(" ").append(fieldAlias);
        }
        return sb.toString();
    }

    @Override
    public String getColumnExpression(String field) {
        return this.getColumnExpression(field, true);
    }

    @Override
    public String getColumnExpression(String field, boolean withTableAlias) {
        String alias = this.getTableAlias();
        ColumnMeta columnMeta = this.tableMeta.getColumns().get(field);
        ExpressionMeta expressionMeta = this.tableMeta.getExpressions().get(field);
        if (columnMeta == null && expressionMeta == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8868\u5bf9\u5e94\u7684\u5217\u4fe1\u606f\uff1a" + field);
        }
        if (columnMeta != null) {
            if (Strings.isNotBlank(alias) && withTableAlias) {
                return alias + "." + columnMeta.getColumnName();
            }
            return columnMeta.getColumnName();
        }
        if (Strings.isBlank(expressionMeta.getTableAliasPlaceholder())) {
            return expressionMeta.getExpression();
        }
        if (Strings.isNotBlank(alias) && withTableAlias) {
            return expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), alias + ".");
        }
        return expressionMeta.getExpression().replace(expressionMeta.getTableAliasPlaceholder(), "");
    }

    @Override
    public List<String> getAllColumnNames() {
        Map<String, ColumnMeta> columns = this.tableMeta.getColumns();
        return columns.values().stream().map(ColumnMeta::getColumnName).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllFieldNames() {
        Map<String, ColumnMeta> columns = this.tableMeta.getColumns();
        return new ArrayList<String>(columns.keySet());
    }

    @Override
    public String getColumnName(String field) {
        ColumnMeta columnMeta = this.tableMeta.getColumns().get(field);
        if (columnMeta == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8868\u5bf9\u5e94\u7684\u5217\u4fe1\u606f\uff1a" + field);
        }
        return columnMeta.getColumnName();
    }
}

