/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.collection.Iterables;
import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.jdbc.sql.statement.ConfigurableColumnPredicate;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.CriterionSegment;
import io.polaris.core.jdbc.sql.statement.segment.OrSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@AnnotationProcessing
public class WhereSegment<O extends Segment<O>, S extends WhereSegment<O, S>>
extends BaseSegment<S>
implements SqlNodeBuilder,
TableAccessibleHolder {
    private final O owner;
    private final TableSegment<?> table;
    private final List<CriterionSegment<S, ?>> criteria = new ArrayList();
    private final TextNode delimiter;
    private final TableAccessible tableAccessible;

    public <T extends TableSegment<?>> WhereSegment(O owner, T table, TextNode delimiter) {
        this.owner = owner;
        this.table = table;
        this.delimiter = delimiter;
        this.tableAccessible = this.fetchTableAccessible();
    }

    private TableAccessible fetchTableAccessible() {
        if (this.owner instanceof WhereSegment) {
            return ((WhereSegment)this.owner).fetchTableAccessible();
        }
        if (this.owner instanceof TableAccessible) {
            return (TableAccessible)this.owner;
        }
        if (this.owner instanceof TableAccessibleHolder) {
            return ((TableAccessibleHolder)this.owner).getTableAccessible();
        }
        return null;
    }

    @Override
    public TableAccessible getTableAccessible() {
        return this.tableAccessible;
    }

    public O end() {
        return this.owner;
    }

    @AnnotationProcessing
    protected void addCriterion(CriterionSegment<S, ?> criterion) {
        this.criteria.add(criterion);
    }

    @AnnotationProcessing
    public AndSegment<S, ?> and() {
        AndSegment x = new AndSegment(this.getThis(), this.table);
        this.addCriterion(new CriterionSegment(this.getThis(), x));
        return x;
    }

    @AnnotationProcessing
    public OrSegment<S, ?> or() {
        OrSegment x = new OrSegment(this.getThis(), this.table);
        this.addCriterion(new CriterionSegment(this.getThis(), x));
        return x;
    }

    @Override
    public SqlNode toSqlNode() {
        if (this.criteria.isEmpty()) {
            return SqlNodes.EMPTY;
        }
        ContainerNode containerNode = new ContainerNode();
        boolean notEmpty = false;
        for (CriterionSegment<S, ?> criterion : this.criteria) {
            SqlNode n = criterion.toSqlNode();
            if (n.isSkipped()) continue;
            if (notEmpty) {
                containerNode.addNode(this.delimiter);
            }
            containerNode.addNode(SqlNodes.LEFT_PARENTHESIS);
            containerNode.addNode(n);
            containerNode.addNode(SqlNodes.RIGHT_PARENTHESIS);
            if (notEmpty) continue;
            notEmpty = true;
        }
        return containerNode;
    }

    public S byEntity(Object entity) {
        return this.byEntity(entity, ColumnPredicate.DEFAULT);
    }

    public S byEntity(Object entity, Predicate<String> isIncludeEmptyColumns) {
        return this.byEntity(entity, ConfigurableColumnPredicate.of(isIncludeEmptyColumns));
    }

    public S byEntity(Object entity, Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        return this.byEntity(entity, ConfigurableColumnPredicate.of(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty));
    }

    public S byEntity(Object entity, ColumnPredicate columnPredicate) {
        TableMeta tableMeta = this.table.getTableMeta();
        if (tableMeta != null) {
            Object val;
            Cloneable meta;
            String name;
            BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                name = entry.getKey();
                if (!columnPredicate.isIncludedColumn(name)) continue;
                meta = entry.getValue();
                val = entityMap.get(name);
                this.addWhereSqlByColumnValue(((ColumnMeta)meta).getFieldName(), ((ColumnMeta)meta).getFieldType(), val, columnPredicate);
            }
            for (Map.Entry<String, Cloneable> entry : tableMeta.getExpressions().entrySet()) {
                name = entry.getKey();
                if (!columnPredicate.isIncludedColumn(name)) continue;
                meta = (ExpressionMeta)entry.getValue();
                val = entityMap.get(name);
                this.addWhereSqlByColumnValue(((ExpressionMeta)meta).getFieldName(), ((ExpressionMeta)meta).getFieldType(), val, columnPredicate);
            }
        }
        return (S)((WhereSegment)this.getThis());
    }

    private void addWhereSqlByColumnValue(String fieldName, Class<?> fieldType, Object val, ColumnPredicate columnPredicate) {
        if (Objs.isNotEmpty(val)) {
            ArrayList<Object> list;
            if (Date.class.isAssignableFrom(fieldType)) {
                Date[] range = BindingValues.getDateRangeOrNull(val);
                if (range != null) {
                    if (range[0] != null) {
                        this.column(fieldName).ge(range[0]);
                    }
                    if (range[1] != null) {
                        this.column(fieldName).le(range[1]);
                    }
                    return;
                }
            } else if (String.class.isAssignableFrom(fieldType) && val instanceof String && (((String)val).startsWith("%") || ((String)val).endsWith("%"))) {
                this.column(fieldName).like((String)val);
                return;
            }
            if (val instanceof Collection) {
                list = new ArrayList((Collection)val);
                this.column(fieldName).in(this.convertListElements(list, o -> Converters.convertQuietly(fieldType, o)));
            } else if (val instanceof Iterable) {
                list = Iterables.asCollection(ArrayList::new, (Iterable)val);
                this.column(fieldName).in(this.convertListElements(list, o -> Converters.convertQuietly(fieldType, o)));
            } else if (val instanceof Iterator) {
                list = Iterables.asCollection(ArrayList::new, (Iterator)val);
                this.column(fieldName).in(this.convertListElements(list, o -> Converters.convertQuietly(fieldType, o)));
            } else if (val.getClass().isArray()) {
                list = ObjectArrays.toList(val);
                this.column(fieldName).in(this.convertListElements(list, o -> Converters.convertQuietly(fieldType, o)));
            } else {
                this.column(fieldName).eq(Converters.convertQuietly(fieldType, val));
            }
        } else if (columnPredicate.isIncludedEmptyColumn(fieldName)) {
            this.column(fieldName).isNull();
        }
    }

    private List<Object> convertListElements(List<Object> list, Function<Object, Object> converter) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object o = list.get(i);
            list.set(i, converter.apply(o));
        }
        return list;
    }

    public S byEntityId(Object entity) {
        TableMeta tableMeta = this.table.getTableMeta();
        if (tableMeta != null) {
            BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                String name = entry.getKey();
                ColumnMeta meta = entry.getValue();
                if (!meta.isPrimaryKey()) continue;
                Object val = entityMap.get(name);
                if (val == null) {
                    this.column(name).isNull();
                    continue;
                }
                this.column(name).eq(val);
            }
        }
        return (S)((WhereSegment)this.getThis());
    }

    public S byEntityIdAndVersion(Object entity) {
        TableMeta tableMeta = this.table.getTableMeta();
        if (tableMeta != null) {
            BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
            for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
                String name = entry.getKey();
                ColumnMeta meta = entry.getValue();
                if (!meta.isPrimaryKey() && !meta.isVersion()) continue;
                Object val = entityMap.get(name);
                if (val == null) {
                    this.column(name).isNull();
                    continue;
                }
                this.column(name).eq(val);
            }
        }
        return (S)((WhereSegment)this.getThis());
    }

    public S raw(String raw) {
        raw = SqlTextParsers.resolveTableRef(raw, this.tableAccessible);
        this.criteria.add(new CriterionSegment(this.getThis(), new TextNode(raw)));
        return (S)((WhereSegment)this.getThis());
    }

    public S sql(SqlNode sql) {
        this.criteria.add(new CriterionSegment(this.getThis(), sql));
        return (S)((WhereSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S exists(I subSelect) {
        this.column("").exists(subSelect);
        return (S)((WhereSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S exists(I subSelect, Consumer<I> append) {
        this.column("").exists(subSelect, append);
        return (S)((WhereSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notExists(I subSelect) {
        this.column("").notExists(subSelect);
        return (S)((WhereSegment)this.getThis());
    }

    public <I extends SelectStatement<?>> S notExists(I subSelect, Consumer<I> append) {
        this.column("").notExists(subSelect, append);
        return (S)((WhereSegment)this.getThis());
    }

    public CriterionSegment<S, ?> rawColumn(String rawColumn) {
        rawColumn = SqlTextParsers.resolveTableRef(rawColumn, this.tableAccessible);
        CriterionSegment c = new CriterionSegment(this.getThis(), rawColumn);
        this.criteria.add(c);
        return c;
    }

    public <T, R> CriterionSegment<S, ?> column(GetterFunction<T, R> getter) {
        return this.column(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public CriterionSegment<S, ?> column(String field) {
        CriterionSegment c = new CriterionSegment(this.getThis(), this.tableAccessible, this.table, field);
        this.criteria.add(c);
        return c;
    }

    @AnnotationProcessing
    public TableSegment<?> getTable() {
        return this.table;
    }
}

