/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang;

import io.polaris.core.asm.internal.AsmTypes;
import io.polaris.core.compiler.MemoryClassLoader;
import io.polaris.core.compiler.MemoryCompiler;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.dependency.com.squareup.javapoet.ArrayTypeName;
import io.polaris.dependency.com.squareup.javapoet.ClassName;
import io.polaris.dependency.com.squareup.javapoet.JavaFile;
import io.polaris.dependency.com.squareup.javapoet.ParameterizedTypeName;
import io.polaris.dependency.com.squareup.javapoet.TypeName;
import io.polaris.dependency.com.squareup.javapoet.TypeSpec;
import io.polaris.dependency.com.squareup.javapoet.WildcardTypeName;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.element.Modifier;

public class TypeRefs {
    private static final ILogger log = ILoggers.of(TypeRefs.class);
    private static final AtomicLong seq = new AtomicLong(0L);
    private static final Map<String, Type> refs = new ConcurrentHashMap<String, Type>();

    public static Type getType(String typeStr) throws ClassNotFoundException {
        TypeName typeName = TypeRefs.parse(typeStr);
        return TypeRefs.getType(typeName);
    }

    public static TypeName parse(String typeStr) throws ClassNotFoundException {
        int i = typeStr.indexOf("<");
        if (i < 0) {
            return TypeRefs.toSimpleTypeName(typeStr);
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        StringBuilder sb = new StringBuilder();
        char[] cs = typeStr.trim().toCharArray();
        for (int j = 0; j < cs.length; ++j) {
            class SuperWildcard {
                SuperWildcard() {
                }
            }
            class SubWildcard {
                SubWildcard() {
                }
            }
            class Parameterized {
                ClassName raw;
                List<TypeName> args = new ArrayList<TypeName>();

                public Parameterized(ClassName raw) {
                    this.raw = raw;
                }
            }
            Parameterized parameterized;
            TypeName componentTypeName;
            char c = cs[j];
            if (Character.isWhitespace(c)) continue;
            if (c == '?') {
                int k;
                for (k = j + 1; k < cs.length && Character.isWhitespace(cs[k]); ++k) {
                }
                if (cs.length >= k + 7) {
                    if (!Arrays.equals("extends".toCharArray(), Arrays.copyOfRange(cs, k, k + 7))) continue;
                    stack.offerLast(new SubWildcard());
                    j = k + 6;
                    continue;
                }
                if (cs.length >= k + 5) {
                    if (!Arrays.equals("super".toCharArray(), Arrays.copyOfRange(cs, k, k + 5))) continue;
                    stack.offerLast(new SuperWildcard());
                    j = k + 4;
                    continue;
                }
                Object last = stack.peekLast();
                if (last instanceof Parameterized) {
                    ((Parameterized)last).args.add(WildcardTypeName.subtypeOf(TypeName.OBJECT));
                    continue;
                }
                throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
            }
            if (c == '<') {
                stack.offerLast(new Parameterized(ClassName.get(TypeRefs.getClassForName(sb.toString()))));
                sb.setLength(0);
                continue;
            }
            if (c == ',') {
                Object last = stack.peekLast();
                componentTypeName = null;
                if (sb.length() > 0) {
                    componentTypeName = TypeRefs.toSimpleTypeName(sb.toString());
                    sb.setLength(0);
                }
                if (last instanceof SubWildcard) {
                    componentTypeName = WildcardTypeName.subtypeOf(componentTypeName == null ? TypeName.OBJECT : componentTypeName);
                    stack.pollLast();
                    last = stack.peekLast();
                } else if (last instanceof SuperWildcard) {
                    componentTypeName = WildcardTypeName.supertypeOf(componentTypeName == null ? TypeName.OBJECT : componentTypeName);
                    stack.pollLast();
                    last = stack.peekLast();
                }
                if (last instanceof Parameterized) {
                    parameterized = (Parameterized)last;
                    if (componentTypeName == null) continue;
                    parameterized.args.add(componentTypeName);
                    continue;
                }
                throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
            }
            if (c == '>') {
                Object last = stack.pollLast();
                componentTypeName = null;
                if (sb.length() > 0) {
                    componentTypeName = TypeRefs.toSimpleTypeName(sb.toString());
                    sb.setLength(0);
                }
                if (last instanceof SubWildcard) {
                    componentTypeName = WildcardTypeName.subtypeOf(componentTypeName == null ? TypeName.OBJECT : componentTypeName);
                    last = stack.pollLast();
                } else if (last instanceof SuperWildcard) {
                    componentTypeName = WildcardTypeName.supertypeOf(componentTypeName == null ? TypeName.OBJECT : componentTypeName);
                    last = stack.pollLast();
                }
                if (last instanceof Parameterized) {
                    parameterized = (Parameterized)last;
                    if (componentTypeName != null) {
                        parameterized.args.add(componentTypeName);
                    }
                    TypeName typeName = ParameterizedTypeName.get(parameterized.raw, parameterized.args.toArray(new TypeName[0]));
                    if (stack.isEmpty()) {
                        if (j < cs.length - 1) {
                            throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
                        }
                        return typeName;
                    }
                    Object last1 = stack.peekLast();
                    if (last1 instanceof SubWildcard) {
                        typeName = WildcardTypeName.subtypeOf(typeName);
                        stack.pollLast();
                    } else if (last1 instanceof SuperWildcard) {
                        typeName = WildcardTypeName.supertypeOf(typeName);
                        stack.pollLast();
                    }
                    Object last2 = stack.peekLast();
                    if (last2 instanceof Parameterized) {
                        ((Parameterized)last2).args.add(typeName);
                        continue;
                    }
                    throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
                }
                throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
            }
            sb.append(c);
        }
        throw new IllegalArgumentException("\u683c\u5f0f\u6709\u8bef\uff1a" + typeStr);
    }

    private static TypeName toSimpleTypeName(String typeStr) throws ClassNotFoundException {
        TypeName typeName;
        int i;
        char[] cs = typeStr.toCharArray();
        boolean hasSquareBracket = false;
        int bracketCount = 0;
        for (i = cs.length - 1; i >= 0; --i) {
            char c = cs[i];
            if (Character.isWhitespace(c)) continue;
            if (c == ']') {
                hasSquareBracket = true;
                continue;
            }
            if (c != '[') break;
            if (!hasSquareBracket) {
                throw new ClassNotFoundException(typeStr);
            }
            hasSquareBracket = false;
            ++bracketCount;
        }
        if (hasSquareBracket) {
            throw new ClassNotFoundException(typeStr);
        }
        if (bracketCount == 0) {
            typeName = ClassName.get(TypeRefs.getClassForName(typeStr));
        } else {
            String componentTypeStr = new String(cs, 0, i + 1);
            typeName = ClassName.get(TypeRefs.getClassForName(componentTypeStr));
            for (int j = 0; j < bracketCount; ++j) {
                typeName = ArrayTypeName.of(typeName);
            }
        }
        return typeName;
    }

    private static Class<?> getClassForName(String typeStr) throws ClassNotFoundException {
        try {
            return Class.forName(typeStr);
        }
        catch (ClassNotFoundException e) {
            if (!typeStr.contains(".")) {
                return Class.forName("java.lang." + typeStr);
            }
            throw e;
        }
    }

    public static Type getType(TypeName typeName) {
        return refs.computeIfAbsent(typeName.toString(), s -> TypeRefs.createType(typeName));
    }

    static Type createType(TypeName typeName) {
        String packageName = TypeRef.class.getPackage().getName();
        String simpleName = TypeRef.class.getSimpleName() + "$$" + seq.incrementAndGet();
        TypeRef<?> ref = null;
        try {
            ref = TypeRefs.createTypeRefByAsm(typeName, packageName, simpleName);
        }
        catch (Exception e) {
            log.error("", e);
            try {
                ref = TypeRefs.createTypeRefByJdk(typeName, packageName, simpleName);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
                throw e;
            }
        }
        return ref.getType();
    }

    static TypeRef<?> createTypeRefByJdk(TypeName typeName, String packageName, String simpleName) {
        try {
            JavaFile javaFile = JavaFile.builder(packageName, TypeSpec.classBuilder(simpleName).addModifiers(Modifier.PUBLIC).superclass(ParameterizedTypeName.get(ClassName.get(TypeRef.class), typeName)).build()).build();
            StringWriter sw = new StringWriter();
            javaFile.writeTo(sw);
            MemoryCompiler memoryCompiler = MemoryCompiler.getInstance();
            Class<?> c = memoryCompiler.compile(packageName + "." + simpleName, sw.toString());
            TypeRef ref = (TypeRef)c.newInstance();
            return ref;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    static TypeRef<?> createTypeRefByAsm(TypeName typeName, String packageName, String simpleName) {
        try {
            String typeRefClassName = TypeRef.class.getName().replace('.', '/');
            ClassWriter cw = new ClassWriter(2);
            cw.visit(52, 33, packageName.replace('.', '/') + "/" + simpleName, "L" + typeRefClassName + "<" + AsmTypes.toTypeSignature(typeName) + ">;", typeRefClassName, null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, typeRefClassName, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            cw.visitEnd();
            byte[] byteArray = cw.toByteArray();
            MemoryClassLoader loader = MemoryClassLoader.getInstance();
            loader.add(packageName + "." + simpleName, byteArray);
            Class<?> c = loader.loadClass(packageName + "." + simpleName);
            return (TypeRef)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

