/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.annotation.Annotations;
import io.polaris.core.lang.annotation.MatchedMergedAnnotation;
import io.polaris.core.lang.annotation.MergedAnnotations;
import io.polaris.core.reflect.Reflects;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nonnull;

public class MergedAnnotation {
    private final int distance;
    private final AnnotatedElement annotatedElement;
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationType;
    private final MergedAnnotation aliasSource;
    private final Map<String, Method> aliasMethods;
    private final Class<? extends Annotation> repeatedAnnotationType;
    private final MergedAnnotation[] repeatedAnnotations;
    private SortedMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations;

    static MergedAnnotation of(int distance, @Nonnull AnnotatedElement annotatedElement, @Nonnull Annotation annotation) {
        MergedAnnotation mergedAnnotation = new MergedAnnotation(distance, annotatedElement, annotation.annotationType(), annotation, null, null);
        return mergedAnnotation;
    }

    static MergedAnnotation of(int distance, AnnotatedElement annotatedElement, @Nonnull Class<? extends Annotation> annotationType, @Nonnull MergedAnnotation aliasSource, @Nonnull Map<String, Method> aliasMethods) {
        MergedAnnotation mergedAnnotation = new MergedAnnotation(distance, annotatedElement, annotationType, null, aliasSource, aliasMethods);
        return mergedAnnotation;
    }

    private MergedAnnotation(int distance, AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, Annotation annotation, MergedAnnotation aliasSource, Map<String, Method> aliasMethods) {
        this.distance = distance;
        this.annotatedElement = annotatedElement;
        this.annotationType = annotationType;
        this.aliasSource = aliasSource;
        this.aliasMethods = aliasMethods;
        if (aliasSource != null && aliasMethods != null) {
            this.repeatedAnnotationType = null;
            this.repeatedAnnotations = null;
            this.annotation = null;
        } else {
            this.annotation = annotation;
            this.repeatedAnnotationType = Annotations.getRepeatedAnnotationType(annotationType);
            if (this.repeatedAnnotationType != null) {
                Annotation[] annotations = (Annotation[])Reflects.invokeQuietly(annotation, annotationType.getDeclaredMethods()[0], new Object[0]);
                MergedAnnotation[] repeatedAnnotations = new MergedAnnotation[annotations.length];
                for (int i = 0; i < annotations.length; ++i) {
                    Annotation repeatedAnnotation = annotations[i];
                    repeatedAnnotations[i] = MergedAnnotation.of(this.distance + 1, annotatedElement, repeatedAnnotation);
                }
                this.repeatedAnnotations = repeatedAnnotations;
            } else {
                this.repeatedAnnotations = null;
            }
        }
    }

    public <A extends Annotation> MatchedMergedAnnotation<A> getMatchedAnnotation(Class<A> annotationType) {
        MatchedMergedAnnotation<A> matchedAnnotation;
        if (!this.isAlias() && this.annotationType == annotationType) {
            return MatchedMergedAnnotation.of(annotationType, this);
        }
        MergedAnnotation matchedOne = null;
        ArrayList<MergedAnnotation> aliasList = new ArrayList<MergedAnnotation>();
        SortedMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations = this.getHierarchyAnnotations();
        block0: for (Map.Entry<Integer, Set<MergedAnnotation>> entry : hierarchyAnnotations.entrySet()) {
            Set<MergedAnnotation> set = entry.getValue();
            for (MergedAnnotation mergedAnnotation : set) {
                if (mergedAnnotation.annotationType != annotationType) continue;
                if (mergedAnnotation.isAlias()) {
                    aliasList.add(mergedAnnotation);
                    continue;
                }
                matchedOne = mergedAnnotation;
                break block0;
            }
        }
        if (matchedOne == null && aliasList.isEmpty() && this.isRepeatable() && this.repeatedAnnotations.length > 0 && (matchedAnnotation = this.repeatedAnnotations[0].getMatchedAnnotation(annotationType)) != null) {
            matchedOne = matchedAnnotation.getMatched();
            aliasList.addAll(matchedAnnotation.getAliases());
        }
        if (matchedOne == null && aliasList.isEmpty()) {
            return null;
        }
        return MatchedMergedAnnotation.of(annotationType, matchedOne, aliasList);
    }

    public <A extends Annotation> Set<MatchedMergedAnnotation<A>> getMatchedRepeatableAnnotation(Class<A> annotationType) {
        LinkedHashSet<MatchedMergedAnnotation<A>> matchedSet = new LinkedHashSet<MatchedMergedAnnotation<A>>();
        if (this.isRepeatable()) {
            for (MergedAnnotation repeatedAnnotation : this.repeatedAnnotations) {
                MatchedMergedAnnotation<A> matchedAnnotation = repeatedAnnotation.getMatchedAnnotation(annotationType);
                if (matchedAnnotation == null) continue;
                matchedSet.add(matchedAnnotation);
            }
        }
        if (!this.isAlias() && this.annotationType == annotationType) {
            matchedSet.add(MatchedMergedAnnotation.of(annotationType, this));
        }
        SortedMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations = this.getHierarchyAnnotations();
        for (Map.Entry<Integer, Set<MergedAnnotation>> entry : hierarchyAnnotations.entrySet()) {
            Set<MergedAnnotation> set = entry.getValue();
            for (MergedAnnotation mergedAnnotation : set) {
                if (mergedAnnotation.isRepeatable()) {
                    Set<MatchedMergedAnnotation<A>> matched1 = mergedAnnotation.getMatchedRepeatableAnnotation(annotationType);
                    if (matched1 == null) continue;
                    matchedSet.addAll(matched1);
                    continue;
                }
                MatchedMergedAnnotation<A> matched2 = mergedAnnotation.getMatchedAnnotation(annotationType);
                if (matched2 == null) continue;
                matchedSet.add(matched2);
            }
        }
        if (matchedSet.isEmpty()) {
            return null;
        }
        return matchedSet;
    }

    public SortedMap<Integer, Set<MergedAnnotation>> getHierarchyAnnotations() {
        if (this.hierarchyAnnotations == null) {
            this.hierarchyAnnotations = Collections.unmodifiableSortedMap(MergedAnnotations.scanHierarchyAnnotations(this));
        }
        return this.hierarchyAnnotations;
    }

    public Annotation getAnnotation() {
        if (this.annotation != null) {
            return this.annotation;
        }
        return AnnotationAttributes.of(this.annotationType).asAnnotation();
    }

    public boolean isRepeatable() {
        return this.repeatedAnnotationType != null && this.repeatedAnnotations != null;
    }

    public boolean isAlias() {
        return this.aliasSource != null && this.aliasMethods != null;
    }

    public Map<String, Object> getAliasValues() {
        HashMap<String, Object> aliasValues = new HashMap<String, Object>();
        if (this.aliasSource.isAlias()) {
            AnnotationAttributes aliasAnnotationAttributes = this.aliasSource.getAliasAnnotationAttributes();
            for (Map.Entry<String, Method> entry : this.aliasMethods.entrySet()) {
                aliasValues.put(entry.getKey(), aliasAnnotationAttributes.get(entry.getValue().getName()));
            }
        } else {
            for (Map.Entry<String, Method> entry : this.aliasMethods.entrySet()) {
                aliasValues.put(entry.getKey(), Reflects.invokeQuietly(this.aliasSource.getAnnotation(), entry.getValue(), new Object[0]));
            }
        }
        return aliasValues;
    }

    AnnotationAttributes getAliasAnnotationAttributes() {
        Map<String, Object> aliasValues = this.getAliasValues();
        AnnotationAttributes attributes = AnnotationAttributes.of(this.annotationType);
        attributes.set(aliasValues);
        return attributes;
    }

    public int getDistance() {
        return this.distance;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public MergedAnnotation getAliasSource() {
        return this.aliasSource;
    }

    public Map<String, Method> getAliasMethods() {
        return this.aliasMethods;
    }

    public Class<? extends Annotation> getRepeatedAnnotationType() {
        return this.repeatedAnnotationType;
    }

    public MergedAnnotation[] getRepeatedAnnotations() {
        return this.repeatedAnnotations;
    }

    public String toString() {
        return "MergedAnnotation(distance=" + this.distance + ", annotatedElement=" + this.annotatedElement + ", annotation=" + this.annotation + ", annotationType=" + this.annotationType + ", aliasSource=" + this.aliasSource + ", aliasMethods=" + this.aliasMethods + ", repeatedAnnotationType=" + this.repeatedAnnotationType + ", repeatedAnnotations=" + Arrays.deepToString(this.repeatedAnnotations) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergedAnnotation)) {
            return false;
        }
        MergedAnnotation other = (MergedAnnotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.distance != other.distance) {
            return false;
        }
        AnnotatedElement this$annotatedElement = this.annotatedElement;
        AnnotatedElement other$annotatedElement = other.annotatedElement;
        if (this$annotatedElement == null ? other$annotatedElement != null : !this$annotatedElement.equals(other$annotatedElement)) {
            return false;
        }
        Annotation this$annotation = this.annotation;
        Annotation other$annotation = other.annotation;
        if (this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation)) {
            return false;
        }
        Class<? extends Annotation> this$annotationType = this.annotationType;
        Class<? extends Annotation> other$annotationType = other.annotationType;
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        MergedAnnotation this$aliasSource = this.aliasSource;
        MergedAnnotation other$aliasSource = other.aliasSource;
        if (this$aliasSource == null ? other$aliasSource != null : !((Object)this$aliasSource).equals(other$aliasSource)) {
            return false;
        }
        Map<String, Method> this$aliasMethods = this.aliasMethods;
        Map<String, Method> other$aliasMethods = other.aliasMethods;
        if (this$aliasMethods == null ? other$aliasMethods != null : !((Object)this$aliasMethods).equals(other$aliasMethods)) {
            return false;
        }
        Class<? extends Annotation> this$repeatedAnnotationType = this.repeatedAnnotationType;
        Class<? extends Annotation> other$repeatedAnnotationType = other.repeatedAnnotationType;
        if (this$repeatedAnnotationType == null ? other$repeatedAnnotationType != null : !this$repeatedAnnotationType.equals(other$repeatedAnnotationType)) {
            return false;
        }
        return Arrays.deepEquals(this.repeatedAnnotations, other.repeatedAnnotations);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MergedAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.distance;
        AnnotatedElement $annotatedElement = this.annotatedElement;
        result = result * 59 + ($annotatedElement == null ? 43 : $annotatedElement.hashCode());
        Annotation $annotation = this.annotation;
        result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
        Class<? extends Annotation> $annotationType = this.annotationType;
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        MergedAnnotation $aliasSource = this.aliasSource;
        result = result * 59 + ($aliasSource == null ? 43 : ((Object)$aliasSource).hashCode());
        Map<String, Method> $aliasMethods = this.aliasMethods;
        result = result * 59 + ($aliasMethods == null ? 43 : ((Object)$aliasMethods).hashCode());
        Class<? extends Annotation> $repeatedAnnotationType = this.repeatedAnnotationType;
        result = result * 59 + ($repeatedAnnotationType == null ? 43 : $repeatedAnnotationType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.repeatedAnnotations);
        return result;
    }
}

