/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.asm.reflect.BeanLambdaAccess;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.BeanMapOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

class BeanLambdaMap<T>
extends BeanMap<T> {
    private static final ILogger log = ILoggers.of(BeanLambdaMap.class);
    private final BeanLambdaAccess<?> access;
    private final Map<String, Function<Object, Object>> getters;
    private final Map<String, BiConsumer<Object, Object>> setters;
    private transient Set<Map.Entry<String, Object>> entrySet;
    private transient Collection<Object> values;
    private transient Set<String> keySet;

    BeanLambdaMap(T bean, Class<?> beanType, BeanMapOptions options) {
        super(bean, beanType, options);
        BeanLambdaAccess<?> access = BeanLambdaAccess.get(beanType);
        this.access = access;
        if (this.includeFields) {
            HashMap<String, Function<Object, Object>> getters = new HashMap<String, Function<Object, Object>>();
            HashMap<String, BiConsumer<Object, Object>> setters = new HashMap<String, BiConsumer<Object, Object>>();
            getters.putAll(access.propertyGetters());
            getters.putAll(access.fieldGetters());
            setters.putAll(access.propertySetters());
            setters.putAll(access.fieldSetters());
            this.getters = Collections.unmodifiableMap(getters);
            this.setters = Collections.unmodifiableMap(setters);
        } else {
            this.getters = access.propertyGetters();
            this.setters = access.propertySetters();
        }
    }

    @Override
    public Type getType(String key) {
        return this.access.propertyGenericType(key);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            Function<Object, Object> getter = this.getters.get((String)key);
            if (getter != null) {
                return getter.apply(this.bean);
            }
            if (this.hasFallbackGetter) {
                return this.options.fallbackGetter().apply((String)key);
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        BiConsumer<Object, Object> setter = this.setters.get(key);
        if (setter != null) {
            block7: {
                try {
                    if (this.hasConverter && value != null) {
                        Type type = this.access.propertyGenericType(key);
                        value = this.options.converter().apply(type, value);
                    }
                    setter.accept(this.bean, value);
                }
                catch (Exception e) {
                    if (this.ignoreError) break block7;
                    throw new IllegalArgumentException("\u5c5e\u6027\u5199\u5165\u5931\u8d25\uff1a" + this.beanType.getCanonicalName() + "." + key, e);
                }
            }
            return null;
        }
        if (this.hasFallbackSetter) {
            this.options.fallbackSetter().accept(key, value);
            return null;
        }
        if (!this.ignoreUnknownKeys) {
            throw new IllegalArgumentException("\u672a\u77e5\u5c5e\u6027\uff1a" + key);
        }
        if (this.warnUnknownKeys) {
            log.warn("\u672a\u77e5\u5c5e\u6027\uff1a{}.{}", this.beanType.getCanonicalName(), key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public int size() {
        return this.getters.size();
    }

    @Override
    public boolean isEmpty() {
        return this.getters.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getters.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.getters.keySet();
    }

    @Override
    public Collection<Object> values() {
        InnerValues vs = this.values;
        if (vs == null) {
            this.values = vs = new InnerValues();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        InnerEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new InnerEntrySet()) : es;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<String, Function<Object, Object>> entry : this.getters.entrySet()) {
            Function<Object, Object> function = entry.getValue();
            Object obj = function.apply(this.bean);
            if (!Objs.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    final class InnerEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        InnerEntrySet() {
        }

        @Override
        public int size() {
            return BeanLambdaMap.this.size();
        }

        @Override
        public void clear() {
            BeanLambdaMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                Set<Map.Entry<String, Function<Object, Object>>> entrySet;
                Iterator<Map.Entry<String, Function<Object, Object>>> it;
                {
                    this.entrySet = BeanLambdaMap.this.getters.entrySet();
                    this.it = this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    final Map.Entry<String, Function<Object, Object>> next = this.it.next();
                    return new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return (String)next.getKey();
                        }

                        @Override
                        public Object getValue() {
                            return ((Function)next.getValue()).apply(BeanLambdaMap.this.bean);
                        }

                        @Override
                        public Object setValue(Object value) {
                            return BeanLambdaMap.this.put((String)next.getKey(), value);
                        }
                    };
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            if (!BeanLambdaMap.this.containsKey(key)) {
                return false;
            }
            Object val = BeanLambdaMap.this.get(key);
            return Objs.equals(val, e.getValue());
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    final class InnerValues
    extends AbstractCollection<Object> {
        InnerValues() {
        }

        @Override
        public final int size() {
            return BeanLambdaMap.this.size();
        }

        @Override
        public final void clear() {
            BeanLambdaMap.this.clear();
        }

        @Override
        public final Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private final Set<Map.Entry<String, Function<Object, Object>>> entrySet;
                private final Iterator<Map.Entry<String, Function<Object, Object>>> it;
                {
                    this.entrySet = BeanLambdaMap.this.getters.entrySet();
                    this.it = this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Object next() {
                    Map.Entry<String, Function<Object, Object>> entry = this.it.next();
                    return entry.getValue().apply(BeanLambdaMap.this.bean);
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            return BeanLambdaMap.this.containsValue(o);
        }
    }
}

