/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ExtendedBeanMap<T>
implements Map<String, Object> {
    protected final BeanMap<T> beanMap;
    protected final Map<String, Object> addition;
    private Collection<Object> values;
    private InnerEntrySet entrySet;

    public ExtendedBeanMap(BeanMap<T> beanMap) {
        this(beanMap, new HashMap<String, Object>());
    }

    public ExtendedBeanMap(BeanMap<T> beanMap, Map<String, Object> addition) {
        this.beanMap = beanMap;
        this.addition = addition;
    }

    public String toString() {
        return this.beanMap.toString();
    }

    @Override
    public int size() {
        return this.beanMap.size() + this.addition.size();
    }

    @Override
    public boolean isEmpty() {
        return this.beanMap.isEmpty() && this.addition.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.beanMap.containsKey(key) || this.addition.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.beanMap.containsValue(value) || this.addition.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object o = this.beanMap.get(key);
        if (o == null) {
            o = this.addition.get(key);
        }
        return o;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.beanMap.containsKey(key)) {
            return this.beanMap.put(key, value);
        }
        return this.addition.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (this.beanMap.containsKey(key)) {
            return this.beanMap.remove(key);
        }
        return this.addition.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.beanMap.clear();
        this.addition.clear();
    }

    @Override
    public Set<String> keySet() {
        if (this.addition.isEmpty()) {
            return this.beanMap.keySet();
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(this.beanMap.keySet());
        keys.addAll(this.addition.keySet());
        return keys;
    }

    @Override
    public Collection<Object> values() {
        if (this.addition.isEmpty()) {
            return this.beanMap.values();
        }
        InnerValues vs = this.values;
        if (vs == null) {
            this.values = vs = new InnerValues();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.addition.isEmpty()) {
            return this.beanMap.entrySet();
        }
        InnerEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new InnerEntrySet()) : es;
    }

    final class InnerEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        InnerEntrySet() {
        }

        @Override
        public int size() {
            return ExtendedBeanMap.this.size();
        }

        @Override
        public void clear() {
            ExtendedBeanMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                private final Set<Map.Entry<String, Object>> entrySet;
                private final Iterator<Map.Entry<String, Object>> it;
                private final Set<Map.Entry<String, Object>> additionSet;
                private final Iterator<Map.Entry<String, Object>> additionIt;
                {
                    this.entrySet = ExtendedBeanMap.this.beanMap.entrySet();
                    this.it = this.entrySet.iterator();
                    this.additionSet = ExtendedBeanMap.this.addition.entrySet();
                    this.additionIt = this.additionSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    return this.additionIt.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    return this.additionIt.next();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            if (!ExtendedBeanMap.this.containsKey(key)) {
                return false;
            }
            Object val = ExtendedBeanMap.this.get(key);
            return Objs.equals(val, e.getValue());
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    final class InnerValues
    extends AbstractCollection<Object> {
        InnerValues() {
        }

        @Override
        public final int size() {
            return ExtendedBeanMap.this.size();
        }

        @Override
        public final void clear() {
            ExtendedBeanMap.this.clear();
        }

        @Override
        public final Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private final Set<Map.Entry<String, Object>> entrySet;
                private final Iterator<Map.Entry<String, Object>> it;
                private final Set<Map.Entry<String, Object>> additionSet;
                private final Iterator<Map.Entry<String, Object>> additionIt;
                {
                    this.entrySet = ExtendedBeanMap.this.beanMap.entrySet();
                    this.it = this.entrySet.iterator();
                    this.additionSet = ExtendedBeanMap.this.addition.entrySet();
                    this.additionIt = this.additionSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    return this.additionIt.hasNext();
                }

                @Override
                public Object next() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    return this.additionIt.next();
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            return ExtendedBeanMap.this.containsValue(o);
        }
    }
}

