/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.BeanAccessMode;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.IndexedMetaObject;
import io.polaris.core.lang.bean.LambdaMetaObject;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MetaObject<T> {
    public static final int INIT = 0;
    public static final int PARSING = 1;
    public static final int READY = 2;
    public static final int CASE_INSENSITIVE = 1;
    public static final int CASE_CAMEL = 2;
    private static final ILogger log = ILoggers.of(MetaObject.class);
    private static final Set<Class> basicTypes;
    private final JavaType<T> beanType;
    private int state = 0;
    private boolean isObject;
    private boolean isBasic;
    private boolean isPrimitive;
    private boolean isPrimitiveWrapper;
    private boolean isEnum;
    private boolean isArray;
    private boolean isMap;
    private boolean isCollection;
    private boolean isBean;
    private MetaObject<?> keyType;
    private MetaObject<?> elementType;

    protected MetaObject(JavaType<T> beanType) {
        this.beanType = beanType;
    }

    protected final int state() {
        return this.state;
    }

    protected final void parse() {
        this.state = 1;
        try {
            Class<T> rawClass = this.beanType.getRawClass();
            if (Object.class.equals(rawClass)) {
                this.isObject = true;
            } else if (rawClass.isPrimitive()) {
                this.isPrimitive = true;
                this.isBasic = true;
            } else if (Types.isPrimitiveWrapper(rawClass)) {
                this.isPrimitiveWrapper = true;
                this.isBasic = true;
            } else if (basicTypes.contains(rawClass)) {
                this.isBasic = true;
            } else if (rawClass.isEnum()) {
                this.isEnum = true;
            } else if (rawClass.isArray()) {
                this.isArray = true;
                this.elementType = this.createMetaObject(JavaType.of(rawClass.getComponentType()));
            } else if (Map.class.isAssignableFrom(rawClass)) {
                this.isMap = true;
                this.keyType = this.createMetaObject(JavaType.of(this.beanType.getActualType(Map.class, 0)));
                this.elementType = this.createMetaObject(JavaType.of(this.beanType.getActualType(Map.class, 1)));
            } else if (Collection.class.isAssignableFrom(rawClass)) {
                this.isCollection = true;
                this.elementType = this.createMetaObject(JavaType.of(this.beanType.getActualType(Collection.class, 0)));
            } else if (this.initBeanAccessor(rawClass)) {
                this.isBean = true;
            } else {
                this.isBasic = true;
            }
        }
        finally {
            this.state = 2;
        }
    }

    protected boolean initBeanAccessor(Class<T> rawClass) {
        return false;
    }

    protected abstract <E> MetaObject<E> createMetaObject(JavaType<E> var1);

    protected abstract Object getBeanPropertyOrSetDefault(@Nonnull T var1, int var2, @Nonnull String var3);

    protected abstract Object setBeanProperty(@Nonnull T var1, int var2, @Nonnull String var3, Object var4);

    protected abstract MetaObject<?> getBeanProperty(int var1, @Nonnull String var2);

    protected abstract Object getBeanProperty(@Nonnull T var1, int var2, @Nonnull String var3);

    protected abstract boolean hasBeanProperty(@Nonnull T var1, int var2, @Nonnull String var3);

    public static <T> MetaObject<T> of(BeanAccessMode mode, JavaType<T> beanType) {
        if (mode == null) {
            mode = BeanAccessMode.INDEXED;
        }
        switch (mode) {
            case LAMBDA: {
                return LambdaMetaObject.of(beanType);
            }
        }
        return IndexedMetaObject.of(beanType);
    }

    public static <T> MetaObject<T> of(JavaType<T> beanType) {
        return MetaObject.of(BeanAccessMode.INDEXED, beanType);
    }

    public static <T> MetaObject<T> of(Class<T> beanType) {
        return MetaObject.of(BeanAccessMode.INDEXED, JavaType.of(beanType));
    }

    public static <T> MetaObject<T> of(TypeRef<T> beanType) {
        return MetaObject.of(BeanAccessMode.INDEXED, JavaType.of(beanType));
    }

    public static <T> MetaObject<T> of(Type beanType) {
        return MetaObject.of(BeanAccessMode.INDEXED, JavaType.of(beanType));
    }

    public static int buildCaseModel(boolean caseInsensitive, boolean caseCamel) {
        return (caseInsensitive ? 1 : 0) | (caseCamel ? 2 : 0);
    }

    public static boolean isCaseInsensitive(int caseModel) {
        return (1 & caseModel) != 0;
    }

    public static boolean isCaseCamel(int caseModel) {
        return (2 & caseModel) != 0;
    }

    @Nullable
    public T newInstance() {
        return Reflects.newInstanceIfPossible(this.beanType.getRawClass());
    }

    public Object getPropertyOrSetDefault(@Nonnull T o, @Nonnull String property) {
        return this.getPropertyOrSetDefault(o, 0, property);
    }

    public Object getPropertyOrSetDefault(@Nonnull T o, int caseModel, @Nonnull String property) {
        if (this.isObject || this.isBasic || this.isEnum) {
            MetaObject<?> runtimeMeta = this.createMetaObject(JavaType.of(o.getClass()));
            if (this.equals(runtimeMeta) || runtimeMeta.isObject || runtimeMeta.isBasic || runtimeMeta.isEnum) {
                log.debug("Unsupported property\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            return runtimeMeta.getPropertyOrSetDefault(o, caseModel, property);
        }
        if (this.isArray) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Array index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int length = Array.getLength(o);
            if (idx >= length) {
                log.debug("Array index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            Object val = Array.get(o, idx);
            if (val == null && (val = this.elementType.newInstance()) != null) {
                Array.set(o, idx, val);
            }
            return val;
        }
        if (this.isMap) {
            Object k = Converters.convertQuietly(this.keyType.beanType, property);
            Object val = ((Map)o).get(k);
            if (val == null) {
                val = this.elementType.newInstance();
                ((Map)o).put(k, val);
            }
            return val;
        }
        if (this.isCollection) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Collection index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int size = ((Collection)o).size();
            if (idx >= size) {
                for (int i = size; i < idx; ++i) {
                    ((Collection)o).add(null);
                }
                Object val = this.elementType.newInstance();
                ((Collection)o).add(val);
                return val;
            }
            if (o instanceof List) {
                Object val = ((List)o).get(idx);
                if (val == null) {
                    val = this.elementType.newInstance();
                    ((List)o).set(idx, val);
                }
                return val;
            }
            ArrayList list = new ArrayList((Collection)o);
            Object val = list.get(idx);
            if (val == null) {
                val = this.elementType.newInstance();
                list.set(idx, val);
                ((Collection)o).clear();
                ((Collection)o).addAll(list);
            }
            return val;
        }
        return this.getBeanPropertyOrSetDefault(o, caseModel, property);
    }

    public Object setProperty(@Nonnull T o, @Nonnull String property, Object val) {
        return this.setProperty(o, 0, property, val);
    }

    public Object setProperty(@Nonnull T o, int caseModel, @Nonnull String property, Object val) {
        if (this.isObject || this.isBasic || this.isEnum) {
            MetaObject<?> runtimeMeta = this.createMetaObject(JavaType.of(o.getClass()));
            if (this.equals(runtimeMeta) || runtimeMeta.isObject || runtimeMeta.isBasic || runtimeMeta.isEnum) {
                log.debug("Unsupported property\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            return runtimeMeta.setProperty(o, caseModel, property, val);
        }
        if (this.isArray) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Array index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int length = Array.getLength(o);
            if (idx >= length) {
                log.debug("Array index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            val = Converters.convertQuietly(this.elementType.beanType, val);
            Array.set(o, idx, val);
            return val;
        }
        if (this.isMap) {
            Object k = Converters.convertQuietly(this.keyType.beanType, property);
            val = Converters.convertQuietly(this.elementType.beanType, val);
            ((Map)o).put(k, val);
            return val;
        }
        if (this.isCollection) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Collection index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int size = ((Collection)o).size();
            if (idx >= size) {
                for (int i = size; i < idx; ++i) {
                    ((Collection)o).add(Types.getDefaultValue(this.elementType.beanType.getRawClass()));
                }
                val = Converters.convertQuietly(this.elementType.beanType, val);
                ((Collection)o).add(val);
                return val;
            }
            if (o instanceof List) {
                val = Converters.convertQuietly(this.elementType.beanType, val);
                ((List)o).set(idx, val);
                return val;
            }
            ArrayList list = new ArrayList((Collection)o);
            val = Converters.convertQuietly(this.elementType.beanType, val);
            list.set(idx, val);
            ((Collection)o).clear();
            ((Collection)o).addAll(list);
            return val;
        }
        return this.setBeanProperty(o, caseModel, property, val);
    }

    public MetaObject<?> getProperty(@Nonnull String property) {
        return this.getProperty(0, property);
    }

    public MetaObject<?> getProperty(int caseModel, @Nonnull String property) {
        if (this.isObject || this.isBasic || this.isEnum) {
            log.debug("Unsupported property\uff1a{}:{}", this.beanType.getTypeName(), property);
            return null;
        }
        if (this.isArray || this.isCollection || this.isMap) {
            return this.elementType;
        }
        return this.getBeanProperty(caseModel, property);
    }

    public MetaObject<?> getPathProperty(int caseModel, @Nonnull String property) {
        String key;
        Deque<String> properties = Beans.parseProperty(property);
        MetaObject<?> meta = this;
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext() && (meta = meta.getProperty(caseModel, key = iterator.next())) != null) {
        }
        return meta;
    }

    public Object getProperty(@Nonnull T o, @Nonnull String property) {
        return this.getProperty(o, 0, property);
    }

    public Object getProperty(@Nonnull T o, int caseModel, @Nonnull String property) {
        if (this.isObject || this.isBasic || this.isEnum) {
            MetaObject<?> runtimeMeta = this.createMetaObject(JavaType.of(o.getClass()));
            if (this.equals(runtimeMeta) || runtimeMeta.isObject || runtimeMeta.isBasic || runtimeMeta.isEnum) {
                log.debug("Unsupported property\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            return runtimeMeta.getProperty(o, caseModel, property);
        }
        if (this.isArray) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Array index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int length = Array.getLength(o);
            if (idx >= length) {
                log.debug("Array index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            return Array.get(o, idx);
        }
        if (this.isMap) {
            Object k = Converters.convertQuietly(this.keyType.beanType, property);
            return ((Map)o).get(k);
        }
        if (this.isCollection) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Collection index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            int size = ((Collection)o).size();
            if (idx >= size) {
                log.debug("Collection index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return null;
            }
            if (o instanceof List) {
                return ((List)o).get(idx);
            }
            Iterator iter = ((Collection)o).iterator();
            for (int i = 0; i < idx; ++i) {
                iter.next();
            }
            return iter.next();
        }
        return this.getBeanProperty(o, caseModel, property);
    }

    public boolean hasProperty(@Nonnull T o, @Nonnull String property) {
        return this.hasProperty(o, 0, property);
    }

    public boolean hasProperty(@Nonnull T o, int caseModel, @Nonnull String property) {
        if (this.isObject || this.isBasic || this.isEnum) {
            MetaObject<?> runtimeMeta = this.createMetaObject(JavaType.of(o.getClass()));
            if (this.equals(runtimeMeta) || runtimeMeta.isObject || runtimeMeta.isBasic || runtimeMeta.isEnum) {
                return false;
            }
            return runtimeMeta.hasProperty(o, caseModel, property);
        }
        if (this.isArray) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Array index number format error\uff1a{}:{}", this.beanType.getTypeName(), property);
                return false;
            }
            int length = Array.getLength(o);
            if (idx >= length) {
                return false;
            }
            return Array.get(o, idx) != null;
        }
        if (this.isMap) {
            Object k = Converters.convertQuietly(this.keyType.beanType, property);
            return ((Map)o).get(k) != null;
        }
        if (this.isCollection) {
            int idx = 0;
            try {
                idx = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("Collection index out of bounds\uff1a{}:{}", this.beanType.getTypeName(), property);
                return false;
            }
            int size = ((Collection)o).size();
            if (idx >= size) {
                return false;
            }
            if (o instanceof List) {
                return ((List)o).get(idx) != null;
            }
            Iterator iter = ((Collection)o).iterator();
            for (int i = 0; i < idx; ++i) {
                iter.next();
            }
            return iter.next() != null;
        }
        return this.hasBeanProperty(o, caseModel, property);
    }

    public Object getPathProperty(@Nonnull T o, @Nonnull String property) {
        return this.getPathProperty(o, 0, Beans.parseProperty(property));
    }

    public Object getPathProperty(@Nonnull T o, int caseModel, @Nonnull String property) {
        return this.getPathProperty(o, caseModel, Beans.parseProperty(property));
    }

    public Object setPathProperty(@Nonnull T o, @Nonnull String property, Object val) {
        return this.setPathProperty(o, 0, Beans.parseProperty(property), val);
    }

    public Object setPathProperty(@Nonnull T o, int caseModel, @Nonnull String property, Object val) {
        return this.setPathProperty(o, caseModel, Beans.parseProperty(property), val);
    }

    private Object setPathProperty(@Nonnull T o, int caseModel, Deque<String> properties, Object val) {
        if (val == null) {
            return null;
        }
        String property = properties.pollLast();
        if (properties.isEmpty()) {
            return this.setProperty(o, caseModel, property, val);
        }
        PropertyInfo info = this.getRequiredPathProperty(o, caseModel, properties);
        if (info == null) {
            return null;
        }
        if (((PropertyInfo)info).propertyMeta.isArray) {
            return this.setArrayElement(info, property, ((PropertyInfo)info).propertyMeta.elementType, val);
        }
        return info.propertyMeta.setProperty(info.propertyObj, caseModel, property, val);
    }

    private Object getPathProperty(T obj, int caseModel, Deque<String> properties) {
        String property;
        Object target = obj;
        MetaObject<?> meta = this;
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext() && (target = meta.getProperty(target, caseModel, property = iterator.next())) != null) {
            meta = meta.getProperty(caseModel, property);
        }
        return target;
    }

    private PropertyInfo getRequiredPathProperty(T obj, int caseModel, Deque<String> properties) {
        PropertyInfo info = new PropertyInfo("", obj, this, null, null);
        for (String property : properties) {
            Object propVal = info.propertyMeta.getPropertyOrSetDefault(info.propertyObj, caseModel, property);
            MetaObject<?> propMeta = info.propertyMeta.getProperty(caseModel, property);
            if (propVal == null && (propVal = this.setArrayElement(info, property, propMeta, null)) == null) {
                return null;
            }
            info.propertyName = property;
            info.parentObj = info.propertyObj;
            info.parentMeta = info.propertyMeta;
            info.propertyObj = propVal;
            info.propertyMeta = propMeta;
        }
        return info;
    }

    private Object setArrayElement(PropertyInfo info, String indexProperty, MetaObject propMeta, Object propVal) {
        if (info.parentMeta != null && ((PropertyInfo)info).propertyMeta.isArray) {
            int idx = Integer.parseInt(indexProperty);
            Object array = this.extendArrayLength(info, idx + 1);
            propVal = propVal == null ? propMeta.newInstance() : Converters.convert(((PropertyInfo)info).propertyMeta.elementType.beanType, propVal);
            Array.set(array, idx, propVal);
        }
        return propVal;
    }

    private Object extendArrayLength(PropertyInfo info, int minLength) {
        int length;
        if (((PropertyInfo)info).propertyMeta.isArray && (length = Array.getLength(info.propertyObj)) < minLength) {
            Object newArray = Array.newInstance(((PropertyInfo)info).propertyMeta.elementType.beanType.getRawClass(), minLength);
            info.parentMeta.setProperty(info.parentObj, info.propertyName, newArray);
            System.arraycopy(info.propertyObj, 0, newArray, 0, length);
            return newArray;
        }
        return info.propertyObj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaObject that = (MetaObject)o;
        return Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return Objects.hash(this.beanType);
    }

    public JavaType<T> getBeanType() {
        return this.beanType;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isBasic() {
        return this.isBasic;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isPrimitiveWrapper() {
        return this.isPrimitiveWrapper;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isBean() {
        return this.isBean;
    }

    public MetaObject<?> getKeyType() {
        return this.keyType;
    }

    public MetaObject<?> getElementType() {
        return this.elementType;
    }

    static {
        HashSet<Class> set = new HashSet<Class>();
        set.add(Class.class);
        set.add(String.class);
        set.add(CharSequence.class);
        set.add(StringBuilder.class);
        set.add(StringBuffer.class);
        set.add(AtomicInteger.class);
        set.add(AtomicLong.class);
        set.add(AtomicBoolean.class);
        set.add(LongAdder.class);
        set.add(DoubleAdder.class);
        set.add(BigDecimal.class);
        set.add(BigInteger.class);
        basicTypes = Collections.unmodifiableSet(set);
    }

    private static class PropertyInfo {
        private String propertyName;
        private Object propertyObj;
        private MetaObject propertyMeta;
        private Object parentObj;
        private MetaObject parentMeta;

        public PropertyInfo(String propertyName, Object propertyObj, MetaObject propertyMeta, Object parentObj, MetaObject parentMeta) {
            this.propertyName = propertyName;
            this.propertyObj = propertyObj;
            this.propertyMeta = propertyMeta;
            this.parentObj = parentObj;
            this.parentMeta = parentMeta;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object getPropertyObj() {
            return this.propertyObj;
        }

        public MetaObject getPropertyMeta() {
            return this.propertyMeta;
        }

        public Object getParentObj() {
            return this.parentObj;
        }

        public MetaObject getParentMeta() {
            return this.parentMeta;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setPropertyObj(Object propertyObj) {
            this.propertyObj = propertyObj;
        }

        public void setPropertyMeta(MetaObject propertyMeta) {
            this.propertyMeta = propertyMeta;
        }

        public void setParentObj(Object parentObj) {
            this.parentObj = parentObj;
        }

        public void setParentMeta(MetaObject parentMeta) {
            this.parentMeta = parentMeta;
        }
    }
}

