/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.lang.bean.PropertyAccessor;
import java.lang.reflect.Type;

class PropertyIndexedAccessor
implements PropertyAccessor {
    private final BeanAccess<?> access;
    private final Type type;
    private final int getter;
    private final int setter;

    PropertyIndexedAccessor(BeanAccess<?> access, Type type, int getter, int setter) {
        this.access = access;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean hasSetter() {
        return this.setter >= 0;
    }

    @Override
    public boolean hasGetter() {
        return this.getter >= 0;
    }

    @Override
    public Object get(Object bean) {
        return this.access.getIndexProperty(bean, this.getter);
    }

    @Override
    public void set(Object bean, Object val) {
        this.access.setIndexProperty(bean, this.setter, val);
    }
}

