/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.asm.reflect.BeanLambdaAccess;
import io.polaris.core.lang.bean.PropertyAccessor;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;

class PropertyLambdaAccessor
implements PropertyAccessor {
    private final BeanLambdaAccess<?> access;
    private final Type type;
    private final Function<Object, Object> getter;
    private final BiConsumer<Object, Object> setter;

    PropertyLambdaAccessor(BeanLambdaAccess<?> access, Type type, Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
        this.access = access;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean hasSetter() {
        return this.setter != null;
    }

    @Override
    public boolean hasGetter() {
        return this.getter != null;
    }

    @Override
    public Object get(Object bean) {
        return this.getter.apply(bean);
    }

    @Override
    public void set(Object bean, Object val) {
        this.setter.accept(bean, val);
    }
}

