/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean.property;

import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.property.AbstractPropertyBuilder;
import io.polaris.core.lang.bean.property.PropertyBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPropertyBuilder<T>
extends AbstractPropertyBuilder<List<T>>
implements PropertyBuilder<List<T>> {
    private List<T> list;
    private Class<T> clazz;

    public ListPropertyBuilder(List<T> list, Class<T> clazz) {
        this(list, clazz, 0);
    }

    public ListPropertyBuilder(List<T> list, Class<T> clazz, int size) {
        this.list = list == null ? new ArrayList<T>() : list;
        if (clazz == null) {
            throw new IllegalArgumentException("class is null");
        }
        this.clazz = clazz;
        for (int i = this.list.size(); i < size; ++i) {
            this.list.add(this.newOne());
        }
    }

    private T newOne() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("class cannot be initialized", e);
        }
    }

    private T getIndexObj(int i) {
        T one;
        if (this.list.size() <= i) {
            one = this.newOne();
            this.list.add(one);
        } else {
            one = this.list.get(i);
        }
        return one;
    }

    @Override
    public void exec(AbstractPropertyBuilder.Operation operation) {
        Object orig = operation.orig;
        if (orig != null) {
            if (orig instanceof Collection) {
                int i = 0;
                for (Object o : (Collection)orig) {
                    Object val = Beans.getPathProperty(o, operation.origProperty);
                    if (val != null || !operation.ignoredNull) {
                        T one = this.getIndexObj(i);
                        Beans.setPathProperty(one, operation.destProperty, val);
                    }
                    ++i;
                }
            } else if (orig.getClass().isArray()) {
                int len = Array.getLength(orig);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(orig, i);
                    Object val = Beans.getPathProperty(o, operation.origProperty);
                    if (val == null && operation.ignoredNull) continue;
                    T one = this.getIndexObj(i);
                    Beans.setPathProperty(one, operation.destProperty, val);
                }
            } else {
                for (T one : this.list) {
                    Object val = Beans.getPathProperty(orig, operation.origProperty);
                    if (val == null && operation.ignoredNull) continue;
                    Beans.setPathProperty(one, operation.destProperty, val);
                }
            }
        } else {
            for (T one : this.list) {
                if (operation.propertyValue == null && operation.ignoredNull) continue;
                Beans.setPathProperty(one, operation.destProperty, operation.propertyValue);
            }
        }
    }

    @Override
    public List<T> done() {
        this.exec();
        return this.list;
    }
}

