/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.PropertyAccessor;
import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanToMapCopier<T>
implements Copier<Map> {
    private static final ILogger log = ILoggers.of(BeanToMapCopier.class);
    private final T source;
    private final Map target;
    private final Type sourceType;
    private final Type targetType;
    private final CopyOptions options;

    public BeanToMapCopier(Type sourceType, T source, Type targetType, Map target, CopyOptions options) {
        this.source = source;
        this.target = target;
        this.sourceType = sourceType != null ? sourceType : source.getClass();
        this.targetType = targetType != null ? targetType : target.getClass();
        this.options = options != null ? options : CopyOptions.create();
    }

    @Override
    public Map copy() {
        block7: {
            try {
                Map<String, PropertyAccessor> sourceAccessors = Beans.getIndexedFieldAndPropertyAccessors(JavaType.of(this.sourceType).getRawClass());
                JavaType javaType = JavaType.of(this.targetType);
                Type keyType = javaType.getActualType(Map.class, 0);
                Type valueType = javaType.getActualType(Map.class, 1);
                for (Map.Entry<String, PropertyAccessor> entry : sourceAccessors.entrySet()) {
                    String sourceKey = entry.getKey();
                    PropertyAccessor sourceAccessor = entry.getValue();
                    if (sourceKey == null) continue;
                    try {
                        Object orig;
                        Object value;
                        String key = this.options.editKey(sourceKey);
                        if (this.options.isIgnoredKey(key) || !sourceAccessor.hasSetter() || (value = sourceAccessor.get(this.source)) == null && this.options.ignoreNull()) continue;
                        Object targetKey = this.options.convert(keyType, key);
                        if (!this.options.override() && (orig = this.target.get(key)) != null) continue;
                        value = this.options.convert(valueType, value);
                        if ((value = this.options.editValue(key, value)) == null && this.options.ignoreNull()) continue;
                        this.target.put(targetKey, value);
                    }
                    catch (Exception e) {
                        if (!this.options.ignoreError()) {
                            throw new IllegalArgumentException(e);
                        }
                        log.warn("\u590d\u5236\u5c5e\u6027[{}]\u5931\u8d25\uff1a{}", sourceKey, e.getMessage());
                        if (!log.isDebugEnabled()) continue;
                        log.debug(e.getMessage(), e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.options.ignoreError()) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("\u590d\u5236\u5c5e\u6027\u5931\u8d25\uff1a{}", e.getMessage());
                if (!log.isDebugEnabled()) break block7;
                log.debug(e.getMessage(), e);
            }
        }
        return this.target;
    }
}

