/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CopyOptions {
    public static final BiFunction<Type, Object, Object> DEFAULT_CONVERTER = Converters::convertQuietly;
    public static final BiFunction<Type, Object, Object> PROPERTY_EDITOR_CONVERTER = (type, value) -> {
        Class<?> valueClass;
        if (value == null) {
            return null;
        }
        Class<?> rawClass = Types.getWrapperClass(Types.getClass(type));
        if (rawClass.isAssignableFrom(valueClass = Types.getWrapperClass(value.getClass()))) {
            return value;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor((Class)type);
        if (editor != null) {
            if (value instanceof String) {
                editor.setAsText((String)value);
            } else {
                editor.setAsText(value.toString());
            }
            return editor.getValue();
        }
        return value;
    };
    private boolean ignoreError = true;
    private Set<String> ignoreKeys;
    private boolean ignoreCase = false;
    private boolean ignoreCapitalize = false;
    private boolean enableUnderlineToCamelCase = false;
    private boolean enableCamelToUnderlineCase = false;
    private boolean ignoreNull = true;
    private boolean override = true;
    private Function<String, String> keyMapping;
    private BiFunction<String, Object, Object> valueMapping;
    private boolean enableConverter = true;
    private BiFunction<Type, Object, Object> converter = DEFAULT_CONVERTER;

    public static CopyOptions create() {
        return new CopyOptions();
    }

    public boolean hasKeyMapping() {
        return this.keyMapping != null;
    }

    public boolean isIgnoredKey(String key) {
        return this.ignoreKeys != null && this.ignoreKeys.contains(key);
    }

    public Object convert(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (JavaType.of(type).isInstance(value)) {
            return value;
        }
        if (!this.enableConverter) {
            return null;
        }
        if (this.converter == null) {
            return null;
        }
        return this.converter.apply(type, value);
    }

    public String editKey(String key) {
        if (this.keyMapping != null) {
            return this.keyMapping.apply(key);
        }
        return key;
    }

    public Object editValue(String key, Object value) {
        if (this.valueMapping != null) {
            return this.valueMapping.apply(key, value);
        }
        return value;
    }

    public CopyOptions ignoreNull(boolean ignoreNullValue) {
        this.ignoreNull = ignoreNullValue;
        return this;
    }

    public CopyOptions ignoreKeys(Set<String> keys) {
        this.ignoreKeys = keys;
        return this;
    }

    public CopyOptions ignoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions ignoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions ignoreCapitalize(boolean ignoreCapitalize) {
        this.ignoreCapitalize = ignoreCapitalize;
        return this;
    }

    public CopyOptions enableUnderlineToCamelCase(boolean underlineToCamelCase) {
        this.enableUnderlineToCamelCase = underlineToCamelCase;
        return this;
    }

    public CopyOptions enableCamelToUnderlineCase(boolean camelToUnderlineCase) {
        this.enableCamelToUnderlineCase = camelToUnderlineCase;
        return this;
    }

    public CopyOptions keyMapping(Map<String, String> keyMapping) {
        return this.keyMapping((String key) -> keyMapping.getOrDefault(key, (String)key));
    }

    public CopyOptions keyMapping(Function<String, String> keyMapping) {
        this.keyMapping = keyMapping;
        return this;
    }

    public CopyOptions valueMapping(BiFunction<String, Object, Object> valueMapping) {
        this.valueMapping = valueMapping;
        return this;
    }

    public CopyOptions override(boolean override) {
        this.override = override;
        return this;
    }

    public CopyOptions enableConverter(boolean enableConverter) {
        this.enableConverter = enableConverter;
        return this;
    }

    public CopyOptions converter(BiFunction<Type, Object, Object> converter) {
        this.converter = converter;
        return this;
    }

    public CopyOptions useDefaultConverter() {
        this.converter = DEFAULT_CONVERTER;
        return this;
    }

    public CopyOptions usePropertyEditorConverter() {
        this.converter = PROPERTY_EDITOR_CONVERTER;
        return this;
    }

    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    public boolean ignoreError() {
        return this.ignoreError;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean ignoreCapitalize() {
        return this.ignoreCapitalize;
    }

    public boolean enableUnderlineToCamelCase() {
        return this.enableUnderlineToCamelCase;
    }

    public boolean enableCamelToUnderlineCase() {
        return this.enableCamelToUnderlineCase;
    }

    public boolean override() {
        return this.override;
    }

    public Function<String, String> keyMapping() {
        return this.keyMapping;
    }

    public BiFunction<String, Object, Object> valueMapping() {
        return this.valueMapping;
    }

    public Set<String> ignoreKeys() {
        return this.ignoreKeys;
    }

    public boolean enableConverter() {
        return this.enableConverter;
    }

    public BiFunction<Type, Object, Object> converter() {
        return this.converter;
    }
}

