/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.random.Randoms;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class Longs {
    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return !Longs.isEmpty(array);
    }

    public static long[] join(long[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (long[] array : arrays) {
            if (!Longs.isNotEmpty(array)) continue;
            length += array.length;
        }
        long[] result = new long[length];
        length = 0;
        for (long[] array : arrays) {
            if (!Longs.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int indexOf(long[] array, long value) {
        if (Longs.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long value) {
        if (Longs.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(long[] array, long value) {
        return Longs.indexOf(array, value) > -1;
    }

    public static Long[] wrap(long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Long[0];
        }
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unwrap(Long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new long[0];
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse(0L);
        }
        return array;
    }

    public static long[] sub(long[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new long[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new long[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static long[] remove(long[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        long[] result = new long[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static long[] removeElement(long[] array, long element) throws IllegalArgumentException {
        return Longs.remove(array, Longs.indexOf(array, element));
    }

    public static long[] reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Longs.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Longs.swap(array, i, j);
        }
        return array;
    }

    public static long[] reverse(long[] array) {
        return Longs.reverse(array, 0, array.length);
    }

    public static long min(long ... numberArray) {
        if (Longs.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static long max(long ... numberArray) {
        if (Longs.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static long[] shuffle(long[] array) {
        return Longs.shuffle(array, Randoms.getRandom());
    }

    public static long[] shuffle(long[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Longs.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static long[] swap(long[] array, int index1, int index2) {
        if (Longs.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static boolean isSorted(long[] array) {
        return Longs.isSortedAsc(array);
    }

    public static boolean isSortedAsc(long[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(long[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }
}

