/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log;

import io.polaris.core.collection.ObjectArrays;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLoggers {
    private static String FQCN = Slf4jLoggers.class.getName();
    private static String DFT_NAME;

    public static LocationAwareLogger of() {
        return Slf4jLoggers.of(DFT_NAME);
    }

    public static LocationAwareLogger of(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        if (logger instanceof LocationAwareLogger) {
            return (LocationAwareLogger)logger;
        }
        return null;
    }

    public static void trace(String logName, String msg, Object ... arguments) {
        Slf4jLoggers.trace(logName, msg, arguments, null);
    }

    public static void trace(String logName, String msg, Throwable t) {
        Slf4jLoggers.trace(logName, msg, ObjectArrays.EMPTY, t);
    }

    public static void trace(String logName, String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of(logName);
        if (log != null && log.isTraceEnabled()) {
            log.log(null, FQCN, 0, msg, arguments, t);
        }
    }

    public static void trace(String logName, Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.trace(logName, msg, arguments, t);
    }

    public static void debug(String logName, String msg, Object ... arguments) {
        Slf4jLoggers.debug(logName, msg, arguments, null);
    }

    public static void debug(String logName, String msg, Throwable t) {
        Slf4jLoggers.debug(logName, msg, ObjectArrays.EMPTY, t);
    }

    public static void debug(String logName, String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of(logName);
        if (log != null && log.isDebugEnabled()) {
            log.log(null, FQCN, 10, msg, arguments, t);
        }
    }

    public static void debug(String logName, Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.debug(logName, msg, arguments, t);
    }

    public static void info(String logName, String msg, Object ... arguments) {
        Slf4jLoggers.info(logName, msg, arguments, null);
    }

    public static void info(String logName, String msg, Throwable t) {
        Slf4jLoggers.info(logName, msg, ObjectArrays.EMPTY, t);
    }

    public static void info(String logName, String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of(logName);
        if (log != null && log.isInfoEnabled()) {
            log.log(null, FQCN, 20, msg, arguments, t);
        }
    }

    public static void info(String logName, Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.info(logName, msg, arguments, t);
    }

    public static void warn(String logName, String msg, Object ... arguments) {
        Slf4jLoggers.warn(logName, msg, arguments, null);
    }

    public static void warn(String logName, String msg, Throwable t) {
        Slf4jLoggers.warn(logName, msg, ObjectArrays.EMPTY, t);
    }

    public static void warn(String logName, String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of(logName);
        if (log != null && log.isWarnEnabled()) {
            log.log(null, FQCN, 30, msg, arguments, t);
        }
    }

    public static void warn(String logName, Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.warn(logName, msg, arguments, t);
    }

    public static void error(String logName, String msg, Object ... arguments) {
        Slf4jLoggers.error(logName, msg, arguments, null);
    }

    public static void error(String logName, String msg, Throwable t) {
        Slf4jLoggers.error(logName, msg, ObjectArrays.EMPTY, t);
    }

    public static void error(String logName, String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of(logName);
        if (log != null && log.isErrorEnabled()) {
            log.log(null, FQCN, 40, msg, arguments, t);
        }
    }

    public static void error(String logName, Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.error(logName, msg, arguments, t);
    }

    public static void trace(String msg) {
        Slf4jLoggers.trace(msg, ObjectArrays.EMPTY, null);
    }

    public static void trace(String msg, Object[] arguments) {
        Slf4jLoggers.trace(msg, arguments, null);
    }

    public static void trace(String msg, Throwable t) {
        Slf4jLoggers.trace(msg, ObjectArrays.EMPTY, t);
    }

    public static void trace(String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of();
        if (log != null && log.isTraceEnabled()) {
            log.log(null, FQCN, 0, msg, arguments, t);
        }
    }

    public static void trace(Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.trace(msg, arguments, t);
    }

    public static void debug(String msg) {
        Slf4jLoggers.debug(msg, ObjectArrays.EMPTY, null);
    }

    public static void debug(String msg, Object[] arguments) {
        Slf4jLoggers.debug(msg, arguments, null);
    }

    public static void debug(String msg, Throwable t) {
        Slf4jLoggers.debug(msg, ObjectArrays.EMPTY, t);
    }

    public static void debug(String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of();
        if (log != null && log.isDebugEnabled()) {
            log.log(null, FQCN, 10, msg, arguments, t);
        }
    }

    public static void debug(Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.debug(msg, arguments, t);
    }

    public static void info(String msg) {
        Slf4jLoggers.info(msg, ObjectArrays.EMPTY, null);
    }

    public static void info(String msg, Object[] arguments) {
        Slf4jLoggers.info(msg, arguments, null);
    }

    public static void info(String msg, Throwable t) {
        Slf4jLoggers.info(msg, ObjectArrays.EMPTY, t);
    }

    public static void info(String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of();
        if (log != null && log.isInfoEnabled()) {
            log.log(null, FQCN, 20, msg, arguments, t);
        }
    }

    public static void info(Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.info(msg, arguments, t);
    }

    public static void warn(String msg) {
        Slf4jLoggers.warn(msg, ObjectArrays.EMPTY, null);
    }

    public static void warn(String msg, Object[] arguments) {
        Slf4jLoggers.warn(msg, arguments, null);
    }

    public static void warn(String msg, Throwable t) {
        Slf4jLoggers.warn(msg, ObjectArrays.EMPTY, t);
    }

    public static void warn(String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of();
        if (log != null && log.isWarnEnabled()) {
            log.log(null, FQCN, 30, msg, arguments, t);
        }
    }

    public static void warn(Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.warn(msg, arguments, t);
    }

    public static void error(String msg) {
        Slf4jLoggers.error(msg, ObjectArrays.EMPTY, null);
    }

    public static void error(String msg, Object[] arguments) {
        Slf4jLoggers.error(msg, arguments, null);
    }

    public static void error(String msg, Throwable t) {
        Slf4jLoggers.error(msg, ObjectArrays.EMPTY, t);
    }

    public static void error(String msg, Object[] arguments, Throwable t) {
        LocationAwareLogger log = Slf4jLoggers.of();
        if (log != null && log.isErrorEnabled()) {
            log.log(null, FQCN, 40, msg, arguments, t);
        }
    }

    public static void error(Throwable t, String msg, Object ... arguments) {
        Slf4jLoggers.error(msg, arguments, t);
    }

    static {
        String[] arr = Slf4jLoggers.class.getPackage().getName().split("\\.");
        StringJoiner joiner = new StringJoiner(".");
        joiner.add(arr[0]);
        if (arr.length > 1) {
            joiner.add(arr[1]);
        }
        DFT_NAME = joiner.toString();
    }
}

