/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.log.ILogger;
import io.polaris.core.log.support.Slf4jAwareLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class DynamicSlf4jAwareLogger
implements ILogger {
    private static final String FQCN = Slf4jAwareLogger.class.getName();
    private static final int TRACE_INT = 0;
    private static final int DEBUG_INT = 10;
    private static final int INFO_INT = 20;
    private static final int WARN_INT = 30;
    private static final int ERROR_INT = 40;
    private final Class<?> classLocationAwareLogger;
    private final Class<?> classMarker;
    private final Object instanceLogger;
    private final MethodHandle isTraceEnabled;
    private final MethodHandle isDebugEnabled;
    private final MethodHandle isInfoEnabled;
    private final MethodHandle isWarnEnabled;
    private final MethodHandle isErrorEnabled;
    private final MethodHandle log;

    public DynamicSlf4jAwareLogger(Class<?> classLocationAwareLogger, Class<?> classMarker, Object instanceLocationAwareLogger) throws NoSuchMethodException, IllegalAccessException {
        this.classLocationAwareLogger = classLocationAwareLogger;
        this.classMarker = classMarker;
        this.instanceLogger = instanceLocationAwareLogger;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.isTraceEnabled = lookup.findVirtual(classLocationAwareLogger, "isTraceEnabled", MethodType.methodType(Boolean.TYPE));
        this.isDebugEnabled = lookup.findVirtual(classLocationAwareLogger, "isDebugEnabled", MethodType.methodType(Boolean.TYPE));
        this.isInfoEnabled = lookup.findVirtual(classLocationAwareLogger, "isInfoEnabled", MethodType.methodType(Boolean.TYPE));
        this.isWarnEnabled = lookup.findVirtual(classLocationAwareLogger, "isWarnEnabled", MethodType.methodType(Boolean.TYPE));
        this.isErrorEnabled = lookup.findVirtual(classLocationAwareLogger, "isErrorEnabled", MethodType.methodType(Boolean.TYPE));
        this.log = lookup.findVirtual(classLocationAwareLogger, "log", MethodType.methodType(Void.TYPE, classMarker, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class));
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            return this.isTraceEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return this.isDebugEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isInfoEnabled() {
        try {
            return this.isInfoEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isWarnEnabled() {
        try {
            return this.isWarnEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isErrorEnabled() {
        try {
            return this.isErrorEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void trace(String msg) {
        this.trace("{}", new Object[]{msg}, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace("{}", new Object[]{msg}, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isTraceEnabled()) {
            try {
                this.log.invoke(this.instanceLogger, null, FQCN, 0, msg, arguments, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug("{}", new Object[]{msg}, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug("{}", new Object[]{msg}, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isDebugEnabled()) {
            try {
                this.log.invoke(this.instanceLogger, null, FQCN, 10, msg, arguments, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info("{}", new Object[]{msg}, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info("{}", new Object[]{msg}, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isInfoEnabled()) {
            try {
                this.log.invoke(this.instanceLogger, null, FQCN, 20, msg, arguments, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn("{}", new Object[]{msg}, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn("{}", new Object[]{msg}, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isWarnEnabled()) {
            try {
                this.log.invoke(this.instanceLogger, null, FQCN, 30, msg, arguments, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error("{}", new Object[]{msg}, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error("{}", new Object[]{msg}, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isErrorEnabled()) {
            try {
                this.log.invoke(this.instanceLogger, null, FQCN, 40, msg, arguments, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

