/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.log.ILogger;
import io.polaris.core.string.Strings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.slf4j.Logger;

public class DynamicSlf4jLogger
implements ILogger {
    private final Class<?> classLogger;
    private final Object instanceLogger;
    private final MethodHandle isTraceEnabled;
    private final MethodHandle isDebugEnabled;
    private final MethodHandle isInfoEnabled;
    private final MethodHandle isWarnEnabled;
    private final MethodHandle isErrorEnabled;
    private final MethodHandle trace1;
    private final MethodHandle trace2;
    private final MethodHandle trace3;
    private final MethodHandle debug1;
    private final MethodHandle debug2;
    private final MethodHandle debug3;
    private final MethodHandle info1;
    private final MethodHandle info2;
    private final MethodHandle info3;
    private final MethodHandle warn1;
    private final MethodHandle warn2;
    private final MethodHandle warn3;
    private final MethodHandle error1;
    private final MethodHandle error2;
    private final MethodHandle error3;
    private Logger log;

    public DynamicSlf4jLogger(Class<?> classLogger, Object instanceLogger) throws NoSuchMethodException, IllegalAccessException {
        this.classLogger = classLogger;
        this.instanceLogger = instanceLogger;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.isTraceEnabled = lookup.findVirtual(classLogger, "isTraceEnabled", MethodType.methodType(Boolean.TYPE));
        this.isDebugEnabled = lookup.findVirtual(classLogger, "isDebugEnabled", MethodType.methodType(Boolean.TYPE));
        this.isInfoEnabled = lookup.findVirtual(classLogger, "isInfoEnabled", MethodType.methodType(Boolean.TYPE));
        this.isWarnEnabled = lookup.findVirtual(classLogger, "isWarnEnabled", MethodType.methodType(Boolean.TYPE));
        this.isErrorEnabled = lookup.findVirtual(classLogger, "isErrorEnabled", MethodType.methodType(Boolean.TYPE));
        this.trace1 = lookup.findVirtual(classLogger, "trace", MethodType.methodType(Void.TYPE, String.class));
        this.trace2 = lookup.findVirtual(classLogger, "trace", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.trace3 = lookup.findVirtual(classLogger, "trace", MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        this.debug1 = lookup.findVirtual(classLogger, "debug", MethodType.methodType(Void.TYPE, String.class));
        this.debug2 = lookup.findVirtual(classLogger, "debug", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.debug3 = lookup.findVirtual(classLogger, "debug", MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        this.info1 = lookup.findVirtual(classLogger, "info", MethodType.methodType(Void.TYPE, String.class));
        this.info2 = lookup.findVirtual(classLogger, "info", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.info3 = lookup.findVirtual(classLogger, "info", MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        this.warn1 = lookup.findVirtual(classLogger, "warn", MethodType.methodType(Void.TYPE, String.class));
        this.warn2 = lookup.findVirtual(classLogger, "warn", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.warn3 = lookup.findVirtual(classLogger, "warn", MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        this.error1 = lookup.findVirtual(classLogger, "error", MethodType.methodType(Void.TYPE, String.class));
        this.error2 = lookup.findVirtual(classLogger, "error", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.error3 = lookup.findVirtual(classLogger, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class));
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            return this.isTraceEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return this.isDebugEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isInfoEnabled() {
        try {
            return this.isInfoEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isWarnEnabled() {
        try {
            return this.isWarnEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isErrorEnabled() {
        try {
            return this.isErrorEnabled.invoke(this.instanceLogger);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void trace(String msg) {
        this.trace(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isTraceEnabled()) {
            try {
                if (t == null) {
                    if (arguments == null || arguments.length == 0) {
                        this.trace1.invoke(this.instanceLogger, msg);
                    } else {
                        this.trace2.invoke(this.instanceLogger, msg, arguments);
                    }
                } else if (arguments == null || arguments.length == 0) {
                    this.trace3.invoke(this.instanceLogger, msg, t);
                } else {
                    this.trace3.invoke(this.instanceLogger, Strings.format(msg, arguments), t);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isDebugEnabled()) {
            try {
                if (t == null) {
                    if (arguments == null || arguments.length == 0) {
                        this.debug1.invoke(this.instanceLogger, msg);
                    } else {
                        this.debug2.invoke(this.instanceLogger, msg, arguments);
                    }
                } else if (arguments == null || arguments.length == 0) {
                    this.debug3.invoke(this.instanceLogger, msg, t);
                } else {
                    this.debug3.invoke(this.instanceLogger, Strings.format(msg, arguments), t);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isInfoEnabled()) {
            try {
                if (t == null) {
                    if (arguments == null || arguments.length == 0) {
                        this.info1.invoke(this.instanceLogger, msg);
                    } else {
                        this.info2.invoke(this.instanceLogger, msg, arguments);
                    }
                } else if (arguments == null || arguments.length == 0) {
                    this.info3.invoke(this.instanceLogger, msg, t);
                } else {
                    this.info3.invoke(this.instanceLogger, Strings.format(msg, arguments), t);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isWarnEnabled()) {
            try {
                if (t == null) {
                    if (arguments == null || arguments.length == 0) {
                        this.warn1.invoke(this.instanceLogger, msg);
                    } else {
                        this.warn2.invoke(this.instanceLogger, msg, arguments);
                    }
                } else if (arguments == null || arguments.length == 0) {
                    this.warn3.invoke(this.instanceLogger, msg, t);
                } else {
                    this.warn3.invoke(this.instanceLogger, Strings.format(msg, arguments), t);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        if (this.instanceLogger != null && this.isErrorEnabled()) {
            try {
                if (t == null) {
                    if (arguments == null || arguments.length == 0) {
                        this.error1.invoke(this.instanceLogger, msg);
                    } else {
                        this.error2.invoke(this.instanceLogger, msg, arguments);
                    }
                } else if (arguments == null || arguments.length == 0) {
                    this.error3.invoke(this.instanceLogger, msg, t);
                } else {
                    this.error3.invoke(this.instanceLogger, Strings.format(msg, arguments), t);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

