/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.log.ILogger;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jAwareLogger
implements ILogger {
    private static final String FQCN = Slf4jAwareLogger.class.getName();
    private LocationAwareLogger log;

    public Slf4jAwareLogger(LocationAwareLogger log) {
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public void trace(String msg) {
        this.trace("{}", new Object[]{msg}, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace("{}", new Object[]{msg}, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.log(null, FQCN, 0, msg, arguments, t);
        }
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug("{}", new Object[]{msg}, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug("{}", new Object[]{msg}, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.log(null, FQCN, 10, msg, arguments, t);
        }
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info("{}", new Object[]{msg}, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info("{}", new Object[]{msg}, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.log(null, FQCN, 20, msg, arguments, t);
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn("{}", new Object[]{msg}, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn("{}", new Object[]{msg}, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isWarnEnabled()) {
            this.log.log(null, FQCN, 30, msg, arguments, t);
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error("{}", new Object[]{msg}, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error("{}", new Object[]{msg}, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isErrorEnabled()) {
            this.log.log(null, FQCN, 40, msg, arguments, t);
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

