/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.collection.ObjectArrays;
import io.polaris.core.log.ILogger;
import io.polaris.core.string.Strings;
import org.slf4j.Logger;

public class Slf4jLogger
implements ILogger {
    private Logger log;

    public Slf4jLogger(Logger log) {
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public void trace(String msg) {
        this.trace(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        this.trace(msg, arguments, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.trace(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void trace(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isTraceEnabled()) {
            if (t == null) {
                if (arguments == null || arguments.length == 0) {
                    this.log.trace(msg);
                } else {
                    this.log.trace(msg, arguments);
                }
            } else if (arguments == null || arguments.length == 0) {
                this.log.trace(msg, t);
            } else {
                this.log.trace(Strings.format(msg, arguments), t);
            }
        }
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arguments) {
        this.trace(msg, arguments, t);
    }

    @Override
    public void debug(String msg) {
        this.debug(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        this.debug(msg, arguments, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.debug(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void debug(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isDebugEnabled()) {
            if (t == null) {
                if (arguments == null || arguments.length == 0) {
                    this.log.debug(msg);
                } else {
                    this.log.debug(msg, arguments);
                }
            } else if (arguments == null || arguments.length == 0) {
                this.log.debug(msg, t);
            } else {
                this.log.debug(Strings.format(msg, arguments), t);
            }
        }
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arguments) {
        this.debug(msg, arguments, t);
    }

    @Override
    public void info(String msg) {
        this.info(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        this.info(msg, arguments, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.info(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void info(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isInfoEnabled()) {
            if (t == null) {
                if (arguments == null || arguments.length == 0) {
                    this.log.info(msg);
                } else {
                    this.log.info(msg, arguments);
                }
            } else if (arguments == null || arguments.length == 0) {
                this.log.info(msg, t);
            } else {
                this.log.info(Strings.format(msg, arguments), t);
            }
        }
    }

    @Override
    public void info(Throwable t, String msg, Object ... arguments) {
        this.info(msg, arguments, t);
    }

    @Override
    public void warn(String msg) {
        this.warn(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        this.warn(msg, arguments, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.warn(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void warn(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isWarnEnabled()) {
            if (t == null) {
                if (arguments == null || arguments.length == 0) {
                    this.log.warn(msg);
                } else {
                    this.log.warn(msg, arguments);
                }
            } else if (arguments == null || arguments.length == 0) {
                this.log.warn(msg, t);
            } else {
                this.log.warn(Strings.format(msg, arguments), t);
            }
        }
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arguments) {
        this.warn(msg, arguments, t);
    }

    @Override
    public void error(String msg) {
        this.error(msg, ObjectArrays.EMPTY, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        this.error(msg, arguments, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.error(msg, ObjectArrays.EMPTY, t);
    }

    @Override
    public void error(String msg, Object[] arguments, Throwable t) {
        if (this.log != null && this.log.isErrorEnabled()) {
            if (t == null) {
                if (arguments == null || arguments.length == 0) {
                    this.log.error(msg);
                } else {
                    this.log.error(msg, arguments);
                }
            } else if (arguments == null || arguments.length == 0) {
                this.log.error(msg, t);
            } else {
                this.log.error(Strings.format(msg, arguments), t);
            }
        }
    }

    @Override
    public void error(Throwable t, String msg, Object ... arguments) {
        this.error(msg, arguments, t);
    }
}

