/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.log.support.IStack;
import org.slf4j.MDC;

class Slf4jStack
implements IStack {
    public static final String DELIMITER = "|";
    public static final String STACK_KEY = "MSG";

    Slf4jStack() {
    }

    @Override
    public void put(String key, String val) {
        MDC.put((String)key, (String)val);
    }

    @Override
    public String get(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void remove(String key) {
        MDC.remove((String)key);
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public void push(String msg) {
        String old = MDC.get((String)STACK_KEY);
        if (old == null || old.trim().length() == 0) {
            MDC.put((String)STACK_KEY, (String)msg);
        } else if (!old.contains(msg)) {
            MDC.put((String)STACK_KEY, (String)(old + DELIMITER + msg));
        }
    }

    @Override
    public String pop() {
        String old = MDC.get((String)STACK_KEY);
        if (old == null || old.trim().length() == 0) {
            return "";
        }
        int i = (old = old.trim()).lastIndexOf(DELIMITER);
        if (i >= 0) {
            String pop = old.substring(i + 1).trim();
            String msg = old.substring(0, i).trim();
            if (msg == null || msg.trim().length() == 0) {
                MDC.remove((String)STACK_KEY);
            } else {
                MDC.put((String)STACK_KEY, (String)msg);
            }
            return pop;
        }
        MDC.remove((String)STACK_KEY);
        return old;
    }

    @Override
    public String peek() {
        String old = MDC.get((String)STACK_KEY);
        if (old == null || old.trim().length() == 0) {
            return "";
        }
        int i = (old = old.trim()).lastIndexOf(DELIMITER);
        if (i >= 0) {
            String pop = old.substring(i + 1).trim();
            return pop;
        }
        return old;
    }
}

