/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.map.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class BaseMultiMap<K, V, E extends Collection<V>>
implements MultiMap<K, V, E> {
    protected final Map<K, E> raw;
    protected final Supplier<E> supplier;

    public BaseMultiMap(Map<K, E> raw, Supplier<E> supplier) {
        this.raw = raw;
        this.supplier = supplier;
    }

    public String toString() {
        return this.raw.toString();
    }

    @Override
    public E putAll(K key, V[] values) {
        return this.putAll(key, Arrays.asList(values));
    }

    @Override
    public E putAll(K key, Iterable<V> values) {
        E vs = null;
        for (V value : values) {
            vs = this.putOne(key, value);
        }
        return vs;
    }

    @Override
    public boolean removeOne(K key, V value) {
        Object vs = this.get(key);
        if (vs != null) {
            boolean rs = vs.remove(value);
            if (vs.isEmpty()) {
                this.remove(key);
            }
            return rs;
        }
        return false;
    }

    @Override
    public boolean containsOneValue(Object value) {
        Iterator<Map.Entry<K, E>> i = this.entrySet().iterator();
        if (value == null) {
            while (i.hasNext()) {
                Map.Entry<K, E> e = i.next();
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Map.Entry<K, E> e = i.next();
                if (!((Collection)e.getValue()).contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.raw.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.raw.containsValue(value);
    }

    @Override
    public E get(Object key) {
        return (E)((Collection)this.raw.get(key));
    }

    @Override
    public E put(K key, E value) {
        return (E)((Collection)this.raw.put(key, value));
    }

    @Override
    public E remove(Object key) {
        return (E)((Collection)this.raw.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> m) {
        this.raw.putAll(m);
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.raw.keySet();
    }

    @Override
    public Collection<E> values() {
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        return this.raw.entrySet();
    }
}

