/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.map.TransformMap;
import io.polaris.core.string.StringCases;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class CasePascalMap<K, V>
extends TransformMap<K, V> {
    private static final Function TRANSFORMER = key -> key instanceof CharSequence ? StringCases.underlineToPascalCase((CharSequence)key) : key;

    public CasePascalMap(Supplier<Map<K, V>> supplier) {
        super(supplier, TRANSFORMER);
    }

    public CasePascalMap() {
        super(new LinkedHashMap(), TRANSFORMER);
    }

    public CasePascalMap(Supplier<Map<K, V>> supplier, Map<K, V> raw) {
        this(supplier);
        super.addRawData(raw);
    }

    public CasePascalMap(Map<K, V> raw) {
        this();
        super.addRawData(raw);
    }

    private void addRawData(Map<K, V> raw) {
        for (Map.Entry<K, V> entry : raw.entrySet()) {
            this.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }
}

