/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.map.reference.ReferenceType;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class KeyReferenceMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final BiFunction<K, ReferenceQueue<K>, Reference<K>> referenceFactory;
    private final Map<Reference<K>, V> raw;
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    public KeyReferenceMap(Map<Reference<K>, V> raw, BiFunction<K, ReferenceQueue<K>, Reference<K>> referenceFactory) {
        this.raw = raw;
        this.referenceFactory = referenceFactory;
    }

    public KeyReferenceMap(Map<Reference<K>, V> raw, ReferenceType referenceType) {
        this.raw = raw;
        this.referenceFactory = referenceType::buildKeyReference;
    }

    public KeyReferenceMap(Supplier<Map<Reference<K>, V>> supplier, ReferenceType referenceType) {
        this(supplier.get(), referenceType);
    }

    private Reference<K> buildKeyReference(K key) {
        return this.referenceFactory.apply(key, this.queue);
    }

    private void processQueue() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            this.raw.remove(ref);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.containsKey(this.buildKeyReference(key));
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.get(this.buildKeyReference(key));
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.put(this.buildKeyReference(key), value);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.raw.remove(this.buildKeyReference(key));
    }

    @Override
    public void clear() {
        this.processQueue();
        this.raw.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        this.processQueue();
        if (this.raw.isEmpty()) {
            return Collections.emptyMap().entrySet();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<Reference<K>, V> entry : this.raw.entrySet()) {
            K key;
            V value = entry.getValue();
            if (value == null || (key = entry.getKey().get()) == null) continue;
            map.put(key, value);
        }
        return map.entrySet();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.processQueue();
        this.raw.replaceAll((k, v) -> function.apply((Object)k.get(), (Object)v));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return this.raw.putIfAbsent(keyRef, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        Reference<Object> keyRef = this.buildKeyReference(key);
        return this.raw.remove(keyRef, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return this.raw.replace(keyRef, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return this.raw.replace(keyRef, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return (V)this.raw.computeIfAbsent(keyRef, k -> mappingFunction.apply((Object)k.get()));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return (V)this.raw.computeIfPresent(keyRef, (k, v) -> remappingFunction.apply((Object)k.get(), (Object)v));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return (V)this.raw.compute(keyRef, (k, v) -> remappingFunction.apply((Object)k.get(), (Object)v));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.processQueue();
        Reference<K> keyRef = this.buildKeyReference(key);
        return (V)this.raw.merge(keyRef, value, (v1, v2) -> remappingFunction.apply((Object)v1, (Object)v2));
    }
}

