/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map.reference;

import io.polaris.core.map.reference.SoftKeyReference;
import io.polaris.core.map.reference.SoftValueReference;
import io.polaris.core.map.reference.ValueReference;
import io.polaris.core.map.reference.WeakKeyReference;
import io.polaris.core.map.reference.WeakValueReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public enum ReferenceType {
    SOFT,
    WEAK;


    public <K, V> ValueReference<K, V> buildValueReference(K key, V value, ReferenceQueue<V> queue) {
        if (this == SOFT) {
            return new SoftValueReference<K, V>(key, value, queue);
        }
        if (this == WEAK) {
            return new WeakValueReference<K, V>(key, value, queue);
        }
        throw new IllegalStateException();
    }

    public <K> Reference<K> buildKeyReference(K key, ReferenceQueue<K> queue) {
        if (this == SOFT) {
            return new SoftKeyReference<K>(key, queue);
        }
        if (this == WEAK) {
            return new WeakKeyReference<K>(key, queue);
        }
        throw new IllegalStateException();
    }
}

