/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.msg;

import io.polaris.core.msg.MessageResource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageResources {
    public static final String DEFAULT_MESSAGE_BASE_NAME = "msg,i18n,error,ValidationMessages";
    private static final Map<String, MessageResource> resources = new ConcurrentHashMap<String, MessageResource>();
    private static MessageResource defaultMessageResource = MessageResources.getMessageResource("msg,i18n,error,ValidationMessages");

    public static MessageResource getMessageResource(String baseName) {
        return resources.computeIfAbsent(baseName, k -> new MessageResource(baseName));
    }

    public static MessageResource getDefaultMessageResource() {
        return defaultMessageResource;
    }

    public static void setDefaultMessageResource(MessageResource defaultMessageResource) {
        if (defaultMessageResource == null) {
            throw new IllegalArgumentException();
        }
        MessageResources.defaultMessageResource = defaultMessageResource;
    }
}

