/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.os;

import io.polaris.core.os.JMapHistoInfo;
import io.polaris.core.os.JStackThreadInfo;
import io.polaris.core.os.OS;
import io.polaris.core.regex.Patterns;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JShells {
    public static List<JMapHistoInfo> getJMapHistoInfo() {
        return JShells.getJMapHistoInfo(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JMapHistoInfo> getJMapHistoInfo(int maxSize) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"jmap", "-histo", String.valueOf(OS.getPid())});
            InputStream stdin = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(stdin, StandardCharsets.UTF_8));
            ArrayList<JMapHistoInfo> list = new ArrayList<JMapHistoInfo>(Math.min(Math.max(128, maxSize), 16384));
            int size = 0;
            String line = br.readLine();
            while (line != null) {
                Pattern pattern;
                Matcher matcher;
                line = line.trim();
                if (size < maxSize && (matcher = (pattern = Patterns.getPattern("(\\d+):\\s+(\\d+)\\s+(\\d+)\\s+([^\\s]+)")).matcher(line)).find()) {
                    JMapHistoInfo info = new JMapHistoInfo();
                    info.setNum(Integer.parseInt(matcher.group(1)));
                    info.setInstances(Integer.parseInt(matcher.group(2)));
                    info.setBytes(Long.parseLong(matcher.group(3)));
                    info.setClassName(matcher.group(4));
                    list.add(info);
                    ++size;
                }
                line = br.readLine();
            }
            process.waitFor();
            ArrayList<JMapHistoInfo> arrayList = list;
            return arrayList;
        }
        catch (Exception ignore) {
            List<JMapHistoInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JStackThreadInfo> getJStackInfo() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"jstack", "-l", String.valueOf(OS.getPid())});
            InputStream stdin = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(stdin, StandardCharsets.UTF_8));
            ArrayList<JStackThreadInfo> stackThreadInfoList = new ArrayList<JStackThreadInfo>(128);
            StringBuilder traceHeadBuilder = new StringBuilder();
            StringBuilder traceBodyBuilder = new StringBuilder();
            boolean inTraceBody = false;
            JStackThreadInfo stackThreadInfo = null;
            String line = br.readLine();
            while (line != null) {
                line = line.trim();
                Pattern pattern = Patterns.getPattern("\"(.+)\"(?:\\s*#(\\d+))(?:\\s*(daemon))?(?:\\s*prio=(\\d+))(?:\\s*os_prio=(\\d+))(?:\\s*tid=([\\w]+))(?:\\s*nid=([\\w]+))");
                Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    String nid;
                    String tid;
                    String osPrio;
                    String prio;
                    String daemon;
                    if (stackThreadInfo != null) {
                        stackThreadInfo.setStackTrace(traceBodyBuilder.toString());
                        stackThreadInfo.setStackTraceHeader(traceHeadBuilder.toString());
                    }
                    stackThreadInfo = new JStackThreadInfo();
                    stackThreadInfoList.add(stackThreadInfo);
                    inTraceBody = false;
                    traceHeadBuilder.setLength(0);
                    traceBodyBuilder.setLength(0);
                    String threadName = matcher.group(1);
                    stackThreadInfo.setThreadName(threadName);
                    String threadId = matcher.group(2);
                    if (threadId != null && threadId.length() > 0) {
                        stackThreadInfo.setThreadId(Long.parseLong(threadId));
                    }
                    if ((daemon = matcher.group(3)) != null && daemon.length() > 0) {
                        stackThreadInfo.setDaemon(true);
                    }
                    if ((prio = matcher.group(4)) != null && prio.length() > 0) {
                        stackThreadInfo.setPriority(Integer.parseInt(prio));
                    }
                    if ((osPrio = matcher.group(5)) != null && osPrio.length() > 0) {
                        stackThreadInfo.setOsPriority(Integer.parseInt(osPrio));
                    }
                    if ((tid = matcher.group(6)) != null && tid.length() > 0) {
                        stackThreadInfo.setTid(tid);
                    }
                    if ((nid = matcher.group(7)) != null && nid.length() > 0) {
                        stackThreadInfo.setNid(nid);
                        stackThreadInfo.setPid(Integer.parseInt(nid.replace("0x", ""), 16));
                    }
                } else if (line.startsWith("at")) {
                    inTraceBody = true;
                }
                if (stackThreadInfo != null) {
                    if (inTraceBody) {
                        traceBodyBuilder.append(line).append("\n");
                    } else {
                        traceHeadBuilder.append(line).append("\n");
                    }
                }
                line = br.readLine();
            }
            if (stackThreadInfo != null) {
                stackThreadInfo.setStackTrace(traceBodyBuilder.toString());
                stackThreadInfo.setStackTraceHeader(traceHeadBuilder.toString());
            }
            process.waitFor();
            ArrayList<JStackThreadInfo> arrayList = stackThreadInfoList;
            return arrayList;
        }
        catch (Exception ignore) {
            List<JStackThreadInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }
}

