/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service;

import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.service.Service;
import io.polaris.core.service.ServiceDefault;
import io.polaris.core.service.ServiceName;
import io.polaris.core.service.ServiceOrder;
import io.polaris.core.service.ServiceProperties;
import io.polaris.core.service.ServiceProperty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceLoader<S>
implements Iterable<Service<S>> {
    private static final ILogger log = ILoggers.of(ServiceLoader.class);
    public static final String[] PREFIX = new String[]{"META-INF/services/"};
    private final Class<S> type;
    private final ClassLoader loader;
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private List<Service<S>> providers;
    private List<Service<S>> wrappers;
    private Map<String, Service<S>> namings;

    public ServiceLoader(Class<S> type, ClassLoader loader) {
        this.type = type;
        this.loader = loader == null ? ServiceLoader.defaultClassLoader() : loader;
    }

    public ServiceLoader(Class<S> type) {
        this(type, ServiceLoader.defaultClassLoader());
    }

    public static <S> ServiceLoader<S> of(Class<S> type) {
        return new ServiceLoader<S>(type);
    }

    public static <S> ServiceLoader<S> of(Class<S> type, ClassLoader loader) {
        return new ServiceLoader<S>(type, loader);
    }

    public static ClassLoader defaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ServiceLoader.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public List<Service<S>> getProviders() {
        this.load();
        return this.providers;
    }

    public Map<String, Service<S>> getNamings() {
        this.load();
        return this.namings;
    }

    @Override
    public Iterator<Service<S>> iterator() {
        this.load();
        return this.providers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (!this.loaded.get()) {
            ServiceLoader serviceLoader = this;
            synchronized (serviceLoader) {
                if (!this.loaded.get()) {
                    this.loadClasses();
                    this.loaded.set(true);
                }
            }
        }
    }

    private void loadClasses() {
        ArrayList<Class<S>> classes = new ArrayList<Class<S>>();
        this.loadDirectory(classes);
        ArrayList<Service> services = new ArrayList<Service>();
        ArrayList<Service> wrappers = new ArrayList<Service>();
        HashMap<String, Service> namings = new HashMap<String, Service>();
        if (!classes.isEmpty()) {
            ArrayList<Service<Object>> ordered = new ArrayList<Service<Object>>();
            ArrayList<Service<Object>> others = new ArrayList<Service<Object>>();
            ArrayList<Service<Object>> defaults = new ArrayList<Service<Object>>();
            Function<Object, Object> wrapperBuilder = instance -> {
                if (this.wrappers != null && !this.wrappers.isEmpty()) {
                    int count = this.wrappers.size();
                    for (int i = count - 1; i >= 0; --i) {
                        Service<S> wrapper = this.wrappers.get(i);
                        instance = wrapper.newPureInstance(new Class[]{this.type}, new Object[]{instance});
                    }
                }
                return instance;
            };
            List[] listArray = classes.iterator();
            while (listArray.hasNext()) {
                Class o;
                Class clazz = o = (Class)listArray.next();
                Map<String, String> properties = new HashMap<String, String>();
                String serviceName = null;
                if (clazz.isAnnotationPresent(ServiceName.class)) {
                    serviceName = clazz.getAnnotation(ServiceName.class).value();
                    properties.put("name", serviceName);
                }
                if (clazz.isAnnotationPresent(ServiceProperties.class)) {
                    ServiceProperties annos = clazz.getAnnotation(ServiceProperties.class);
                    for (ServiceProperty anno : annos.value()) {
                        properties.put(anno.name(), anno.value());
                    }
                }
                if (clazz.isAnnotationPresent(ServiceProperty.class)) {
                    ServiceProperty anno = clazz.getAnnotation(ServiceProperty.class);
                    properties.put(anno.name(), anno.value());
                }
                Map<Object, Object> map = properties = properties.isEmpty() ? null : Collections.unmodifiableMap(properties);
                if (clazz.isAnnotationPresent(ServiceOrder.class)) {
                    int order = clazz.getAnnotation(ServiceOrder.class).value();
                    ordered.add(new Service<Object>(clazz, properties, serviceName, order, wrapperBuilder));
                    continue;
                }
                if (clazz.isAnnotationPresent(ServiceDefault.class)) {
                    int order = clazz.getAnnotation(ServiceDefault.class).value();
                    defaults.add(new Service<Object>(clazz, properties, serviceName, order, wrapperBuilder));
                    continue;
                }
                others.add(new Service<Object>(clazz, properties, serviceName, 0, wrapperBuilder));
            }
            Collections.sort(ordered, Service.defaultComparator);
            Collections.sort(others, Service.defaultComparator);
            Collections.sort(defaults, Service.defaultComparator);
            for (List list : new List[]{ordered, others, defaults}) {
                for (Service service : list) {
                    if (this.isWrapper(service.getServiceClass())) {
                        wrappers.add(service);
                        continue;
                    }
                    services.add(service);
                    if (service.getServiceName() == null) continue;
                    namings.putIfAbsent(service.getServiceName(), service);
                }
            }
        }
        this.providers = Collections.unmodifiableList(services);
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.namings = Collections.unmodifiableMap(namings);
    }

    private void loadDirectory(List<Class<S>> classes) {
        String typeName = this.type.getName();
        for (String dir : PREFIX) {
            String filename = dir + typeName;
            try {
                Enumeration<URL> urls = this.loader.getResources(filename);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResources(classes, url);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean isWrapper(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != this.type) continue;
            return true;
        }
        return false;
    }

    private void loadResources(List<Class<S>> classes, URL url) throws IOException {
        try (InputStream in = url.openStream();){
            BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim().replaceAll("#.*", "")).length() > 0 && !line.startsWith("#")) {
                    try {
                        Class<?> clazz = Class.forName(line, true, this.loader);
                        if (this.type.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        } else {
                            log.warn("\u52a0\u8f7d\u670d\u52a1\u7c7b\u5931\u8d25\uff0c\u7c7b\u578b\u4e0d\u5339\u914d\uff1a" + line);
                        }
                    }
                    catch (Throwable e) {
                        log.warn("\u52a0\u8f7d\u670d\u52a1\u7c7b\u5931\u8d25\uff1a" + line, e);
                    }
                }
                line = br.readLine();
            }
        }
        catch (Throwable e) {
            log.warn("\u52a0\u8f7d\u670d\u52a1\u7c7b\u5931\u8d25\uff0c\u8d44\u6e90\u8bfb\u53d6\u9519\u8bef\uff1a" + url, e);
        }
    }

    @Nullable
    private S getSingleton(@Nullable Service<S> s) {
        return Optional.ofNullable(s).map(Service::getSingleton).orElse(null);
    }

    @Nullable
    private S getPureSingleton(@Nullable Service<S> s) {
        return Optional.ofNullable(s).map(Service::getPureSingleton).orElse(null);
    }

    @Nullable
    public Service<S> get() {
        this.load();
        return this.providers.isEmpty() ? null : this.providers.get(0);
    }

    @Nullable
    public S getSingleton() {
        return this.getSingleton(this.get());
    }

    @Nullable
    public S getPureSingleton() {
        return this.getPureSingleton(this.get());
    }

    @Nullable
    public Service<S> get(String name) {
        this.load();
        return this.namings.get(name);
    }

    @Nullable
    public S getSingleton(String name) {
        return this.getSingleton(this.get(name));
    }

    @Nullable
    public S getPureSingleton(String name) {
        return this.getPureSingleton(this.get(name));
    }

    @Nullable
    public Service<S> get(String propertyName, String propertyValue) {
        this.load();
        for (Service<S> service : this.providers) {
            String value = service.getProperty(propertyName);
            if (!Objects.equals(propertyValue, value)) continue;
            return service;
        }
        return null;
    }

    @Nullable
    public S getSingleton(String propertyName, String propertyValue) {
        return this.getSingleton(this.get(propertyName, propertyValue));
    }

    @Nullable
    public S getPureSingleton(String propertyName, String propertyValue) {
        return this.getPureSingleton(this.get(propertyName, propertyValue));
    }

    @Nullable
    public Service<S> get(@Nonnull Function<Service<S>, Boolean> matcher) {
        this.load();
        for (Service<S> service : this.providers) {
            if (!matcher.apply(service).booleanValue()) continue;
            return service;
        }
        return null;
    }

    @Nullable
    public S getSingleton(@Nonnull Function<Service<S>, Boolean> matcher) {
        return this.getSingleton(this.get(matcher));
    }

    @Nullable
    public S getPureSingleton(@Nonnull Function<Service<S>, Boolean> matcher) {
        return this.getPureSingleton(this.get(matcher));
    }

    public void reload() {
        this.loaded.set(false);
        this.load();
    }
}

