/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service.provider;

import io.polaris.core.service.StatefulServiceLoader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ServiceListProvider<S>
implements Iterable<S> {
    private final Supplier<List<S>> factory;
    private volatile boolean initialized = false;
    private List<S> service;

    public ServiceListProvider(Supplier<List<S>> factory) {
        this.factory = factory;
    }

    public static <S> ServiceListProvider<S> of(Supplier<List<S>> factory) {
        return new ServiceListProvider<S>(factory);
    }

    public static <S> ServiceListProvider<S> of(Class<S> clazz) {
        return new ServiceListProvider<S>(() -> StatefulServiceLoader.load(clazz).serviceList());
    }

    public Optional<List<S>> optional() {
        return Optional.ofNullable(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<S> get() {
        if (!this.initialized) {
            ServiceListProvider serviceListProvider = this;
            synchronized (serviceListProvider) {
                if (!this.initialized) {
                    this.service = this.factory.get();
                    if (this.service == null) {
                        this.service = Collections.emptyList();
                    }
                    this.initialized = true;
                }
            }
        }
        return this.service;
    }

    @Override
    public Iterator<S> iterator() {
        return this.get().iterator();
    }
}

