/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service.provider;

import io.polaris.core.service.StatefulServiceLoader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class ServiceMapProvider<S>
implements Iterable<Map.Entry<String, S>> {
    private final Supplier<Map<String, S>> factory;
    private volatile boolean initialized = false;
    private Map<String, S> service;

    public ServiceMapProvider(Supplier<Map<String, S>> factory) {
        this.factory = factory;
    }

    public static <S> ServiceMapProvider<S> of(Supplier<Map<String, S>> factory) {
        return new ServiceMapProvider<S>(factory);
    }

    public static <S> ServiceMapProvider<S> of(Class<S> clazz) {
        Supplier<Map<String, S>> supplier = () -> StatefulServiceLoader.load(clazz).serviceMap();
        return new ServiceMapProvider<S>(supplier);
    }

    public Optional<Map<String, S>> optional() {
        return Optional.ofNullable(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, S> get() {
        if (!this.initialized) {
            ServiceMapProvider serviceMapProvider = this;
            synchronized (serviceMapProvider) {
                if (!this.initialized) {
                    this.service = this.factory.get();
                    if (this.service == null) {
                        this.service = Collections.emptyMap();
                    }
                    this.initialized = true;
                }
            }
        }
        return this.service;
    }

    @Override
    public Iterator<Map.Entry<String, S>> iterator() {
        return this.get().entrySet().iterator();
    }

    public Set<Map.Entry<String, S>> entrySet() {
        return this.get().entrySet();
    }
}

