/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.statistics;

import io.polaris.core.concurrent.PooledThreadFactory;
import io.polaris.core.statistics.EventStatistics;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class SlidingWindow<S extends EventStatistics<S>> {
    private final int maxDuration;
    private final int windowMills;
    private final Deque<Item> queue;
    private final Supplier<S> supplier;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final ReentrantLock itemLock = new ReentrantLock();
    private final ReentrantLock summaryLock = new ReentrantLock();
    private final S summary;
    private ScheduledExecutorService scheduler;

    public SlidingWindow(int windowSize, int windowTime, TimeUnit timeUnit, Supplier<S> supplier) {
        this(windowSize, (int)timeUnit.toMillis(windowTime), supplier);
    }

    public SlidingWindow(int windowSize, int windowMills, Supplier<S> supplier) {
        this.windowMills = windowMills;
        this.queue = new ArrayDeque<Item>(windowSize);
        this.supplier = supplier;
        this.maxDuration = windowSize * windowMills;
        this.summary = (EventStatistics)supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startScheduler() {
        if (this.scheduler != null) {
            return false;
        }
        SlidingWindow slidingWindow = this;
        synchronized (slidingWindow) {
            ScheduledExecutorService scheduler;
            if (this.scheduler != null) {
                return false;
            }
            this.scheduler = scheduler = Executors.newScheduledThreadPool(1, new PooledThreadFactory("SlidingWindow"));
            scheduler.scheduleAtFixedRate(() -> {
                long currentTime = System.currentTimeMillis();
                long timestamp = currentTime / (long)this.windowMills * (long)this.windowMills;
                this.cleanup(timestamp);
            }, this.maxDuration, this.maxDuration, TimeUnit.NANOSECONDS);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(long timestamp) {
        this.queueLock.lock();
        try {
            Item first = this.queue.peekFirst();
            while (first != null && first.timestamp < timestamp - (long)this.maxDuration) {
                this.queue.pollFirst();
                this.summaryLock.lock();
                try {
                    this.summary.minus((EventStatistics)first.statistics);
                }
                finally {
                    this.summaryLock.unlock();
                }
                first = this.queue.peekFirst();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(long currentTime, Object event) {
        long timestamp = currentTime / (long)this.windowMills * (long)this.windowMills;
        Item item = this.queue.peekLast();
        if (item == null || timestamp > item.timestamp) {
            this.queueLock.lock();
            try {
                item = this.queue.peekLast();
                if (item == null || timestamp > item.timestamp) {
                    item = new Item(this, timestamp, (EventStatistics)this.supplier.get());
                    while (!this.queue.offerLast(item)) {
                        Item first = this.queue.pollFirst();
                        if (first == null) continue;
                        this.summaryLock.lock();
                        try {
                            this.summary.minus((EventStatistics)first.statistics);
                        }
                        finally {
                            this.summaryLock.unlock();
                        }
                    }
                    this.cleanup(timestamp);
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
        this.itemLock.lock();
        try {
            item.receive(event);
        }
        finally {
            this.itemLock.unlock();
        }
        this.summaryLock.lock();
        try {
            this.summary.receive(event);
        }
        finally {
            this.summaryLock.unlock();
        }
    }

    public S summary() {
        return this.summary.clone();
    }

    public List<S> get() {
        ArrayList<EventStatistics> list = new ArrayList<EventStatistics>();
        for (Item item : this.queue) {
            list.add(item.statistics);
        }
        return list;
    }

    private class Item {
        private final long timestamp;
        private final S statistics;
        final /* synthetic */ SlidingWindow this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Item(long statistics, S s) {
            void timestamp;
            this.this$0 = (SlidingWindow)l;
            this.timestamp = timestamp;
            this.statistics = statistics;
        }

        public void receive(Object event) {
            this.statistics.receive(event);
        }
    }
}

