/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.xml;

import io.polaris.core.io.IO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Jaxb {
    public static String toXml(Object bean) {
        return Jaxb.toXml(bean, StandardCharsets.UTF_8, true);
    }

    public static String toXml(Object bean, Charset charset, boolean format) {
        StringWriter writer;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            writer = new StringWriter();
            marshaller.marshal(bean, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static <T> T toBean(String xml, Class<T> c) {
        return Jaxb.toBean(new StringReader(xml), c);
    }

    public static <T> T toBean(File file, Charset charset, Class<T> c) throws IOException {
        return Jaxb.toBean(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)), c);
    }

    public static <T> T toBean(Reader reader, Class<T> c) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(reader);
            return (T)object;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            IO.close(reader);
        }
    }
}

