/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.proxy;

import io.polaris.core.asm.proxy.Interceptor;
import io.polaris.core.asm.proxy.Invocation;
import io.polaris.core.asm.proxy.Invoker;
import java.lang.reflect.Method;

public class BulkInvocation
implements Invocation {
    private final int index;
    private final Object proxy;
    private final Method method;
    private final Invoker rawInvoker;
    private final Invoker superInvoker;
    private final Interceptor[] interceptors;
    private int cursor = 0;

    public BulkInvocation(int index, Object proxy, Method method, Invoker rawInvoker, Invoker superInvoker, Interceptor[] interceptors) {
        this.index = index;
        this.proxy = proxy;
        this.method = method;
        this.rawInvoker = rawInvoker;
        this.superInvoker = superInvoker;
        this.interceptors = interceptors;
    }

    @Override
    public Object invoke(Object obj, Object[] args) throws Throwable {
        if (this.cursor < this.interceptors.length) {
            return this.interceptors[this.cursor++].intercept(obj, this.method, args, this);
        }
        if (this.proxy != obj) {
            return this.rawInvoker.invoke(this.index, obj, args);
        }
        return this.superInvoker.invoke(this.index, obj, args);
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }
}

