/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.lang.Types;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.reflect.SerializableConsumerWithArgs4;
import io.polaris.core.reflect.SerializableFunction;
import io.polaris.core.reflect.SerializableFunctionWithArgs5;
import io.polaris.core.reflect.SerializableTriFunction;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ClassAccess<T> {
    private static final AccessClassPool<Class, ClassAccess> pool = new AccessClassPool();
    private static ILogger log = ILoggers.of(ClassAccess.class);
    private final int defaultConstructorIndex;
    private final Class[][] constructorParamTypes = this.buildConstructorParamTypes();
    private final String[] methodNames;
    private final Class[][][] methodParamTypes;
    private final String[] fieldNames;
    private final Class[] fieldTypes;
    private final Map<String, Integer> methodIndices;
    private final Map<String, Integer> fieldIndices;

    protected ClassAccess() {
        int i;
        int defaultConstructorIndex = -1;
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            if (this.constructorParamTypes[i].length != 0) continue;
            defaultConstructorIndex = i;
            break;
        }
        this.defaultConstructorIndex = defaultConstructorIndex;
        this.methodNames = this.buildMethodNames();
        this.methodParamTypes = this.buildMethodParamTypes();
        this.fieldNames = this.buildFieldNames();
        this.fieldTypes = this.buildFieldTypes();
        this.methodIndices = new HashMap<String, Integer>(2 * this.methodNames.length);
        this.fieldIndices = new HashMap<String, Integer>(2 * this.fieldNames.length);
        for (i = 0; i < this.methodNames.length; ++i) {
            this.methodIndices.put(this.methodNames[i], i);
        }
        for (i = 0; i < this.fieldNames.length; ++i) {
            this.fieldIndices.put(this.fieldNames[i], i);
        }
    }

    protected Class[][] buildConstructorParamTypes() {
        return new Class[0][0];
    }

    protected String[] buildMethodNames() {
        return new String[0];
    }

    protected Class[][][] buildMethodParamTypes() {
        return new Class[0][][];
    }

    protected Class[] buildMethodReturnTypes() {
        return new Class[0];
    }

    protected String[] buildFieldNames() {
        return new String[0];
    }

    protected Class[] buildFieldTypes() {
        return new Class[0];
    }

    public Object newIndexInstance(int index, Object ... args) {
        throw new IllegalArgumentException("Constructor not found");
    }

    public Object invokeIndexMethod(Object instance, int index, int overloadIndex, Object ... args) {
        throw new IllegalArgumentException("Method not found");
    }

    public Object getIndexField(Object instance, int index) {
        throw new IllegalArgumentException("Field not found");
    }

    public void setIndexField(Object instance, int index, Object value) {
        throw new IllegalArgumentException("Field not found");
    }

    public boolean containsDefaultConstructor() {
        return this.defaultConstructorIndex >= 0;
    }

    public boolean containsConstructor(Class ... types) {
        return this.getConstructorIndex(types) >= 0;
    }

    public T newInstance() {
        if (this.defaultConstructorIndex >= 0) {
            try {
                return (T)this.newIndexInstance(this.defaultConstructorIndex, new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Constructor not found");
    }

    public T newInstance(Class<?>[] types, Object ... args) {
        int index = this.getConstructorIndex(types);
        if (index < 0) {
            throw new IllegalArgumentException("Constructor not found");
        }
        try {
            return (T)this.newIndexInstance(index, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public T newInstance(Object ... args) {
        int index = this.getConstructorIndex(args);
        if (index < 0) {
            throw new IllegalArgumentException("Constructor not found");
        }
        try {
            return (T)this.newIndexInstance(index, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public T newInstanceOrNoop() {
        if (this.defaultConstructorIndex >= 0) {
            try {
                return (T)this.newIndexInstance(this.defaultConstructorIndex, new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public T newInstanceOrNoop(Class<?>[] types, Object ... args) {
        int index = this.getConstructorIndex(types);
        if (index < 0) {
            return null;
        }
        try {
            return (T)this.newIndexInstance(index, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public T newInstanceOrNoop(Object ... args) {
        int index = this.getConstructorIndex(args);
        if (index < 0) {
            return null;
        }
        try {
            return (T)this.newIndexInstance(index, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int getConstructorIndex(Class<?> ... types) {
        Class[] constructorParamType;
        int i;
        if (types == null || types.length == 0) {
            return this.defaultConstructorIndex;
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isEquals(constructorParamType, types)) continue;
            return i;
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isAssignable(constructorParamType, types)) continue;
            return i;
        }
        return -1;
    }

    public int getConstructorIndex(Object ... args) {
        if (args.length == 0) {
            return this.defaultConstructorIndex;
        }
        for (int i = 0; i < this.constructorParamTypes.length; ++i) {
            Class[] constructorParamType = this.constructorParamTypes[i];
            if (args.length != constructorParamType.length) continue;
            boolean matched = true;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null) continue;
                if (constructorParamType[j].isPrimitive()) {
                    if (constructorParamType[j].isInstance(args[j]) || Types.getWrapperClass(constructorParamType[j]).isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (constructorParamType[j].isInstance(args[j])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        throw new IllegalArgumentException("Constructor not found");
    }

    public Set<String> methodNames() {
        return Collections.unmodifiableSet(this.methodIndices.keySet());
    }

    public Map<String, Integer> methodIndices() {
        return Collections.unmodifiableMap(this.methodIndices);
    }

    public boolean containsMethod(String methodName) {
        return this.getMethodIndex(methodName) >= 0;
    }

    public boolean containsMethod(String methodName, Class ... paramTypes) {
        return this.getMethodIndex(methodName, paramTypes) != null;
    }

    public int[] getMethodIndex(String methodName, Class ... paramTypes) {
        Integer i = this.methodIndices.get(methodName);
        if (i == null) {
            return null;
        }
        int j = this.getMethodOverloadIndex((int)i, paramTypes);
        if (j < 0) {
            return null;
        }
        return new int[]{i, j};
    }

    private int getMethodIndex(String methodName) {
        Integer idx = this.methodIndices.get(methodName);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    private int getMethodOverloadIndex(int methodIdx, Class ... paramTypes) {
        if (methodIdx >= 0) {
            Class[] definedTypes;
            int i;
            Class[][] definedTypesArray = this.methodParamTypes[methodIdx];
            for (i = 0; i < definedTypesArray.length; ++i) {
                definedTypes = definedTypesArray[i];
                if (!Types.isEquals(definedTypes, paramTypes)) continue;
                return i;
            }
            for (i = 0; i < definedTypesArray.length; ++i) {
                definedTypes = definedTypesArray[i];
                if (!Types.isAssignable(definedTypes, paramTypes)) continue;
                return i;
            }
        }
        return -1;
    }

    private int getMethodOverloadIndex(int methodIdx, Object ... args) {
        if (methodIdx >= 0) {
            Class[][] definedTypesArray = this.methodParamTypes[methodIdx];
            for (int i = 0; i < definedTypesArray.length; ++i) {
                Class[] definedTypes = definedTypesArray[i];
                if (args.length != definedTypes.length) continue;
                boolean matched = true;
                for (int j = 0; j < args.length; ++j) {
                    if (args[j] == null) continue;
                    if (definedTypes[j].isPrimitive()) {
                        if (definedTypes[j].isInstance(args[j]) || Types.getWrapperClass(definedTypes[j]).isInstance(args[j])) continue;
                        matched = false;
                        break;
                    }
                    if (definedTypes[j].isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return i;
            }
        }
        return -1;
    }

    public Object invokeIndexMethod(Object object, int[] index, Object ... args) {
        try {
            return this.invokeIndexMethod(object, index[0], index[1], args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object invokeMethod(Object object, String methodName, Class[] paramTypes, Object ... args) {
        int methodIndex = this.getMethodIndex(methodName);
        if (methodIndex < 0) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName + " " + Arrays.toString(paramTypes));
        }
        int methodOverloadIndex = this.getMethodOverloadIndex(methodIndex, paramTypes);
        if (methodOverloadIndex < 0) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName + " " + Arrays.toString(paramTypes));
        }
        try {
            return this.invokeIndexMethod(object, methodIndex, methodOverloadIndex, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object invokeMethod(Object object, String methodName, Object ... args) {
        int methodIndex = this.getMethodIndex(methodName);
        if (methodIndex < 0) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName);
        }
        int methodOverloadIndex = this.getMethodOverloadIndex(methodIndex, args);
        if (methodOverloadIndex < 0) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName);
        }
        try {
            return this.invokeIndexMethod(object, methodIndex, methodOverloadIndex, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object invokeMethodOrNoop(Object object, String methodName, Class[] paramTypes, Object ... args) {
        int methodIndex = this.getMethodIndex(methodName);
        if (methodIndex < 0) {
            return null;
        }
        int methodOverloadIndex = this.getMethodOverloadIndex(methodIndex, paramTypes);
        if (methodOverloadIndex < 0) {
            return null;
        }
        try {
            return this.invokeIndexMethod(object, methodIndex, methodOverloadIndex, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object invokeMethodOrNoop(Object object, String methodName, Object ... args) {
        int methodIndex = this.getMethodIndex(methodName);
        if (methodIndex < 0) {
            return null;
        }
        int methodOverloadIndex = this.getMethodOverloadIndex(methodIndex, args);
        if (methodOverloadIndex < 0) {
            return null;
        }
        try {
            return this.invokeIndexMethod(object, methodIndex, methodOverloadIndex, args);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Set<String> fieldNames() {
        return Collections.unmodifiableSet(this.fieldIndices.keySet());
    }

    public Map<String, Integer> fieldIndices() {
        return Collections.unmodifiableMap(this.fieldIndices);
    }

    public boolean containsField(String fieldName) {
        return this.getFieldIndex(fieldName) >= 0;
    }

    private int getFieldIndex(String fieldName) {
        Integer idx = this.fieldIndices.get(fieldName);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    public Class getFieldType(String fieldName) {
        int i = this.getFieldIndex(fieldName);
        if (i < 0) {
            throw new IllegalArgumentException("Field not found\uff1a" + fieldName);
        }
        return this.fieldTypes[i];
    }

    public void setField(Object object, String fieldName, Object value) {
        int i = this.getFieldIndex(fieldName);
        if (i < 0) {
            throw new IllegalArgumentException("Field not found\uff1a" + fieldName);
        }
        this.setIndexField(object, i, value);
    }

    public Object getField(Object object, String fieldName) {
        int i = this.getFieldIndex(fieldName);
        if (i < 0) {
            throw new IllegalArgumentException("Field not found\uff1a" + fieldName);
        }
        return this.getIndexField(object, i);
    }

    public void setFieldOrNoop(Object object, String fieldName, Object value) {
        int i = this.getFieldIndex(fieldName);
        if (i < 0) {
            return;
        }
        this.setIndexField(object, i, value);
    }

    public Object getFieldOrNoop(Object object, String fieldName) {
        int i = this.getFieldIndex(fieldName);
        if (i < 0) {
            return null;
        }
        return this.getIndexField(object, i);
    }

    public static <T> ClassAccess<T> get(Class<T> type) {
        return pool.computeIfAbsent(type, ClassAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ClassAccess<T> create(Class<T> type) {
        ClassAccess access;
        Class accessClass;
        AccessClassLoader loader;
        String accessClassName = AccessClassLoader.buildAccessClassName(type, ClassAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                accessClass = ClassAccess.buildAccessClass(loader, accessClassName, type);
            }
        }
        try {
            access = (ClassAccess)accessClass.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
        return access;
    }

    private static <T> Class buildAccessClass(AccessClassLoader loader, String accessClassName, Class<T> type) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        String classNameInternal = type.getName().replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = ClassAccess.class.getName().replace('.', '/');
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        ClassAccess.insertConstructorInvokers(cw, accessClassNameInternal, type);
        ClassAccess.insertMethodInvokers(cw, accessClassNameInternal, type);
        ClassAccess.insertFieldInvokers(cw, accessClassNameInternal, type);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return loader.defineAccessClass(accessClassName, byteArray);
    }

    private static <T> void insertConstructorInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        ArrayList constructorList = new ArrayList();
        for (Constructor<?> declaredConstructor : type.getDeclaredConstructors()) {
            if (Modifier.isPrivate(declaredConstructor.getModifiers())) continue;
            constructorList.add(declaredConstructor);
        }
        int size = constructorList.size();
        SerializableFunction buildConstructorParamTypes = ClassAccess::buildConstructorParamTypes;
        SerializableTriFunction<ClassAccess, Integer, Object[], Object> newIndexInstance = ClassAccess::newIndexInstance;
        MethodVisitor methodVisitor = cw.visitMethod(1, buildConstructorParamTypes.serialized().getImplMethodName(), "()[[Ljava/lang/Class;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(size);
        methodVisitor.visitTypeInsn(189, "[Ljava/lang/Class;");
        methodVisitor.visitVarInsn(58, 1);
        for (int idx = 0; idx < size; ++idx) {
            Constructor constructor = (Constructor)constructorList.get(idx);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitIntInsn(16, idx);
            methodVisitor.visitIntInsn(16, len);
            methodVisitor.visitTypeInsn(189, "java/lang/Class");
            for (int idxParam = 0; idxParam < len; ++idxParam) {
                Class<?> parameterType = parameterTypes[idxParam];
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, idxParam);
                if (parameterType.isPrimitive()) {
                    methodVisitor.visitFieldInsn(178, Type.getInternalName(Types.getWrapperClass(parameterType)), "TYPE", "Ljava/lang/Class;");
                } else {
                    methodVisitor.visitLdcInsn(Type.getType(parameterType));
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        if (size > 0) {
            methodVisitor = cw.visitMethod(129, newIndexInstance.serialized().getImplMethodName(), "(I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(21, 1);
            Label[] labels = new Label[size];
            for (int idx = 0; idx < size; ++idx) {
                labels[idx] = new Label();
            }
            Label labelDefault = new Label();
            methodVisitor.visitTableSwitchInsn(0, size - 1, labelDefault, labels);
            for (int idx = 0; idx < size; ++idx) {
                Constructor constructor = (Constructor)constructorList.get(idx);
                boolean hasThrows = constructor.getExceptionTypes().length > 0;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                int len = parameterTypes.length;
                methodVisitor.visitLabel(labels[idx]);
                MethodVisitor mv = methodVisitor;
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                if (hasThrows) {
                    mv.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                    mv.visitLabel(labelStart);
                }
                mv.visitTypeInsn(187, Type.getInternalName(type));
                mv.visitInsn(89);
                for (int iParam = 0; iParam < len; ++iParam) {
                    Class<?> parameterType = parameterTypes[iParam];
                    mv.visitVarInsn(25, 2);
                    mv.visitIntInsn(16, iParam);
                    mv.visitInsn(50);
                    Type paramType = Type.getType(parameterType);
                    AsmUtils.autoUnBoxing(mv, paramType);
                }
                String constructorDescriptor = Type.getConstructorDescriptor(constructor);
                mv.visitMethodInsn(183, Type.getInternalName(type), "<init>", constructorDescriptor, false);
                if (hasThrows) {
                    mv.visitLabel(labelEnd);
                }
                methodVisitor.visitInsn(176);
                if (!hasThrows) continue;
                mv.visitLabel(labelCatch);
                mv.visitVarInsn(58, 2);
                mv.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
            methodVisitor.visitLabel(labelDefault);
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn("Constructor not found");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
            methodVisitor.visitInsn(191);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }

    private static <T> void insertMethodInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        int iName;
        SerializableFunctionWithArgs5<ClassAccess, Object, Integer, Integer, Object[], Object> invokeIndexMethod = ClassAccess::invokeIndexMethod;
        SerializableFunction buildMethodNames = ClassAccess::buildMethodNames;
        SerializableFunction buildMethodParamTypes = ClassAccess::buildMethodParamTypes;
        Map<String, List<Method>> declaredMethods = ClassAccess.getDeclaredMethods(type);
        Map.Entry[] methodEntryArray = declaredMethods.entrySet().toArray(new Map.Entry[0]);
        MethodVisitor methodVisitor = cw.visitMethod(4, buildMethodNames.serialized().getImplMethodName(), "()[Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(methodEntryArray.length);
        methodVisitor.visitTypeInsn(189, "java/lang/String");
        methodVisitor.visitVarInsn(58, 1);
        for (iName = 0; iName < methodEntryArray.length; ++iName) {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(iName);
            methodVisitor.visitLdcInsn(methodEntryArray[iName].getKey());
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4, buildMethodParamTypes.serialized().getImplMethodName(), "()[[[Ljava/lang/Class;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(methodEntryArray.length);
        methodVisitor.visitTypeInsn(189, "[[Ljava/lang/Class;");
        methodVisitor.visitVarInsn(58, 1);
        for (iName = 0; iName < methodEntryArray.length; ++iName) {
            Map.Entry entry = methodEntryArray[iName];
            List list = (List)entry.getValue();
            int count = list.size();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(iName);
            methodVisitor.visitLdcInsn(count);
            methodVisitor.visitTypeInsn(189, "[Ljava/lang/Class;");
            methodVisitor.visitInsn(83);
            for (int iOverload = 0; iOverload < count; ++iOverload) {
                Method method = (Method)list.get(iOverload);
                Class<?>[] parameterTypes = method.getParameterTypes();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn(iName);
                methodVisitor.visitInsn(50);
                methodVisitor.visitLdcInsn(iOverload);
                methodVisitor.visitLdcInsn(parameterTypes.length);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitInsn(83);
                for (int idxParams = 0; idxParams < parameterTypes.length; ++idxParams) {
                    Class<?> parameterType = parameterTypes[idxParams];
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitLdcInsn(iName);
                    methodVisitor.visitInsn(50);
                    methodVisitor.visitLdcInsn(iOverload);
                    methodVisitor.visitInsn(50);
                    methodVisitor.visitLdcInsn(idxParams);
                    if (parameterType.isPrimitive()) {
                        methodVisitor.visitFieldInsn(178, Type.getInternalName(Types.getWrapperClass(parameterType)), "TYPE", "Ljava/lang/Class;");
                    } else {
                        methodVisitor.visitLdcInsn(Type.getType(parameterType));
                    }
                    methodVisitor.visitInsn(83);
                }
            }
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        if (methodEntryArray.length > 0) {
            methodVisitor = cw.visitMethod(129, invokeIndexMethod.serialized().getImplMethodName(), "(Ljava/lang/Object;II[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(21, 2);
            Label[] labels = AsmUtils.newLabels(methodEntryArray.length);
            Label labelDefault = new Label();
            methodVisitor.visitTableSwitchInsn(0, methodEntryArray.length - 1, labelDefault, labels);
            for (int idxName = 0; idxName < methodEntryArray.length; ++idxName) {
                methodVisitor.visitLabel(labels[idxName]);
                Map.Entry entry = methodEntryArray[idxName];
                String methodName = (String)entry.getKey();
                List list = (List)entry.getValue();
                int count = list.size();
                if (count == 0) {
                    methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitLdcInsn("Method not found");
                    methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
                    methodVisitor.visitInsn(191);
                    continue;
                }
                Label[] labelsInner = AsmUtils.newLabels(count);
                Label labelInnerDefault = new Label();
                if (count > 1) {
                    methodVisitor.visitVarInsn(21, 3);
                    methodVisitor.visitTableSwitchInsn(0, count - 1, labelInnerDefault, labelsInner);
                }
                for (int idxOverload = 0; idxOverload < count; ++idxOverload) {
                    Method method;
                    if (count > 1) {
                        methodVisitor.visitLabel(labelsInner[idxOverload]);
                    }
                    boolean hasThrows = (method = (Method)list.get(idxOverload)).getExceptionTypes().length > 0;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    int paramCount = parameterTypes.length;
                    Label labelStart = new Label();
                    Label labelEnd = new Label();
                    Label labelCatch = new Label();
                    if (hasThrows) {
                        methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                        methodVisitor.visitLabel(labelStart);
                    }
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(type));
                    if (Modifier.isStatic(method.getModifiers())) {
                        methodVisitor.visitInsn(87);
                    }
                    for (int idxParams = 0; idxParams < paramCount; ++idxParams) {
                        Class<?> parameterType = parameterTypes[idxParams];
                        methodVisitor.visitVarInsn(25, 4);
                        methodVisitor.visitIntInsn(16, idxParams);
                        methodVisitor.visitInsn(50);
                        Type paramType = Type.getType(parameterType);
                        AsmUtils.autoUnBoxing(methodVisitor, paramType);
                    }
                    Class<?> declaringClass = method.getDeclaringClass();
                    boolean isInterface = declaringClass.isInterface();
                    int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
                    methodVisitor.visitMethodInsn(invokeOpcode, Type.getInternalName(declaringClass), methodName, Type.getMethodDescriptor(method), isInterface);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.equals(Void.TYPE)) {
                        methodVisitor.visitInsn(1);
                    } else {
                        AsmUtils.autoBoxing(methodVisitor, returnType);
                    }
                    if (hasThrows) {
                        methodVisitor.visitLabel(labelEnd);
                    }
                    methodVisitor.visitInsn(176);
                    if (!hasThrows) continue;
                    methodVisitor.visitLabel(labelCatch);
                    methodVisitor.visitVarInsn(58, 5);
                    methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitVarInsn(25, 5);
                    methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                    methodVisitor.visitInsn(191);
                }
                if (count <= 1) continue;
                methodVisitor.visitLabel(labelInnerDefault);
                methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn("Method not found");
                methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitInsn(191);
            }
            methodVisitor.visitLabel(labelDefault);
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn("Method not found");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
            methodVisitor.visitInsn(191);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }

    private static Map<String, List<Method>> getDeclaredMethods(Class type) {
        HashMap<String, Method> allMethods = new HashMap<String, Method>();
        boolean isInterface = type.isInterface();
        if (!isInterface) {
            for (Class nextClass = type; nextClass != null; nextClass = nextClass.getSuperclass()) {
                ClassAccess.recursiveAddMethodsToMap(nextClass, allMethods);
            }
        } else {
            ClassAccess.recursiveAddMethodsToMap(type, allMethods);
        }
        TreeMap<String, List<Method>> overloadMethods = new TreeMap<String, List<Method>>(Comparator.naturalOrder());
        allMethods.forEach((k, v) -> {
            List list = overloadMethods.computeIfAbsent(v.getName(), name -> new ArrayList());
            list.add(v);
        });
        return overloadMethods;
    }

    private static void recursiveAddMethodsToMap(Class interfaceType, Map<String, Method> methods) {
        for (Method method : interfaceType.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || Reflects.isFinalizeMethod(method) || Reflects.isNotifyMethod(method) || Reflects.isNotifyAllMethod(method) || Reflects.isWaitMethod(method) || Reflects.isCloneMethod(method) && method.getDeclaringClass() == Object.class) continue;
            methods.putIfAbsent(method.getName() + Type.getMethodDescriptor(method), method);
        }
        for (Class<?> nextInterface : interfaceType.getInterfaces()) {
            ClassAccess.recursiveAddMethodsToMap(nextInterface, methods);
        }
    }

    private static <T> void insertFieldInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        Type fieldType;
        Field field;
        String fieldName;
        Map.Entry entry;
        Map.Entry entry2;
        int idxField;
        TreeMap fields = new TreeMap(Comparator.naturalOrder());
        for (Class<T> nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field2 : nextClass.getDeclaredFields()) {
                int modifiers = field2.getModifiers();
                if (Modifier.isPrivate(modifiers)) continue;
                fields.putIfAbsent(field2.getName(), field2);
            }
        }
        SerializableFunction buildFieldNames = ClassAccess::buildFieldNames;
        SerializableFunction buildFieldTypes = ClassAccess::buildFieldTypes;
        SerializableTriFunction<ClassAccess, Object, Integer, Object> getIndexField = ClassAccess::getIndexField;
        SerializableConsumerWithArgs4<ClassAccess, Object, Integer, Object> setIndexField = ClassAccess::setIndexField;
        Map.Entry[] fieldEntryArray = fields.entrySet().toArray(new Map.Entry[0]);
        MethodVisitor methodVisitor = cw.visitMethod(4, buildFieldNames.serialized().getImplMethodName(), "()[Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(fieldEntryArray.length);
        methodVisitor.visitTypeInsn(189, "java/lang/String");
        methodVisitor.visitVarInsn(58, 1);
        for (idxField = 0; idxField < fieldEntryArray.length; ++idxField) {
            entry2 = fieldEntryArray[idxField];
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(idxField);
            methodVisitor.visitLdcInsn(entry2.getKey());
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4, buildFieldTypes.serialized().getImplMethodName(), "()[Ljava/lang/Class;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(fieldEntryArray.length);
        methodVisitor.visitTypeInsn(189, "java/lang/Class");
        methodVisitor.visitVarInsn(58, 1);
        for (idxField = 0; idxField < fieldEntryArray.length; ++idxField) {
            entry2 = fieldEntryArray[idxField];
            Class<?> fieldType2 = ((Field)entry2.getValue()).getType();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(idxField);
            if (fieldType2.isPrimitive()) {
                methodVisitor.visitFieldInsn(178, Type.getInternalName(Types.getWrapperClass(fieldType2)), "TYPE", "Ljava/lang/Class;");
            } else {
                methodVisitor.visitLdcInsn(Type.getType(fieldType2));
            }
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        if (fieldEntryArray.length > 0) {
            methodVisitor = cw.visitMethod(1, getIndexField.serialized().getImplMethodName(), "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(21, 2);
            Label[] labels = new Label[fieldEntryArray.length];
            for (int i = 0; i < fieldEntryArray.length; ++i) {
                labels[i] = new Label();
            }
            Label labelDefault = new Label();
            methodVisitor.visitTableSwitchInsn(0, fieldEntryArray.length - 1, labelDefault, labels);
            for (int idxField2 = 0; idxField2 < fieldEntryArray.length; ++idxField2) {
                methodVisitor.visitLabel(labels[idxField2]);
                entry = fieldEntryArray[idxField2];
                fieldName = (String)entry.getKey();
                field = (Field)entry.getValue();
                fieldType = Type.getType(field.getType());
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(type));
                if (Modifier.isStatic(field.getModifiers())) {
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitFieldInsn(178, Type.getInternalName(field.getDeclaringClass()), fieldName, Type.getDescriptor(field.getType()));
                } else {
                    methodVisitor.visitFieldInsn(180, Type.getInternalName(type), fieldName, Type.getDescriptor(field.getType()));
                }
                AsmUtils.autoBoxing(methodVisitor, fieldType);
                methodVisitor.visitInsn(176);
            }
            methodVisitor.visitLabel(labelDefault);
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn("Field not found");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
            methodVisitor.visitInsn(191);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        if (fieldEntryArray.length > 0) {
            methodVisitor = cw.visitMethod(1, setIndexField.serialized().getImplMethodName(), "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(21, 2);
            Label[] labels = new Label[fieldEntryArray.length];
            for (int i = 0; i < fieldEntryArray.length; ++i) {
                labels[i] = new Label();
            }
            Label labelDefault = new Label();
            methodVisitor.visitTableSwitchInsn(0, fieldEntryArray.length - 1, labelDefault, labels);
            for (int idxField3 = 0; idxField3 < fieldEntryArray.length; ++idxField3) {
                methodVisitor.visitLabel(labels[idxField3]);
                entry = fieldEntryArray[idxField3];
                fieldName = (String)entry.getKey();
                field = (Field)entry.getValue();
                fieldType = Type.getType(field.getType());
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(type));
                if (Modifier.isStatic(field.getModifiers())) {
                    methodVisitor.visitInsn(87);
                }
                methodVisitor.visitVarInsn(25, 3);
                AsmUtils.autoUnBoxing(methodVisitor, fieldType);
                if (Modifier.isStatic(field.getModifiers())) {
                    methodVisitor.visitFieldInsn(179, Type.getInternalName(field.getDeclaringClass()), fieldName, fieldType.getDescriptor());
                } else {
                    methodVisitor.visitFieldInsn(181, Type.getInternalName(field.getDeclaringClass()), fieldName, fieldType.getDescriptor());
                }
                methodVisitor.visitInsn(177);
            }
            methodVisitor.visitLabel(labelDefault);
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn("Field not found");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
            methodVisitor.visitInsn(191);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }
}

