/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.cache;

import io.polaris.core.cache.AbstractCacheManager;
import io.polaris.core.cache.ICache;
import io.polaris.core.cache.MapCache;
import io.polaris.core.string.Strings;

public class MapCacheManager
extends AbstractCacheManager {
    public static final int DEFAULT_MAX_CAPACITY = 10240;
    public static final String KEY_MAX_CAPACITY = MapCacheManager.class.getName() + ".maxCapacity";
    public static final String KEY_ACCESS_ORDER = MapCacheManager.class.getName() + ".accessOrder";
    private int maxCapacity = 10240;
    private boolean accessOrder;

    public MapCacheManager() {
        this.init();
    }

    private void init() {
        String val = System.getProperty(KEY_MAX_CAPACITY);
        if (Strings.isNotBlank(val)) {
            try {
                this.maxCapacity = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Strings.isNotBlank(val = System.getProperty(KEY_ACCESS_ORDER))) {
            this.accessOrder = Boolean.parseBoolean(val);
        }
    }

    @Override
    protected <K, V> ICache<K, V> createCache(String name) {
        if (this.maxCapacity > 0) {
            return new MapCache(this.maxCapacity, this.accessOrder);
        }
        return new MapCache();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public boolean isAccessOrder() {
        return this.accessOrder;
    }

    public void setAccessOrder(boolean accessOrder) {
        this.accessOrder = accessOrder;
    }
}

