/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compiler;

import io.polaris.core.compiler.MemoryClassLoader;
import io.polaris.core.compiler.MemoryJavaFileObject;
import io.polaris.core.compiler.MemoryStreamableJavaFileObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class MemoryJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final MemoryClassLoader classLoader;
    private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

    public MemoryJavaFileManager(JavaFileManager fileManager, MemoryClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        URI uri = URI.create(location.getName() + '/' + packageName.replace('.', '/') + '/' + relativeName + JavaFileObject.Kind.SOURCE.extension);
        FileObject o = this.fileObjects.get(uri);
        if (o != null) {
            return o;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    public void putFileForInput(StandardLocation location, String classFullName, JavaFileObject file) {
        URI uri = URI.create(location.getName() + '/' + classFullName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
        this.fileObjects.put(uri, file);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        URI uri = URI.create(qualifiedName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
        MemoryStreamableJavaFileObject file = new MemoryStreamableJavaFileObject(uri, kind);
        this.classLoader.add(qualifiedName, file);
        return file;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof MemoryJavaFileObject) {
            return file.getName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
            files.addAll(this.classLoader.files());
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
        }
        for (JavaFileObject file : result) {
            files.add(file);
        }
        return files;
    }
}

