/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupThreadFactory
implements ThreadFactory {
    private static Map<String, AtomicInteger> poolNumbers = new ConcurrentHashMap<String, AtomicInteger>();
    private String prefix;
    private AtomicInteger count = new AtomicInteger(0);
    private boolean daemon;

    private GroupThreadFactory(String prefix, boolean daemon) {
        AtomicInteger poolNumber = poolNumbers.computeIfAbsent(prefix, key -> new AtomicInteger(0));
        int n = poolNumber.getAndIncrement();
        this.prefix = n == 0 ? prefix + "-" : prefix + "-" + n + "-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.prefix + this.count.incrementAndGet());
        if (this.daemon) {
            t.setDaemon(true);
        }
        return t;
    }

    public static GroupThreadFactory newInstance(String prefix) {
        return new GroupThreadFactory(prefix, false);
    }

    public static GroupThreadFactory newInstance(String prefix, boolean daemon) {
        return new GroupThreadFactory(prefix, daemon);
    }
}

