/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class PooledThreadFactory
implements ThreadFactory {
    private static AtomicInteger poolNumber = new AtomicInteger(0);
    private final AtomicInteger tid = new AtomicInteger(0);
    private final int pid = poolNumber.incrementAndGet();
    private String prefix;
    private boolean daemon;
    private boolean withPoolNumber = true;

    public PooledThreadFactory() {
    }

    public PooledThreadFactory(String prefix) {
        this();
        this.prefix = prefix;
    }

    public PooledThreadFactory withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public PooledThreadFactory withPoolNumber() {
        this.withPoolNumber = true;
        return this;
    }

    public PooledThreadFactory withPoolNumber(boolean withPoolNumber) {
        this.withPoolNumber = withPoolNumber;
        return this;
    }

    public PooledThreadFactory withDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, (this.prefix == null ? "pool" : this.prefix) + (this.withPoolNumber ? "-" + this.pid + "-" : "-") + this.tid.incrementAndGet());
        t.setDaemon(this.daemon);
        return t;
    }
}

