/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.Converter;
import io.polaris.core.lang.JavaType;
import java.lang.reflect.Type;

public abstract class AbstractConverter<T>
implements Converter<T> {
    public JavaType<T> getTargetType() {
        Type actualType = JavaType.of(this.getClass()).getActualType(Converter.class, 0);
        return JavaType.of(actualType);
    }

    @Override
    public final <S> T convert(Type valueType, S value) {
        return this.convert(JavaType.of(valueType), value);
    }

    @Override
    public final <S> T convert(S value) {
        return this.convert(value.getClass(), value);
    }

    @Override
    public final <S> T convertOrDefault(Type valueType, S value, T defaultValue) {
        T t = this.convert(valueType, value);
        if (t == null) {
            t = defaultValue;
        }
        return t;
    }

    @Override
    public final <S> T convertOrDefault(S value, T defaultValue) {
        return this.convertOrDefault(value.getClass(), value, defaultValue);
    }

    public final <S> T convert(JavaType<S> valueType, S value) {
        if (value == null) {
            Class<S> rawClass = valueType.getRawClass();
            if (rawClass.isPrimitive()) {
                if (Long.TYPE == rawClass) {
                    return (T)Long.valueOf(0L);
                }
                if (Boolean.TYPE == rawClass) {
                    return (T)Boolean.FALSE;
                }
                if (Character.TYPE == rawClass) {
                    return (T)Character.valueOf('\u0000');
                }
                if (Byte.TYPE == rawClass) {
                    return (T)Byte.valueOf((byte)0);
                }
                if (Short.TYPE == rawClass) {
                    return (T)Short.valueOf((short)0);
                }
                if (Integer.TYPE == rawClass) {
                    return (T)Integer.valueOf(0);
                }
                if (Float.TYPE == rawClass) {
                    return (T)Float.valueOf(0.0f);
                }
                if (Double.TYPE == rawClass) {
                    return (T)Double.valueOf(0.0);
                }
            }
            return null;
        }
        JavaType<T> targetType = this.getTargetType();
        if (valueType.getRawType() == targetType.getRawType()) {
            return targetType.cast(value);
        }
        if (targetType.getRawType() instanceof Class && targetType.isInstance(value)) {
            return targetType.cast(value);
        }
        return this.doConvert(value, targetType, valueType);
    }

    protected abstract <S> T doConvert(S var1, JavaType<T> var2, JavaType<S> var3);
}

